/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.editor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.pde.BNDInstructions;
import org.eclipse.m2e.pde.MavenTargetLocation;
import org.eclipse.m2e.pde.MavenTargetRepository;
import org.eclipse.m2e.pde.MissingMetadataMode;
import org.eclipse.m2e.pde.ui.editor.MavenArtifactInstructionsWizard;
import org.eclipse.m2e.pde.ui.editor.MavenTargetDependencyEditor;
import org.eclipse.m2e.pde.ui.editor.MavenTargetRepositoryEditor;
import org.eclipse.m2e.pde.ui.editor.Messages;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.ui.target.ITargetLocationWizard;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MavenTargetLocationWizard
extends Wizard
implements ITargetLocationWizard {
    private MavenTargetLocation targetLocation;
    private CCombo scope;
    private ComboViewer metadata;
    private ITargetDefinition targetDefinition;
    private BNDInstructions bndInstructions;
    private Button includeSource;
    private MavenTargetDependencyEditor dependencyEditor;
    private List<MavenTargetRepository> repositoryList = new ArrayList<MavenTargetRepository>();

    public MavenTargetLocationWizard() {
        this(null);
    }

    public MavenTargetLocationWizard(final MavenTargetLocation targetLocation) {
        this.targetLocation = targetLocation;
        this.setWindowTitle(Messages.MavenTargetLocationWizard_0);
        if (targetLocation != null) {
            for (MavenTargetRepository mavenTargetRepository : targetLocation.getExtraRepositories()) {
                this.repositoryList.add(mavenTargetRepository.copy());
            }
        }
        WizardPage page = new WizardPage(targetLocation == null ? Messages.MavenTargetLocationWizard_1 : Messages.MavenTargetLocationWizard_2){
            private Link editInstructionsButton;
            private Label scopeLabel;

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                this.setControl((Control)composite);
                composite.setLayout((Layout)new GridLayout(2, false));
                MavenTargetLocationWizard.this.createRepositoryLink(composite);
                MavenTargetLocationWizard.this.dependencyEditor = new MavenTargetDependencyEditor(composite, targetLocation == null ? Collections.emptyList() : targetLocation.getRoots());
                GridData gd_dep = new GridData(1808);
                gd_dep.horizontalSpan = 2;
                gd_dep.heightHint = 200;
                MavenTargetLocationWizard.this.dependencyEditor.getControl().setLayoutData((Object)gd_dep);
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_9);
                this.createMetadataCombo(composite);
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_10);
                this.createScopeCombo(composite);
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_8);
                MavenTargetLocationWizard.this.includeSource = new Button(composite, 32);
                if (targetLocation != null) {
                    MavenTargetLocationWizard.this.scope.setText(targetLocation.getDependencyScope());
                    MavenTargetLocationWizard.this.metadata.setSelection((ISelection)new StructuredSelection((Object)targetLocation.getMetadataMode()));
                    MavenTargetLocationWizard.this.bndInstructions = targetLocation.getInstructions(null);
                    MavenTargetLocationWizard.this.includeSource.setSelection(targetLocation.isIncludeSource());
                } else {
                    MavenTargetLocationWizard.this.metadata.setSelection((ISelection)new StructuredSelection((Object)MavenTargetLocation.DEFAULT_METADATA_MODE));
                    MavenTargetLocationWizard.this.bndInstructions = new BNDInstructions("", null);
                    MavenTargetLocationWizard.this.includeSource.setSelection(true);
                }
                this.updateUI();
            }

            private void createScopeCombo(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.horizontalSpacing = 20;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
                MavenTargetLocationWizard.this.scope = this.combo(new CCombo(composite, 2048));
                this.scopeLabel = new Label(composite, 0);
                this.scopeLabel.setText(Messages.MavenTargetLocationWizard_15);
                MavenTargetLocationWizard.this.scope.add("");
                MavenTargetLocationWizard.this.scope.add("compile");
                MavenTargetLocationWizard.this.scope.add("test");
                MavenTargetLocationWizard.this.scope.add("provided");
                MavenTargetLocationWizard.this.scope.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.updateUI();
                    }
                });
            }

            private void createMetadataCombo(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.horizontalSpacing = 20;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
                MavenTargetLocationWizard.this.metadata = new ComboViewer(this.combo(new CCombo(composite, 2056)));
                MavenTargetLocationWizard.this.metadata.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                MavenTargetLocationWizard.this.metadata.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof MissingMetadataMode) {
                            return ((MissingMetadataMode)element).name().toLowerCase();
                        }
                        return super.getText(element);
                    }
                });
                this.editInstructionsButton = new Link(composite, 8);
                this.editInstructionsButton.setText(Messages.MavenTargetLocationWizard_20);
                this.editInstructionsButton.setToolTipText(Messages.MavenTargetLocationWizard_21);
                this.editInstructionsButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        BNDInstructions edited = MavenArtifactInstructionsWizard.openWizard(this.getShell(), Objects.requireNonNullElse((this).MavenTargetLocationWizard.this.bndInstructions, BNDInstructions.EMPTY));
                        if (edited != null) {
                            (this).MavenTargetLocationWizard.this.bndInstructions = edited;
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                MavenTargetLocationWizard.this.metadata.setInput((Object)MissingMetadataMode.values());
                MavenTargetLocationWizard.this.metadata.addSelectionChangedListener(e -> this.updateUI());
            }

            private void updateUI() {
                this.editInstructionsButton.setVisible(MavenTargetLocationWizard.this.metadata.getStructuredSelection().getFirstElement() == MissingMetadataMode.GENERATE);
                this.scopeLabel.setVisible(MavenTargetLocationWizard.this.scope.getText().isBlank());
            }

            private CCombo combo(CCombo combo) {
                GridData data = new GridData();
                data.widthHint = 100;
                combo.setLayoutData((Object)data);
                return combo;
            }
        };
        page.setImageDescriptor(ImageDescriptor.createFromURL((URL)MavenTargetLocationWizard.class.getResource("/icons/new_m2_project_wizard.gif")));
        page.setTitle(page.getName());
        page.setDescription(Messages.MavenTargetLocationWizard_23);
        this.addPage((IWizardPage)page);
    }

    public void setTarget(ITargetDefinition target) {
        this.targetDefinition = target;
    }

    public ITargetLocation[] getLocations() {
        return new ITargetLocation[]{this.targetLocation};
    }

    public boolean performFinish() {
        List<Object> list;
        Collection<Object> excludes;
        if (this.targetLocation == null) {
            excludes = Collections.emptyList();
            list = this.bndInstructions == null ? Collections.emptyList() : Collections.singletonList(this.bndInstructions);
        } else {
            excludes = this.targetLocation.getExcludes();
            list = new ArrayList();
            for (BNDInstructions instruction : this.targetLocation.getInstructions()) {
                if (instruction.getKey().isBlank()) continue;
                list.add(instruction);
            }
            if (this.bndInstructions != null) {
                list.add(this.bndInstructions);
            }
        }
        MavenTargetLocation location = new MavenTargetLocation(this.dependencyEditor.getRoots(), this.repositoryList, (MissingMetadataMode)this.metadata.getStructuredSelection().getFirstElement(), this.scope.getText(), this.includeSource.getSelection(), list, excludes);
        if (this.targetLocation == null) {
            this.targetLocation = location;
        } else {
            ITargetLocation[] locations = (ITargetLocation[])this.targetDefinition.getTargetLocations().clone();
            int i = 0;
            while (i < locations.length) {
                if (locations[i] == this.targetLocation) {
                    locations[i] = location;
                }
                ++i;
            }
            this.targetDefinition.setTargetLocations(locations);
        }
        return true;
    }

    private void createRepositoryLink(final Composite composite) {
        GridData gd_link = new GridData();
        gd_link.horizontalSpan = 2;
        Link link = new Link(composite, 0);
        link.setText(Messages.MavenTargetLocationWizard_12);
        link.setLayoutData((Object)gd_link);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if ("#maven".equals(e.text)) {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)"org.eclipse.m2e.core.preferences.MavenSettingsPreferencePage", (String[])new String[]{"org.eclipse.m2e.core.preferences.MavenSettingsPreferencePage", "org.eclipse.m2e.core.preferences.MavenInstallationsPreferencePage", "org.eclipse.m2e.core.preferences.MavenArchetypesPreferencePage", "org.eclipse.m2e.core.ui.preferences.UserInterfacePreferencePage", "org.eclipse.m2e.core.ui.preferences.WarningsPreferencePage", "org.eclipse.m2e.core.preferences.LifecycleMappingPreferencePag"}, null);
                    dialog.open();
                } else if ("#configure".equals(e.text)) {
                    MavenTargetRepositoryEditor editor = new MavenTargetRepositoryEditor(composite.getShell(), MavenTargetLocationWizard.this.repositoryList);
                    editor.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
}

