/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.view.servers.StartAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopAction;

public abstract class AbstractBundleEditorPage
extends ServerEditorPart {
    private StartServerAction debugAction;
    private StartServerAction runAction;
    private IServerListener serverListener;
    private StopServerAction stopAction;
    protected ManagedForm mform;
    protected ScrolledForm sform;

    public final void createPartControl(Composite parent) {
        this.createBundleContent(parent);
        IToolBarManager toolBarManager = this.sform.getToolBarManager();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        this.debugAction = new StartServerAction("debug");
        toolBarManager.add((IAction)this.debugAction);
        this.runAction = new StartServerAction("run");
        toolBarManager.add((IAction)this.runAction);
        this.stopAction = new StopServerAction();
        toolBarManager.add((IAction)this.stopAction);
        toolBarManager.update(true);
        if (this.server.getOriginal().getServerState() != 2) {
            this.disablePage();
        } else {
            this.enablePage();
        }
    }

    public void dispose() {
        this.getServer().getOriginal().removeServerListener(this.serverListener);
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.serverListener = new PageEnablementServerListener();
        this.getServer().getOriginal().addServerListener(this.serverListener);
    }

    public void setFocus() {
    }

    protected abstract void createBundleContent(Composite var1);

    protected void disablePage() {
        this.setInfoStatus("Server '" + this.getServer().getName() + "' is not running.");
        this.setEnabled((Control)this.sform.getForm().getBody(), false);
        this.runAction.setEnabled(true);
        this.debugAction.setEnabled(true);
        this.stopAction.setEnabled(false);
    }

    protected void enablePage() {
        this.clearStatus();
        this.setEnabled((Control)this.sform.getForm().getBody(), true);
        this.runAction.setEnabled(false);
        this.debugAction.setEnabled(false);
        this.stopAction.setEnabled(true);
    }

    protected void setEnabled(Control control, boolean enabled) {
        control.setEnabled(enabled);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                this.setEnabled(childControl, enabled);
                ++n2;
            }
        }
    }

    public void setStatus(IStatus status) {
        this.sform.getForm().setMessage(status.getMessage(), this.getMessageType(status));
    }

    public void setInfoStatus(String message) {
        this.sform.getForm().setMessage(message, 1);
    }

    public void clearStatus() {
        this.sform.getForm().setMessage(null);
    }

    private int getMessageType(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    class PageEnablementServerListener
    implements IServerListener {
        PageEnablementServerListener() {
        }

        public void serverChanged(final ServerEvent event) {
            if ((event.getKind() & 0x10) != 0 && (event.getKind() & 1) != 0) {
                AbstractBundleEditorPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (event.getState() == 2) {
                            AbstractBundleEditorPage.this.enablePage();
                        } else {
                            AbstractBundleEditorPage.this.disablePage();
                        }
                        ((PageEnablementServerListener)PageEnablementServerListener.this).AbstractBundleEditorPage.this.sform.getToolBarManager().update(true);
                    }
                });
            }
        }
    }

    class StartServerAction
    extends Action {
        private final String launchMode;

        public StartServerAction(String launchMode) {
            this.launchMode = launchMode;
            if (launchMode == "run") {
                this.setToolTipText(Messages.actionStartToolTip);
                this.setText(Messages.actionStart);
                this.setImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_ELCL_START"));
                this.setHoverImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_CLCL_START"));
                this.setDisabledImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_DLCL_START"));
            } else if (launchMode == "debug") {
                this.setToolTipText(Messages.actionDebugToolTip);
                this.setText(Messages.actionDebug);
                this.setImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_ELCL_START_DEBUG"));
                this.setHoverImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_CLCL_START_DEBUG"));
                this.setDisabledImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_DLCL_START_DEBUG"));
            }
        }

        public void run() {
            if (AbstractBundleEditorPage.this.getServer().getOriginal().canStart(this.launchMode).isOK()) {
                StartAction.start((IServer)AbstractBundleEditorPage.this.getServer().getOriginal(), (String)this.launchMode, (Shell)AbstractBundleEditorPage.this.getSite().getShell());
            }
        }
    }

    class StopServerAction
    extends Action {
        public StopServerAction() {
            this.setToolTipText(Messages.actionStopToolTip);
            this.setImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_ELCL_STOP"));
            this.setHoverImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_CLCL_STOP"));
            this.setDisabledImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_DLCL_STOP"));
        }

        public void run() {
            if (AbstractBundleEditorPage.this.getServer().getOriginal().canStop().isOK()) {
                StopAction.stop((IServer)AbstractBundleEditorPage.this.getServer().getOriginal(), (Shell)AbstractBundleEditorPage.this.getSite().getShell());
            }
        }
    }
}

