/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.prefs;

import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class PreferencePropertyValueModel<P>
extends AspectAdapter<Preferences, P>
implements ModifiablePropertyValueModel<P> {
    protected final String key;
    protected P value;
    protected final P defaultValue;
    protected final Transformer<String, P> stringTransformer;
    protected final Transformer<P, String> objectTransformer;
    protected final PreferenceChangeListener preferenceChangeListener;

    public static PreferencePropertyValueModel<String> forString(Preferences preferences, String key, String defaultValue) {
        return new PreferencePropertyValueModel<String>(preferences, key, defaultValue, TransformerTools.passThruTransformer());
    }

    public static PreferencePropertyValueModel<String> forString(PropertyValueModel<? extends Preferences> preferencesModel, String key, String defaultValue) {
        return new PreferencePropertyValueModel<String>(preferencesModel, key, defaultValue, TransformerTools.passThruTransformer());
    }

    public static PreferencePropertyValueModel<Boolean> forBoolean(Preferences preferences, String key, boolean defaultValue) {
        return new PreferencePropertyValueModel<Boolean>(preferences, key, defaultValue ? Boolean.TRUE : Boolean.FALSE, TransformerTools.stringToBooleanTransformer());
    }

    public static PreferencePropertyValueModel<Boolean> forBoolean(PropertyValueModel<? extends Preferences> preferencesModel, String key, boolean defaultValue) {
        return new PreferencePropertyValueModel<Boolean>(preferencesModel, key, defaultValue ? Boolean.TRUE : Boolean.FALSE, TransformerTools.stringToBooleanTransformer());
    }

    public static PreferencePropertyValueModel<Integer> forInteger(Preferences preferences, String key, int defaultValue) {
        return new PreferencePropertyValueModel<Integer>(preferences, key, Integer.valueOf(defaultValue), TransformerTools.stringToIntegerTransformer());
    }

    public static PreferencePropertyValueModel<Integer> forInteger(PropertyValueModel<? extends Preferences> preferencesModel, String key, int defaultValue) {
        return new PreferencePropertyValueModel<Integer>(preferencesModel, key, Integer.valueOf(defaultValue), TransformerTools.stringToIntegerTransformer());
    }

    public PreferencePropertyValueModel(Preferences preferences, String key, P defaultValue, Transformer<String, P> stringTransformer) {
        this(new StaticPropertyValueModel<Preferences>(preferences), key, defaultValue, stringTransformer);
    }

    public PreferencePropertyValueModel(PropertyValueModel<? extends Preferences> preferencesModel, String key, P defaultValue, Transformer<String, P> stringTransformer) {
        this(preferencesModel, key, defaultValue, stringTransformer, TransformerTools.objectToStringTransformer());
    }

    public PreferencePropertyValueModel(PropertyValueModel<? extends Preferences> preferencesModel, String key, P defaultValue, Transformer<String, P> stringTransformer, Transformer<P, String> objectTransformer) {
        super(preferencesModel);
        if (key == null || stringTransformer == null || objectTransformer == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.defaultValue = defaultValue;
        this.stringTransformer = stringTransformer;
        this.objectTransformer = objectTransformer;
        this.preferenceChangeListener = this.buildPreferenceChangeListener();
        this.value = null;
    }

    protected PreferenceChangeListener buildPreferenceChangeListener() {
        return new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent event) {
                PreferencePropertyValueModel.this.preferenceChanged(event.getKey(), event.getNewValue());
            }

            public String toString() {
                return "preference change listener";
            }
        };
    }

    @Override
    public synchronized P getValue() {
        return this.value;
    }

    @Override
    public synchronized void setValue(P value) {
        if (this.hasNoListeners()) {
            return;
        }
        P old = this.value;
        this.value = value;
        this.fireAspectChanged(old, value);
        if (this.subject != null && this.preferenceIsToBeSet(old, value)) {
            this.setValue_(value);
        }
    }

    @Override
    protected synchronized P getAspectValue() {
        return this.value;
    }

    @Override
    protected Class<? extends EventListener> getListenerClass() {
        return PropertyChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "value";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    @Override
    protected void fireAspectChanged(Object oldValue, Object newValue) {
        this.firePropertyChanged("value", oldValue, newValue);
    }

    @Override
    protected synchronized void engageSubject_() {
        ((Preferences)this.subject).addPreferenceChangeListener(this.preferenceChangeListener);
        this.value = this.buildValue();
    }

    @Override
    protected synchronized void disengageSubject_() {
        block2: {
            try {
                ((Preferences)this.subject).removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().equals("Node has been removed.")) break block2;
                throw ex;
            }
        }
        this.value = null;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.key);
        sb.append(" => ");
        sb.append(this.value);
    }

    public String getKey() {
        return this.key;
    }

    protected P buildValue() {
        return this.subject == null ? null : (P)this.buildValue_();
    }

    protected P buildValue_() {
        return this.convertToObject(((Preferences)this.subject).get(this.key, this.convertToString(this.defaultValue)));
    }

    protected void setValue_(P value) {
        ((Preferences)this.subject).put(this.key, this.convertToString(value));
    }

    protected boolean preferenceIsToBeSet(Object oldValue, Object newValue) {
        return ObjectTools.notEquals(oldValue, newValue);
    }

    protected String convertToString(P o) {
        return this.objectTransformer.transform(o);
    }

    protected P convertToObject(String s) {
        return this.stringTransformer.transform(s);
    }

    protected void preferenceChanged(String prefKey, String newValue) {
        if (prefKey.equals(this.key)) {
            this.preferenceChanged();
        }
    }

    protected synchronized void preferenceChanged() {
        P old = this.value;
        this.value = this.buildValue();
        this.fireAspectChanged(old, this.value);
    }
}

