/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import org.apache.lucene.analysis.Analyzer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.AnalyzerFactory;
import org.eclipse.help.internal.search.DefaultAnalyzer;
import org.eclipse.help.internal.search.SmartAnalyzer;
import org.osgi.framework.Version;

public class AnalyzerDescriptor {
    private Analyzer luceneAnalyzer;
    private String id;
    private String lang;

    public AnalyzerDescriptor(String locale) {
        this.luceneAnalyzer = this.createAnalyzer(locale);
        if (this.luceneAnalyzer == null) {
            String language = null;
            if (locale.length() > 2) {
                language = locale.substring(0, 2);
                this.luceneAnalyzer = this.createAnalyzer(language);
            }
        }
        if (this.luceneAnalyzer == null) {
            this.id = "org.eclipse.help.base#" + (String)HelpBasePlugin.getDefault().getBundle().getHeaders().get("Bundle-Version") + "?locale=" + locale;
            this.luceneAnalyzer = new DefaultAnalyzer(locale);
            this.lang = locale;
        }
    }

    public Analyzer getAnalyzer() {
        return new SmartAnalyzer(this.lang, this.luceneAnalyzer);
    }

    public String getId() {
        return this.id;
    }

    public String getLang() {
        return this.lang;
    }

    public String getAnalyzerClassName() {
        return this.luceneAnalyzer.getClass().getName();
    }

    private Analyzer createAnalyzer(String locale) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.help.base", "luceneAnalyzer");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                String analyzerLocale;
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                if (configElement.getName().equals("analyzer") && (analyzerLocale = configElement.getAttribute("locale")) != null && analyzerLocale.equals(locale)) {
                    try {
                        Object analyzer = configElement.createExecutableExtension("class");
                        if (analyzer instanceof AnalyzerFactory) {
                            this.luceneAnalyzer = ((AnalyzerFactory)analyzer).create();
                        } else {
                            if (!(analyzer instanceof Analyzer)) break block8;
                            this.luceneAnalyzer = (Analyzer)analyzer;
                        }
                        String pluginId = configElement.getContributor().getName();
                        String pluginVersion = (String)Platform.getBundle((String)pluginId).getHeaders().get("Bundle-Version");
                        this.id = String.valueOf(pluginId) + "#" + pluginVersion + "?locale=" + locale;
                        this.lang = locale;
                        if (!"org.eclipse.help.base".equals(pluginId)) {
                            return this.luceneAnalyzer;
                        }
                    }
                    catch (CoreException ce) {
                        Platform.getLog(this.getClass()).error("Exception occurred creating text analyzer " + configElement.getAttribute("class") + " for " + locale + " locale.", (Throwable)ce);
                    }
                }
            }
            ++n2;
        }
        return this.luceneAnalyzer;
    }

    public boolean isCompatible(String analyzerId) {
        if (analyzerId != null) {
            int numberSignIndex = analyzerId.indexOf(35);
            int questionMarkIndex = analyzerId.indexOf(63, numberSignIndex);
            String pluginId = analyzerId.substring(0, numberSignIndex);
            String version = analyzerId.substring(numberSignIndex + 1, questionMarkIndex);
            String locale = analyzerId.substring(questionMarkIndex + 1 + "locale=".length());
            String thisPluginId = this.id.substring(0, this.id.indexOf(35));
            if (!"org.eclipse.help.base".equals(pluginId) || !"org.eclipse.help.base".equals(thisPluginId)) {
                return false;
            }
            Version vA = this.getVersion(this.id);
            Version vB = new Version(version);
            Version v3_1 = new Version(3, 1, 0);
            if (vA.compareTo(v3_1) < 0 && vB.compareTo(v3_1) < 0) {
                return false;
            }
            return this.lang.substring(0, 2).equals(locale.substring(0, 2));
        }
        return false;
    }

    private Version getVersion(String id) {
        int idStart = id.indexOf(35);
        int idStop = id.indexOf(63);
        String value = idStop == -1 ? id.substring(idStart + 1) : id.substring(idStart + 1, idStop);
        return new Version(value);
    }
}

