/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSession;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;

public class GetRemoteSessionsRequest
extends CDOClientRequest<List<CDORemoteSession>> {
    private boolean subscribe;

    public GetRemoteSessionsRequest(CDOClientProtocol protocol, boolean subscribe) {
        super(protocol, (short)28);
        this.subscribe = subscribe;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeBoolean(this.subscribe);
    }

    @Override
    protected List<CDORemoteSession> confirming(CDODataInput in) throws IOException {
        int sessionID;
        ArrayList<CDORemoteSession> result = new ArrayList<CDORemoteSession>();
        while ((sessionID = in.readXInt()) != -1) {
            String userID = in.readString();
            boolean subscribed = in.readBoolean();
            InternalCDORemoteSessionManager manager = this.getSession().getRemoteSessionManager();
            InternalCDORemoteSession remoteSession = manager.createRemoteSession(sessionID, userID, subscribed);
            result.add((CDORemoteSession)remoteSession);
        }
        return result;
    }
}

