/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.progress.IProgressConstants;
import org.eclipse.e4.ui.progress.internal.AnimationItem;
import org.eclipse.e4.ui.progress.internal.AnimationManager;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.ImageTools;
import org.eclipse.e4.ui.progress.internal.JobInfo;
import org.eclipse.e4.ui.progress.internal.JobTreeElement;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.e4.ui.progress.internal.ProgressRegion;
import org.eclipse.e4.ui.progress.internal.Services;
import org.eclipse.e4.ui.progress.internal.legacy.PlatformUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ProgressAnimationItem
extends AnimationItem
implements FinishedJobs.KeptJobsListener {
    ProgressBar bar;
    MouseListener mouseListener;
    Composite top;
    ToolBar toolbar;
    ToolItem toolButton;
    ProgressRegion progressRegion;
    Image noneImage;
    Image okImage;
    Image errorImage;
    boolean animationRunning;
    private int flags;
    private FinishedJobs finishedJobs;

    ProgressAnimationItem(ProgressRegion region, int flags, AnimationManager animationManager, FinishedJobs finishedJobs) {
        super(animationManager);
        this.flags = flags;
        this.finishedJobs = finishedJobs;
        finishedJobs.addListener(this);
        this.progressRegion = region;
        this.mouseListener = MouseListener.mouseDoubleClickAdapter(e -> this.doAction());
    }

    void doAction() {
        JobTreeElement[] jobTreeElements = this.finishedJobs.getKeptElements();
        int i = jobTreeElements.length - 1;
        while (i >= 0) {
            JobInfo ji;
            Job job;
            if (jobTreeElements[i] instanceof JobInfo && (job = (ji = (JobInfo)jobTreeElements[i]).getJob()) != null) {
                IStatus status = job.getResult();
                if (status != null && status.getSeverity() == 4) {
                    this.getStatusReporter().report(status, 64, new Object[0]);
                    this.removeTopElement(ji);
                }
                if (this.execute(ji, job)) {
                    return;
                }
            }
            --i;
        }
        this.progressRegion.processDoubleClick();
        this.refresh();
    }

    private boolean execute(JobInfo ji, Job job) {
        Object prop = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        if (prop instanceof IAction && ((IAction)prop).isEnabled()) {
            IAction action = (IAction)prop;
            action.run();
            this.removeTopElement(ji);
            return true;
        }
        prop = job.getProperty(IProgressConstants.COMMAND_PROPERTY);
        if (prop instanceof ParameterizedCommand) {
            ParameterizedCommand command = (ParameterizedCommand)prop;
            this.getEHandlerService().executeHandler(command);
            this.removeTopElement(ji);
            return true;
        }
        return false;
    }

    private void removeTopElement(JobInfo ji) {
        JobTreeElement topElement = ji.getParent();
        if (topElement == null) {
            topElement = ji;
        }
        this.finishedJobs.remove(topElement);
    }

    private IAction getAction(Job job) {
        Object property = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        if (property instanceof IAction) {
            return (IAction)property;
        }
        return null;
    }

    private void refresh() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (this.toolbar == null || this.toolbar.isDisposed()) {
            return;
        }
        JobTreeElement[] jobTreeElements = this.finishedJobs.getKeptElements();
        int i = jobTreeElements.length - 1;
        while (i >= 0) {
            JobInfo ji;
            Job job;
            if (jobTreeElements[i] instanceof JobInfo && (job = (ji = (JobInfo)jobTreeElements[i]).getJob()) != null) {
                IStatus status = job.getResult();
                if (status != null && status.getSeverity() == 4) {
                    this.initButton(this.errorImage, NLS.bind((String)ProgressMessages.ProgressAnimationItem_error, (Object)job.getName()));
                    return;
                }
                IAction action = this.getAction(job);
                if (action != null && action.isEnabled()) {
                    String tt = action.getToolTipText();
                    if (tt == null || tt.trim().length() == 0) {
                        tt = NLS.bind((String)ProgressMessages.ProgressAnimationItem_ok, (Object)job.getName());
                    }
                    this.initButton(this.okImage, tt);
                    return;
                }
                this.initButton(this.noneImage, ProgressMessages.ProgressAnimationItem_tasks);
                return;
            }
            --i;
        }
        if (this.animationRunning) {
            this.initButton(this.noneImage, ProgressMessages.ProgressAnimationItem_tasks);
            return;
        }
        this.toolbar.setVisible(false);
    }

    private void initButton(Image im, final String tt) {
        this.toolButton.setImage(im);
        this.toolButton.setToolTipText(tt);
        this.toolbar.setVisible(true);
        this.toolbar.getParent().requestLayout();
        this.toolbar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = tt;
            }
        });
    }

    @Override
    protected Control createAnimationItem(Composite parent) {
        GridData gd;
        if (this.okImage == null) {
            Display display = parent.getDisplay();
            ImageTools imageTools = ImageTools.getInstance();
            this.noneImage = imageTools.getImage("progress/progress_none.png", display);
            this.okImage = imageTools.getImage("progress/progress_ok.png", display);
            this.errorImage = imageTools.getImage("progress/progress_error.png", display);
        }
        this.top = new Composite(parent, 0);
        this.top.addDisposeListener(e -> {
            this.finishedJobs.removeListener(this);
            this.noneImage.dispose();
            this.okImage.dispose();
            this.errorImage.dispose();
        });
        boolean isCarbon = Util.isMac();
        GridLayout gl = new GridLayout();
        if (this.isHorizontal()) {
            gl.numColumns = isCarbon ? 3 : 2;
        }
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        if (this.isHorizontal()) {
            gl.horizontalSpacing = 2;
        } else {
            gl.verticalSpacing = 2;
        }
        this.top.setLayout((Layout)gl);
        this.bar = new ProgressBar(this.top, this.flags | 2);
        this.bar.setVisible(false);
        this.bar.addMouseListener(this.mouseListener);
        int hh = 12;
        if (this.isHorizontal()) {
            gd = new GridData(1, 0x1000000, true, false);
            gd.heightHint = hh;
        } else {
            gd = new GridData(0x1000000, 1, false, true);
            gd.widthHint = hh;
        }
        this.bar.setLayoutData((Object)gd);
        this.toolbar = new ToolBar(this.top, 0x800000);
        this.toolbar.setVisible(false);
        this.toolButton = new ToolItem(this.toolbar, 0);
        this.toolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressAnimationItem.this.doAction();
            }
        });
        if (isCarbon) {
            new Label(this.top, 0).setLayoutData((Object)new GridData(4, 4));
        }
        this.refresh();
        return this.top;
    }

    private boolean isHorizontal() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public Control getControl() {
        return this.top;
    }

    @Override
    void animationDone() {
        super.animationDone();
        this.animationRunning = false;
        if (this.bar.isDisposed()) {
            return;
        }
        this.bar.setVisible(false);
        this.refresh();
    }

    public boolean animationRunning() {
        return this.animationRunning;
    }

    @Override
    void animationStart() {
        super.animationStart();
        this.animationRunning = true;
        if (this.bar.isDisposed()) {
            return;
        }
        this.bar.setVisible(true);
        this.refresh();
    }

    @Override
    public void removed(JobTreeElement info) {
        Display display = Display.getDefault();
        display.asyncExec(this::refresh);
    }

    @Override
    public void finished(JobTreeElement jte) {
        Display display = Display.getDefault();
        display.asyncExec(this::refresh);
    }

    protected StatusReporter getStatusReporter() {
        return Services.getInstance().getStatusReporter();
    }

    protected EHandlerService getEHandlerService() {
        return Services.getInstance().getEHandlerService();
    }
}

