/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.export;

import java.io.IOException;
import java.io.PrintWriter;

public class OutputterUtil {
    static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void writeStringData(PrintWriter w, String s) throws IOException {
        if (OutputterUtil.containsNonXMLChar(s)) {
            w.write("<![CDATA[");
            OutputterUtil.encodeCDATA(w, s.getBytes("UTF8"));
            w.write("]]>");
        } else {
            w.write(OutputterUtil.escapeForXML(s));
        }
    }

    public static void writeBinaryData(PrintWriter w, Object obj) throws IOException {
        if (obj instanceof byte[]) {
            w.write("<![CDATA[");
            OutputterUtil.encodeCDATA(w, (byte[])obj);
            w.write("]]>");
        }
    }

    private static boolean containsNonXMLChar(String s) {
        boolean flag = false;
        int j = s.length();
        int i = 0;
        while (i < j) {
            if (!OutputterUtil.isXMLChar(s.charAt(i))) {
                flag = true;
                break;
            }
            ++i;
        }
        return flag;
    }

    private static boolean isXMLChar(char c) {
        return c == '\t' || c == '\n' || c == '\r' || ' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd';
    }

    public static String escapeForXML(String s) {
        StringBuffer stringbuffer = new StringBuffer(s.length() + 16);
        int j = s.length();
        int i = 0;
        while (i < j) {
            char c = s.charAt(i);
            if (c == '&') {
                stringbuffer.append("&amp;");
            } else if (c == '<') {
                stringbuffer.append("&lt;");
            } else if (c == '>') {
                stringbuffer.append("&gt;");
            } else if (c == '\'') {
                stringbuffer.append("&apos;");
            } else if (c == '\"') {
                stringbuffer.append("&quot;");
            } else {
                stringbuffer.append(c);
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static void encodeCDATA(PrintWriter w, byte[] bytes) throws IOException {
        int size = bytes.length;
        int i = 0;
        while (i < size) {
            int k = (bytes[i] & 0xF0) >> 4;
            w.write(hexTable[k]);
            k = bytes[i] & 0xF;
            w.write(hexTable[k]);
            if (++i % 32 != 0) continue;
            w.println();
        }
    }
}

