/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.export;

import org.eclipse.datatools.sqltools.result.export.AbstractOutputter;
import org.eclipse.datatools.sqltools.result.internal.export.IOutputterDescriptor;

public class OutputterDescriptor
implements IOutputterDescriptor {
    private String _typeId;
    private String _typeName;
    private String _fileExtension;
    private boolean _supportDelimiter;
    private boolean _supportXMLResult;
    private AbstractOutputter _outputter;
    private String _extensionFilterString;

    public OutputterDescriptor(String id, String name, String extension, boolean delimiter, AbstractOutputter _outputter, boolean supportXMLResult, String extensionFilter) {
        this._typeId = id;
        this._typeName = name;
        this._fileExtension = extension;
        this._supportDelimiter = delimiter;
        this._outputter = _outputter;
        this._supportXMLResult = supportXMLResult;
        this._extensionFilterString = extensionFilter;
    }

    @Override
    public String getFileExtension() {
        return this._fileExtension;
    }

    @Override
    public AbstractOutputter getOutputter() {
        return this._outputter;
    }

    @Override
    public String getTypeId() {
        return this._typeId;
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public boolean supportDelimiter() {
        return this._supportDelimiter;
    }

    @Override
    public boolean supportXMLResult() {
        return this._supportXMLResult;
    }

    @Override
    public String getDisplayString() {
        StringBuffer dspString = new StringBuffer();
        dspString.append(this._typeName == null ? "" : this._typeName).append(" (*.").append(this._fileExtension == null ? "*" : this._fileExtension).append(")");
        return dspString.toString();
    }

    @Override
    public String getExtFilterString() {
        if (this._extensionFilterString != null && this._extensionFilterString.trim().length() > 0) {
            return this._extensionFilterString;
        }
        String ext = "*.";
        ext = this._fileExtension != null ? String.valueOf(ext) + this._fileExtension : String.valueOf(ext) + "*";
        return ext;
    }

    @Override
    public String getExtensionFilterDisplayString() {
        StringBuffer dspString = new StringBuffer();
        dspString.append(this._typeName == null ? "" : this._typeName).append(" (").append(this.getExtFilterString()).append(")");
        return dspString.toString();
    }
}

