/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.eval;

import java.util.HashSet;
import org.eclipse.test.internal.performance.InternalPerformanceMeter;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.AssertChecker;
import org.eclipse.test.internal.performance.eval.EmptyEvaluator;
import org.eclipse.test.performance.PerformanceMeter;
import org.junit.Assert;

public class Evaluator
extends EmptyEvaluator {
    private AssertChecker[] fCheckers;

    @Override
    public void setAssertCheckers(AssertChecker[] asserts) {
        this.fCheckers = asserts;
    }

    @Override
    public void evaluate(PerformanceMeter performanceMeter) throws RuntimeException {
        if (this.fCheckers == null) {
            return;
        }
        Variations refKeys = PerformanceTestPlugin.getAssertAgainst();
        String assertKey = System.getProperty("eclipse.perf.assertAgainst");
        if (refKeys == null) {
            PerformanceTestPlugin.logWarning("refkeys was null. eclipse.perf.assertAgainst was " + assertKey);
            return;
        }
        PerformanceTestPlugin.logInfo("refkeys was: " + refKeys.toString() + " \n\t based on " + "eclipse.perf.assertAgainst" + " being set to " + assertKey);
        if (!(performanceMeter instanceof InternalPerformanceMeter)) {
            return;
        }
        InternalPerformanceMeter ipm = (InternalPerformanceMeter)performanceMeter;
        Sample session = ipm.getSample();
        Assert.assertTrue((String)"metering session is null", (session != null ? 1 : 0) != 0);
        HashSet<Dim> allDimensions = new HashSet<Dim>();
        AssertChecker[] assertCheckerArray = this.fCheckers;
        int n = this.fCheckers.length;
        int n2 = 0;
        while (n2 < n) {
            AssertChecker chk = assertCheckerArray[n2];
            Dim[] dimArray = chk.getDimensions();
            int n3 = dimArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Dim dim = dimArray[n4];
                allDimensions.add(dim);
                ++n4;
            }
            ++n2;
        }
        DataPoint[] sessionDatapoints = session.getDataPoints();
        Variations config = PerformanceTestPlugin.getVariations();
        if (sessionDatapoints == null || sessionDatapoints.length == 0) {
            PerformanceTestPlugin.logWarning("no session data named '" + config + "' found");
            return;
        }
    }
}

