/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers.Messages;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.row.FilteredRowDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.table.FilteredTableDataSet;
import org.eclipse.linuxtools.systemtap.graphing.ui.views.GraphSelectorEditor;
import org.eclipse.linuxtools.systemtap.graphing.ui.views.GraphSelectorEditorInput;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class ImportDataSetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setFilterExtensions(new String[]{Messages.DataSetFileExtension});
        dialog.setText(Messages.ImportDataSetAction_DialogTitle);
        String path = dialog.open();
        if (path != null) {
            this.execute(path);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String path) {
        FilteredRowDataSet dataset = null;
        File file = new File(path);
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try {
                InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset());
                try {
                    try (BufferedReader br = new BufferedReader(fr);){
                        String id = br.readLine();
                        String[] titles = br.readLine().split(", ");
                        if (id == null && titles == null) {
                            throw new IOException();
                        }
                        if (id.equals("org.eclipse.linuxtools.systemtap.graphing.core.datasets.rowdataset")) {
                            dataset = new FilteredRowDataSet(titles);
                        } else {
                            if (!id.equals("org.eclipse.linuxtools.systemtap.graphing.core.datasets.tabledataset")) throw new IOException();
                            dataset = new FilteredTableDataSet(titles);
                        }
                        dataset.readFromFile(file);
                        String title = path.substring(path.lastIndexOf(47) + 1);
                        IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective("org.eclipse.linuxtools.systemtap.ui.ide.IDEPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        GraphSelectorEditor ivp = (GraphSelectorEditor)p.openEditor((IEditorInput)new GraphSelectorEditorInput(title), "org.eclipse.linuxtools.systemtap.graphing.ui.views.GraphSelectorEditor");
                        ivp.createScriptSets(path, Arrays.asList(title), Arrays.asList(dataset));
                    }
                    if (fr == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
                fr.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fnfe) {
            ExceptionErrorDialog.openError((String)Messages.ImportDataSetAction_FileNotFound, (Exception)fnfe);
            return;
        }
        catch (IOException ioe) {
            ExceptionErrorDialog.openError((String)Messages.ImportDataSetAction_FileInvalid, (Exception)ioe);
            return;
        }
        catch (WorkbenchException we) {
            ExceptionErrorDialog.openError((String)Messages.RunScriptChartHandler_couldNotSwitchToGraphicPerspective, (Exception)((Object)we));
        }
    }
}

