/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.dltk.tcl.indexing.PackageSourceCollector;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class PackagesSourcesHover
extends AbstractScriptEditorTextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String hover;
        ISourceModule inputModelElement = EditorUtility.getEditorInputModelElement((IEditorPart)this.getEditor(), (boolean)false);
        if (inputModelElement == null) {
            return null;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)inputModelElement);
        if (toolkit == null) {
            return null;
        }
        if (!"org.eclipse.dltk.tcl.core.nature".equals(toolkit.getNatureId())) {
            return null;
        }
        ISourceModule sourceModule = (ISourceModule)inputModelElement.getAncestor(5);
        TclModuleInfo info = this.extractPackageSourceInfo(sourceModule);
        if (info == null) {
            return null;
        }
        TclModuleInfo moduleInfo = this.loadModuleInfo(sourceModule);
        if (moduleInfo == null) {
            return null;
        }
        for (TclSourceEntry entry : info.getSourced()) {
            if (entry.getStart() > hoverRegion.getOffset() || hoverRegion.getOffset() > entry.getEnd() || (hover = this.describe(entry, (EList<UserCorrection>)moduleInfo.getSourceCorrections(), "Source information:")) == null) continue;
            return hover;
        }
        for (TclSourceEntry entry : info.getRequired()) {
            if (entry.getStart() > hoverRegion.getOffset() || hoverRegion.getOffset() > entry.getEnd() || (hover = this.describe(entry, (EList<UserCorrection>)moduleInfo.getPackageCorrections(), "Require information:")) == null) continue;
            return null;
        }
        return null;
    }

    private String describe(TclSourceEntry entry, EList<UserCorrection> corrections, String caption) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(caption);
        boolean added = false;
        for (UserCorrection userCorrection : corrections) {
            if (!userCorrection.getOriginalValue().equals(entry.getValue())) continue;
            ArrayList userValue = new ArrayList(userCorrection.getUserValue());
            Collections.sort(userValue);
            buffer.append("<ul>");
            for (String value : userValue) {
                buffer.append("<li>").append(value).append("</li>");
                added = true;
            }
            buffer.append("</ul>");
        }
        if (added) {
            return buffer.toString();
        }
        return null;
    }

    private TclModuleInfo extractPackageSourceInfo(ISourceModule sourceModule) {
        TclModule module = this.parse(sourceModule);
        if (module != null) {
            PackageSourceCollector collector = new PackageSourceCollector();
            collector.process((List)module.getStatements(), sourceModule);
            return collector.getCurrentModuleInfo();
        }
        return null;
    }

    private TclModule parse(ISourceModule sourceModule) {
        ModuleDeclaration declaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        if (declaration instanceof TclModuleDeclaration) {
            return ((TclModuleDeclaration)declaration).getTclModule();
        }
        TclParser parser = new TclParser();
        try {
            return parser.parseModule(sourceModule.getSource(), null, (IScopeProcessor)DefinitionManager.getInstance().createProcessor());
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private TclModuleInfo loadModuleInfo(ISourceModule sourceModule) {
        List projectModules = TclPackagesManager.getProjectModules((String)sourceModule.getScriptProject().getElementName());
        String handle = sourceModule.getHandleIdentifier();
        for (TclModuleInfo tclModuleInfo : projectModules) {
            if (!tclModuleInfo.getHandle().equals(handle)) continue;
            return tclModuleInfo;
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                DefaultInformationControl ctrl = new DefaultInformationControl(parent, false);
                return ctrl;
            }
        };
    }
}

