/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.internal.support.MappingsSupport;
import org.eclipse.swtchart.extensions.internal.support.SeriesLabelProvider;

public class SeriesEditingSupport
extends EditingSupport {
    private SeriesListUI seriesListUI;
    private String title = "";

    public SeriesEditingSupport(SeriesListUI seriesListUI, String title) {
        super((ColumnViewer)seriesListUI);
        this.seriesListUI = seriesListUI;
        this.title = title;
    }

    protected boolean canEdit(Object element) {
        boolean canEdit;
        switch (this.title) {
            case "Visible": {
                canEdit = true;
                break;
            }
            case "Visible In Legend": {
                canEdit = true;
                break;
            }
            case "Color": {
                canEdit = true;
                break;
            }
            case "Description": {
                canEdit = true;
                break;
            }
            default: {
                canEdit = false;
            }
        }
        return canEdit;
    }

    protected CellEditor getCellEditor(Object element) {
        CheckboxCellEditor cellEditor;
        switch (this.title) {
            case "Visible": {
                cellEditor = new CheckboxCellEditor((Composite)this.seriesListUI.getTable());
                break;
            }
            case "Visible In Legend": {
                cellEditor = new CheckboxCellEditor((Composite)this.seriesListUI.getTable());
                break;
            }
            case "Color": {
                cellEditor = new ColorCellEditor((Composite)this.seriesListUI.getTable());
                break;
            }
            case "Description": {
                cellEditor = new TextCellEditor((Composite)this.seriesListUI.getTable());
                break;
            }
            default: {
                cellEditor = null;
            }
        }
        return cellEditor;
    }

    protected Object getValue(Object element) {
        Object object;
        switch (this.title) {
            case "Visible": {
                object = SeriesLabelProvider.isVisible(element);
                break;
            }
            case "Visible In Legend": {
                object = SeriesLabelProvider.isVisibleInLegend(element);
                break;
            }
            case "Color": {
                Color color = SeriesLabelProvider.getColor(element);
                object = color != null ? color.getRGB() : null;
                break;
            }
            case "Description": {
                object = SeriesLabelProvider.getDescription(element);
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    protected void setValue(Object element, Object object) {
        if (element instanceof ISeries) {
            ISeries series = (ISeries)element;
            MappingsSupport.mapSettings(series, this.title, object, this.getScrollableChart());
            this.refresh();
        }
    }

    private ScrollableChart getScrollableChart() {
        return this.seriesListUI.getScrollableChart();
    }

    private void refresh() {
        MappingsSupport.adjustSettings(this.getScrollableChart());
        this.seriesListUI.refresh();
    }
}

