/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.io.File;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.MappingsListUI;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.internal.support.MappingsIO;
import org.eclipse.swtchart.extensions.internal.support.MappingsSupport;
import org.eclipse.swtchart.extensions.internal.support.SeriesMapper;

public class MappingsDialog
extends Dialog {
    private static final String DESCRIPTION = "Mappings";
    private static final String IMPORT = "Import Mappings";
    private static final String EXPORT = "Export Mappings";
    private static final String FILTER_EXTENSION = "*.txt";
    private static final String FILTER_NAME = "SWTChart Mappings (*.txt)";
    private static final String FILE_NAME = "SWTChartMappings.txt";
    private MappingsListUI mappingsListUI;
    private ScrollableChart scrollableChart;
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();

    public MappingsDialog(Shell shell, ScrollableChart scrollableChart) {
        super(shell);
        this.scrollableChart = scrollableChart;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DESCRIPTION);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createToolbarMain(composite);
        this.mappingsListUI = this.createMappingsList(composite);
        this.updateInput();
        return composite;
    }

    private MappingsListUI createMappingsList(Composite parent) {
        MappingsListUI mappingsListUI = new MappingsListUI(parent, 68354);
        mappingsListUI.getTable().setLayoutData((Object)new GridData(1808));
        return mappingsListUI;
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(5, false));
        this.createButtonReset(composite);
        this.createButtonResetAll(composite);
        this.createButtonDeleteAll(composite);
        this.createButtonImport(composite);
        this.createButtonExport(composite);
    }

    private Button createButtonReset(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Reset the selected mappings.");
        button.setImage(ResourceSupport.getImage("resetSelected.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(e.display.getActiveShell(), 196);
                messageBox.setText(MappingsDialog.DESCRIPTION);
                messageBox.setMessage("Would you like to reset the selected mappings?");
                int decision = messageBox.open();
                if (64 == decision) {
                    for (Object object : MappingsDialog.this.mappingsListUI.getStructuredSelection()) {
                        if (!(object instanceof Map.Entry)) continue;
                        Map.Entry entry = (Map.Entry)object;
                        SeriesMapper.reset((String)entry.getKey());
                    }
                    MappingsDialog.this.updateInput();
                }
            }
        });
        return button;
    }

    private Button createButtonResetAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Reset all mappings.");
        button.setImage(ResourceSupport.getImage("resetAll.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(e.display.getActiveShell(), 196);
                messageBox.setText(MappingsDialog.DESCRIPTION);
                messageBox.setMessage("Would you like to reset all mappings?");
                int decision = messageBox.open();
                if (64 == decision) {
                    SeriesMapper.reset();
                    MappingsDialog.this.updateInput();
                }
            }
        });
        return button;
    }

    private Button createButtonDeleteAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete all mappings.");
        button.setImage(ResourceSupport.getImage("deleteAll.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(e.display.getActiveShell(), 196);
                messageBox.setText(MappingsDialog.DESCRIPTION);
                messageBox.setMessage("Would you like to delete all mappings?");
                int decision = messageBox.open();
                if (64 == decision) {
                    SeriesMapper.clearAll();
                    MappingsDialog.this.updateInput();
                }
            }
        });
        return button;
    }

    private Button createButtonImport(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(IMPORT);
        button.setImage(ResourceSupport.getImage("import.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.display.getActiveShell(), 8);
                fileDialog.setText(MappingsDialog.IMPORT);
                fileDialog.setFilterExtensions(new String[]{MappingsDialog.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{MappingsDialog.FILTER_NAME});
                fileDialog.setFilterPath(MappingsDialog.this.preferenceStore.getString("pathMappingsImport"));
                String path = fileDialog.open();
                if (path != null) {
                    MappingsDialog.this.preferenceStore.putValue("pathMappingsImport", fileDialog.getFilterPath());
                    File file = new File(path);
                    Map<String, ISeriesSettings> mappings = MappingsIO.importSettings(file);
                    for (Map.Entry<String, ISeriesSettings> mapping : mappings.entrySet()) {
                        String id = mapping.getKey();
                        ISeriesSettings seriesSettings = mapping.getValue();
                        ISeriesSettings seriesSettingsDefault = SeriesMapper.getSeriesSettingsDefault(id, MappingsDialog.this.scrollableChart);
                        SeriesMapper.mapSetting(id, seriesSettings, seriesSettingsDefault);
                    }
                    MappingsDialog.this.updateInput();
                }
            }
        });
        return button;
    }

    private Button createButtonExport(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(EXPORT);
        button.setImage(ResourceSupport.getImage("export.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.display.getActiveShell(), 8192);
                fileDialog.setOverwrite(true);
                fileDialog.setText(MappingsDialog.EXPORT);
                fileDialog.setFilterExtensions(new String[]{MappingsDialog.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{MappingsDialog.FILTER_NAME});
                fileDialog.setFileName(MappingsDialog.FILE_NAME);
                fileDialog.setFilterPath(MappingsDialog.this.preferenceStore.getString("pathMappingsExport"));
                String path = fileDialog.open();
                if (path != null) {
                    MappingsDialog.this.preferenceStore.putValue("pathMappingsExport", fileDialog.getFilterPath());
                    File file = new File(path);
                    MappingsIO.exportSettings(file, SeriesMapper.getMappings());
                }
            }
        });
        return button;
    }

    private void updateInput() {
        MappingsSupport.adjustSettings(this.scrollableChart);
        this.mappingsListUI.setInput(SeriesMapper.getMappings());
    }
}

