/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblyRulerColumn;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.util.PropertyChangeEvent;

public class OpcodeRulerColumn
extends DisassemblyRulerColumn {
    public static final String ID = "org.eclipse.cdt.dsf.ui.disassemblyColumn.opcode";
    private static final int MAXWIDTH = 44;

    public OpcodeRulerColumn() {
        this.setBackground(this.getColor("disassembly.rulerBackgroundColor"));
        this.setForeground(this.getColor("disassembly.codeBytesColor"));
    }

    @Override
    protected String createDisplayString(int line) {
        int nChars = this.computeNumberOfCharacters();
        if (nChars > 0) {
            DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
            try {
                int offset = doc.getLineOffset(line);
                AddressRangePosition pos = doc.getDisassemblyPosition(offset);
                if (pos instanceof DisassemblyPosition && pos.length > 0 && pos.offset == offset && pos.fValid) {
                    DisassemblyPosition disassPos = (DisassemblyPosition)pos;
                    if (disassPos.fRawOpcode != null) {
                        if (disassPos.fRawOpcode.length() > nChars) {
                            return String.valueOf(disassPos.fRawOpcode.substring(0, nChars - 1)) + "\u2026";
                        }
                        return disassPos.fRawOpcode;
                    }
                } else if (pos != null && !pos.fValid) {
                    return "......................................................................".substring(0, nChars);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    protected int computeNumberOfCharacters() {
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        return Math.min(44, doc.getMaxOpcodeLength());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        boolean needRedraw = false;
        if ("disassembly.codeBytesColor".equals(property)) {
            this.setForeground(this.getColor(property));
            needRedraw = true;
        } else if ("disassembly.rulerBackgroundColor".equals(property)) {
            this.setBackground(this.getColor(property));
            needRedraw = true;
        }
        if (needRedraw) {
            this.redraw();
        }
    }
}

