/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseParameter;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.SybaseASABaseParameterValidator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseRoutine;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.impl.RoutineResultTableImpl;
import org.eclipse.datatools.modelbase.sql.tables.impl.ColumnImpl;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.modelvalidity.DefaultSQLModelValidator;
import org.eclipse.datatools.sqltools.core.modelvalidity.SQLModelValidationDelegate;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class SybaseASARoutineValidator
extends DefaultSQLModelValidator {
    protected boolean validateAttribute(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid;
        block31: {
            isValid = true;
            SybaseRoutine proc = (SybaseRoutine)eObject;
            if (featureId == 1) {
                DatabaseIdentifier databaseIdentifier = (DatabaseIdentifier)sharedParams.get("didentifier");
                SQLDevToolsConfiguration conf = SQLToolsFacade.getConfiguration((DatabaseIdentifier)databaseIdentifier, null);
                IIdentifierValidator identifierValidator = conf.getSQLService().getIdentifierValidator();
                if (proc.getName() == null || proc.getName().trim().equals("")) {
                    isValid = false;
                    BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(1), 1000, Messages.SybaseRoutineValidator_No_name_present, new Object[]{proc});
                    diagnostics.add((Diagnostic)d);
                } else if (databaseIdentifier != null) {
                    String quotedName = SQLUtil.quoteWhenNecessary(proc.getName(), databaseIdentifier);
                    ValidatorMessage msg = identifierValidator.isValid(quotedName, 7, databaseIdentifier);
                    if (msg != null && msg.getType() != 0) {
                        isValid = false;
                        BasicDiagnostic d = new BasicDiagnostic(this.getDiagnosticCode(msg.getType()), Integer.toString(1), 1001, String.valueOf(NLS.bind((String)Messages.SybaseRoutineValidator_for_routine, (Object)proc.getName())) + msg.getMessage(), new Object[]{proc});
                        diagnostics.add((Diagnostic)d);
                    } else if (this._currentItemContext.get("validate_duplicate_name_via_db") != null) {
                        Statement newSt = null;
                        Connection conn = null;
                        ResultSet rs = null;
                        ConnectionService connServ = SQLToolsFacade.getConnectionService((DatabaseIdentifier)databaseIdentifier);
                        try {
                            try {
                                conn = connServ.createConnection(databaseIdentifier, true);
                                StringBuffer sql = new StringBuffer("");
                                sql.append("select * from sysprocedure where proc_name = ").append(SQLUtil.quote(proc.getName(), "'")).append(" and creator = (select user_id from sysuserperm where user_name = ").append(SQLUtil.quote(proc.getSchema().getName(), "'")).append(")");
                                newSt = conn.createStatement();
                                rs = newSt.executeQuery(sql.toString());
                                if (rs.next()) {
                                    isValid = false;
                                    BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(1), 1002, NLS.bind((String)Messages.Routine_Duplicate_Name_Error, (Object)proc.getName()), new Object[]{proc});
                                    diagnostics.add((Diagnostic)d);
                                }
                            }
                            catch (Exception exception) {
                                ExamplePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.Database_Error));
                                try {
                                    rs.close();
                                }
                                catch (Exception exception2) {}
                                try {
                                    newSt.close();
                                }
                                catch (Exception exception3) {}
                                try {
                                    connServ.closeConnection(conn, SQLToolsFacade.getConnectionId((DatabaseIdentifier)databaseIdentifier, (Connection)conn), databaseIdentifier);
                                }
                                catch (Exception exception4) {}
                                break block31;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {}
                            try {
                                newSt.close();
                            }
                            catch (Exception exception) {}
                            try {
                                connServ.closeConnection(conn, SQLToolsFacade.getConnectionId((DatabaseIdentifier)databaseIdentifier, (Connection)conn), databaseIdentifier);
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                        try {
                            newSt.close();
                        }
                        catch (Exception exception) {}
                        try {
                            connServ.closeConnection(conn, SQLToolsFacade.getConnectionId((DatabaseIdentifier)databaseIdentifier, (Connection)conn), databaseIdentifier);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return isValid;
    }

    protected boolean validateReference(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid = true;
        Routine proc = (Routine)eObject;
        if (featureId == 18) {
            SybaseASABaseParameterValidator paramValidator;
            if (proc.getParameters().size() == 0) {
                return true;
            }
            if (this._depth > 0 && (paramValidator = new SybaseASABaseParameterValidator()) != null && this._containmentItem != null) {
                for (SybaseParameter param : proc.getParameters()) {
                    SybaseASABaseParameter asaParam;
                    if (param instanceof SybaseASABaseParameter && (asaParam = (SybaseASABaseParameter)param).getParmType() != null && asaParam.getParmType().getValue() == 1) continue;
                    this._containmentItem.getContext().put("validator", paramValidator);
                    isValid &= SQLModelValidationDelegate.getInstance().validate((EObject)param, diagnostics, this._containmentItem.getContext(), sharedParams);
                }
            }
            EList list = proc.getParameters();
            String[] names = new String[list.size()];
            int i = 0;
            for (SybaseParameter param : list) {
                SybaseASABaseParameter asaParam;
                if (param instanceof SybaseASABaseParameter && (asaParam = (SybaseASABaseParameter)param).getParmType() != null && asaParam.getParmType().getValue() == 1) continue;
                names[i++] = param.getName();
            }
            Diagnostic diagnostic = SybaseASARoutineValidator.checkDuplicateName(names, String.valueOf(18), Messages.Duplicate_Parameter_Name_Error, new Object[]{proc});
            if (diagnostic != null) {
                isValid = false;
                diagnostics.add(diagnostic);
            }
        } else if (featureId == 23 && proc instanceof Procedure) {
            Procedure procedure = (Procedure)proc;
            if (procedure.getResultSet().size() == 0) {
                return true;
            }
            EList resultSet = procedure.getResultSet();
            for (RoutineResultTableImpl resultTable : resultSet) {
                EList list = resultTable.getColumns();
                String[] names = new String[list.size()];
                int i = 0;
                for (ColumnImpl column : list) {
                    names[i++] = column.getName();
                }
                Diagnostic diagnostic = SybaseASARoutineValidator.checkDuplicateName(names, String.valueOf(23), Messages.Duplicate_Result_Name_Error, new Object[]{resultTable});
                if (diagnostic == null) continue;
                isValid &= false;
                diagnostics.add(diagnostic);
            }
        }
        return isValid;
    }

    public static Diagnostic checkDuplicateName(String[] names, String diagnosticSource, String diagnosticMessages, Object[] diagnosticDatas) {
        BasicDiagnostic diagnostic = null;
        String duplicateName = "";
        int i = 0;
        while (i < names.length) {
            boolean isDuplicate = false;
            String cname = names[i];
            int j = i + 1;
            while (j < names.length) {
                if (j == names.length) break;
                if (cname != null && names[j] != null && !cname.trim().equals("") && cname.toLowerCase().equals(names[j].toLowerCase())) {
                    duplicateName = cname;
                    isDuplicate = true;
                    break;
                }
                ++j;
            }
            if (isDuplicate) {
                diagnostic = new BasicDiagnostic(4, diagnosticSource, 1002, String.valueOf(diagnosticMessages) + duplicateName, diagnosticDatas);
                break;
            }
            ++i;
        }
        return diagnostic;
    }
}

