/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.Duration;
import org.eclipse.xwt.animation.FillBehavior;
import org.eclipse.xwt.animation.FloatAnimationBase;
import org.eclipse.xwt.animation.IEasingFunction;
import org.eclipse.xwt.animation.internal.ITimeline;
import org.eclipse.xwt.animation.internal.TridentTimeline;

public class FloatAnimation
extends FloatAnimationBase {
    protected Float by;
    protected Float from;
    protected Float to;
    private IEasingFunction easingFunction;
    protected boolean additive = false;
    protected boolean cumulative = false;

    public FloatAnimation() {
    }

    public IEasingFunction getEasingFunction() {
        return this.easingFunction;
    }

    public void setEasingFunction(IEasingFunction easingFunction) {
        this.easingFunction = easingFunction;
    }

    public FloatAnimation(Float toValue, Duration duration) {
        this.setTo(toValue);
        this.setDuration(duration);
    }

    public FloatAnimation(Float fromValue, Float toValue, Duration duration) {
        this.setTo(toValue);
        this.setFrom(fromValue);
        this.setDuration(duration);
    }

    public FloatAnimation(Float toValue, Duration duration, FillBehavior fillBehavior) {
        this.setTo(toValue);
        this.setDuration(duration);
        this.setFillBehavior(fillBehavior);
    }

    public FloatAnimation(Float fromValue, Float toValue, Duration duration, FillBehavior fillBehavior) {
        this.setTo(toValue);
        this.setFrom(fromValue);
        this.setDuration(duration);
        this.setFillBehavior(fillBehavior);
    }

    public Float getBy() {
        return this.by;
    }

    public void setBy(Float by) {
        this.by = by;
    }

    public Float getFrom() {
        return this.from;
    }

    public void setFrom(Float from) {
        this.from = from;
    }

    public Float getTo() {
        return this.to;
    }

    public void setTo(Float to) {
        this.to = to;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public boolean isCumulative() {
        return this.cumulative;
    }

    public void setCumulative(boolean cumulative) {
        this.cumulative = cumulative;
    }

    @Override
    protected void updateTimeline(ITimeline timeline, Object target) {
        super.updateTimeline(timeline, target);
        if (timeline instanceof TridentTimeline) {
            TridentTimeline tridentTimeline = (TridentTimeline)timeline;
            Float from = this.getFrom();
            Float to = this.getTo();
            if (from == null && to == null) {
                from = (Float)this.getCacheValue();
                to = (Float)this.getCurrentValue(target);
                if (from != null && from.equals(to)) {
                    throw new XWTException("action ignored");
                }
            }
            tridentTimeline.addPropertyToInterpolate(this.getTargetProperty(), from, to);
            tridentTimeline.setEasingFunction(this.getEasingFunction());
        }
    }
}

