/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing.util;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;

public class AnnotatedTextToString {
    private String contents;
    private IFile file;
    private List<CommentedRegion> regions = new ArrayList<CommentedRegion>();
    private List<String> emptyMessages = new ArrayList<String>();

    public String getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            if (this.file != null) {
                return IResourcesSetupUtil.fileToString(this.file);
            }
            return null;
        }
        catch (IOException | CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public IFile getFile() {
        return this.file;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public List<CommentedRegion> getRegions() {
        return this.regions;
    }

    public List<String> getEmptyMessage() {
        return this.emptyMessages;
    }

    public AnnotatedTextToString withFile(IFile file) {
        this.file = file;
        return this;
    }

    public AnnotatedTextToString withMarkers(IMarker[] markers) {
        return this.withMarkers(markers, "message");
    }

    public AnnotatedTextToString withMarkers(IMarker[] markers, String ... attributes) {
        try {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                ArrayList<String> transformed = new ArrayList<String>(attributes.length);
                String[] stringArray = attributes;
                int n3 = attributes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String attribute = stringArray[n4];
                    transformed.add(String.valueOf(attribute) + "=" + marker.getAttribute(attribute));
                    ++n4;
                }
                String comment = String.join((CharSequence)", ", transformed);
                Integer offset = (Integer)marker.getAttribute("charStart");
                Integer length = (Integer)marker.getAttribute("charEnd");
                this.regions.add(new CommentedRegion(offset, length, comment));
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.emptyMessages.add("(no markers found)");
        return this;
    }

    public AnnotatedTextToString withMarkersFromFile(String type, String ... attributes) {
        try {
            return this.withMarkers(this.file.findMarkers(type, true, 2), attributes);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public AnnotatedTextToString withMarkersFromFile() {
        return this.withMarkersFromFile("org.eclipse.xtext.ui.check.fast", "message");
    }

    public String toString() {
        String contents = this.getContents();
        this.regions.sort(Comparator.comparing(region -> ((CommentedRegion)region).start));
        ArrayList<AbstractMap.SimpleEntry<Integer, CommentedRegion>> sorted = new ArrayList<AbstractMap.SimpleEntry<Integer, CommentedRegion>>();
        int index = 0;
        while (index < this.regions.size()) {
            sorted.add(new AbstractMap.SimpleEntry<Integer, CommentedRegion>(index, this.regions.get(index)));
            ++index;
        }
        ArrayList<AbstractMap.SimpleEntry> locations = new ArrayList<AbstractMap.SimpleEntry>();
        sorted.stream().forEach(s -> {
            locations.add(new AbstractMap.SimpleEntry<Integer, String>(((CommentedRegion)s.getValue()).start, "<" + s.getKey() + "<"));
            locations.add(new AbstractMap.SimpleEntry<Integer, String>(((CommentedRegion)s.getValue()).end, ">" + s.getKey() + ">"));
        });
        locations.sort(Comparator.comparing(AbstractMap.SimpleEntry::getKey));
        StringBuilder result = new StringBuilder();
        int lastOffset = 0;
        int i = 0;
        while (i < locations.size()) {
            AbstractMap.SimpleEntry location = (AbstractMap.SimpleEntry)locations.get(i);
            Integer n = (Integer)location.getKey();
            String comment = (String)location.getValue();
            result.append(contents.substring(lastOffset, n));
            result.append(comment);
            lastOffset = n;
            ++i;
        }
        result.append(contents.substring(lastOffset, contents.length()));
        String[] resultsArray = result.toString().replace("\t", "    ").split("\r?\n");
        int maxLineLength = Arrays.stream(resultsArray).map(r -> r.length()).reduce(Integer::max).get();
        if (!result.substring(result.length() - 1, result.length()).equals("\n")) {
            result.append("\n");
        }
        result.append(Strings.repeat((String)"-", (int)maxLineLength));
        if (sorted.isEmpty()) {
            for (String string : this.emptyMessages) {
                result.append("\n");
                result.append(string);
            }
        } else {
            for (AbstractMap.SimpleEntry simpleEntry : sorted) {
                result.append("\n");
                result.append(simpleEntry.getKey());
                result.append(": ");
                result.append(((CommentedRegion)simpleEntry.getValue()).text);
            }
        }
        return result.toString();
    }

    protected static class CommentedRegion {
        private final int start;
        private final int end;
        private final String text;

        public CommentedRegion(int start, int end, String text) {
            this.start = start;
            this.end = end;
            this.text = text;
        }
    }
}

