/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;

public class ASTFlattener
extends GenericVisitor {
    protected StringBuffer fBuffer = new StringBuffer();

    public String getResult() {
        return this.fBuffer.toString();
    }

    public void reset() {
        this.fBuffer.setLength(0);
    }

    public static String asString(ASTNode node) {
        ASTFlattener flattener = new ASTFlattener();
        node.accept((ASTVisitor)flattener);
        return flattener.getResult();
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        Assert.isTrue((boolean)false, (String)("No implementation to flatten node: " + node.toString()));
        return false;
    }

    private void printModifiers(List ext) {
        for (ASTNode p : ext) {
            p.accept((ASTVisitor)this);
            this.fBuffer.append(" ");
        }
    }

    private void printModifiers(int modifiers) {
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        this.fBuffer.append("{");
        for (BodyDeclaration b : node.bodyDeclarations()) {
            b.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(ArrayAccess node) {
        node.getArray().accept((ASTVisitor)this);
        this.fBuffer.append("[");
        node.getIndex().accept((ASTVisitor)this);
        this.fBuffer.append("]");
        return false;
    }

    @Override
    public boolean visit(ArrayCreation node) {
        this.fBuffer.append("new ");
        ArrayType at = node.getType();
        int dims = at.getDimensions();
        Type elementType = at.getElementType();
        elementType.accept((ASTVisitor)this);
        Iterator it = node.dimensions().iterator();
        while (it.hasNext()) {
            this.fBuffer.append("[");
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            this.fBuffer.append("]");
            --dims;
        }
        int i = 0;
        while (i < dims) {
            this.fBuffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        this.fBuffer.append("[");
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append("]");
        return false;
    }

    @Override
    public boolean visit(ArrayType node) {
        node.getComponentType().accept((ASTVisitor)this);
        this.fBuffer.append("[]");
        return false;
    }

    @Override
    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept((ASTVisitor)this);
        this.fBuffer.append(node.getOperator().toString());
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(Block node) {
        this.fBuffer.append("{");
        for (Statement s : node.statements()) {
            s.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(BlockComment node) {
        this.fBuffer.append("/* */");
        return false;
    }

    @Override
    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.fBuffer.append("true");
        } else {
            this.fBuffer.append("false");
        }
        return false;
    }

    @Override
    public boolean visit(BreakStatement node) {
        this.fBuffer.append("break");
        if (node.getLabel() != null) {
            this.fBuffer.append(" ");
            node.getLabel().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(FunctionExpression node) {
        node.getMethod().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(ObjectLiteral node) {
        this.fBuffer.append("{");
        for (ObjectLiteralField field : node.fields()) {
            field.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(ObjectLiteralField node) {
        node.getFieldName().accept((ASTVisitor)this);
        this.fBuffer.append(" : ");
        node.getInitializer().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(CatchClause node) {
        this.fBuffer.append("catch (");
        node.getException().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(CharacterLiteral node) {
        this.fBuffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(RegularExpressionLiteral node) {
        this.fBuffer.append(node.getRegularExpression());
        return false;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("new ");
        node.getMember().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(JavaScriptUnit node) {
        if (node.getPackage() != null) {
            node.getPackage().accept((ASTVisitor)this);
        }
        for (ImportDeclaration d : node.imports()) {
            d.accept((ASTVisitor)this);
        }
        for (ImportDeclaration d : node.types()) {
            d.accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append("?");
        node.getThenExpression().accept((ASTVisitor)this);
        this.fBuffer.append(":");
        node.getElseExpression().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        Iterator it;
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        this.fBuffer.append("this(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(");");
        return false;
    }

    @Override
    public boolean visit(ContinueStatement node) {
        this.fBuffer.append("continue");
        if (node.getLabel() != null) {
            this.fBuffer.append(" ");
            node.getLabel().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(DoStatement node) {
        this.fBuffer.append("do ");
        node.getBody().accept((ASTVisitor)this);
        this.fBuffer.append(" while (");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(");");
        return false;
    }

    @Override
    public boolean visit(EmptyStatement node) {
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        this.fBuffer.append("for (");
        node.getParameter().accept((ASTVisitor)this);
        this.fBuffer.append(" : ");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(FieldAccess node) {
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(".");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(ForStatement node) {
        this.fBuffer.append("for (");
        for (Expression e : node.initializers()) {
            e.accept((ASTVisitor)this);
        }
        this.fBuffer.append("; ");
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        this.fBuffer.append("; ");
        for (Expression e : node.updaters()) {
            e.accept((ASTVisitor)this);
        }
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(ForInStatement node) {
        this.fBuffer.append("for (");
        if (node.getIterationVariable() != null) {
            node.getIterationVariable().accept((ASTVisitor)this);
        }
        this.fBuffer.append(" in ");
        if (node.getCollection() != null) {
            node.getCollection().accept((ASTVisitor)this);
        }
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(IfStatement node) {
        this.fBuffer.append("if (");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getThenStatement().accept((ASTVisitor)this);
        if (node.getElseStatement() != null) {
            this.fBuffer.append(" else ");
            node.getElseStatement().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        if (node.isFileImport()) {
            return false;
        }
        this.fBuffer.append("import ");
        if (node.getAST().apiLevel() >= 3 && node.isStatic()) {
            this.fBuffer.append("static ");
        }
        node.getName().accept((ASTVisitor)this);
        if (node.isOnDemand()) {
            this.fBuffer.append(".*");
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(InfixExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.fBuffer.append(' ');
        this.fBuffer.append(node.getOperator().toString());
        this.fBuffer.append(' ');
        node.getRightOperand().accept((ASTVisitor)this);
        List extendedOperands = node.extendedOperands();
        if (extendedOperands.size() != 0) {
            this.fBuffer.append(' ');
            Iterator it = extendedOperands.iterator();
            while (it.hasNext()) {
                this.fBuffer.append(node.getOperator().toString()).append(' ');
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.fBuffer.append(" instanceof ");
        node.getRightOperand().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(Initializer node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(JSdoc node) {
        this.fBuffer.append("/** ");
        for (ASTNode e : node.tags()) {
            e.accept((ASTVisitor)this);
        }
        this.fBuffer.append("\n */");
        return false;
    }

    @Override
    public boolean visit(LabeledStatement node) {
        node.getLabel().accept((ASTVisitor)this);
        this.fBuffer.append(": ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(ListExpression node) {
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        return false;
    }

    @Override
    public boolean visit(LineComment node) {
        this.fBuffer.append("//\n");
        return false;
    }

    @Override
    public boolean visit(MemberRef node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
        }
        this.fBuffer.append("#");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(FunctionRef node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
        }
        this.fBuffer.append("#");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            FunctionRefParameter e = (FunctionRefParameter)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(FunctionRefParameter node) {
        node.getType().accept((ASTVisitor)this);
        if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
            this.fBuffer.append("...");
        }
        if (node.getName() != null) {
            this.fBuffer.append(" ");
            node.getName().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(FunctionDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        if (node.getName() != null) {
            node.getName().accept((ASTVisitor)this);
        }
        this.fBuffer.append("(");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            v.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.fBuffer.append("[]");
            ++i;
        }
        if (!node.thrownExceptions().isEmpty()) {
            this.fBuffer.append(" throws ");
            it = node.thrownExceptions().iterator();
            while (it.hasNext()) {
                Name n = (Name)it.next();
                n.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(", ");
            }
            this.fBuffer.append(" ");
        }
        if (node.getBody() == null) {
            this.fBuffer.append(";");
        } else {
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(FunctionInvocation node) {
        SimpleName name;
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            Iterator it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        if ((name = node.getName()) != null) {
            name.accept((ASTVisitor)this);
        }
        this.fBuffer.append("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(Modifier node) {
        this.fBuffer.append(node.getKeyword().toString());
        return false;
    }

    @Override
    public boolean visit(NullLiteral node) {
        this.fBuffer.append("null");
        return false;
    }

    @Override
    public boolean visit(UndefinedLiteral node) {
        this.fBuffer.append("undefined");
        return false;
    }

    @Override
    public boolean visit(NumberLiteral node) {
        this.fBuffer.append(node.getToken());
        return false;
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        if (node.getAST().apiLevel() >= 3 && node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.fBuffer.append("package ");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(ParenthesizedExpression node) {
        this.fBuffer.append("(");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(PostfixExpression node) {
        node.getOperand().accept((ASTVisitor)this);
        this.fBuffer.append(node.getOperator().toString());
        return false;
    }

    @Override
    public boolean visit(PrefixExpression node) {
        this.fBuffer.append(node.getOperator().toString());
        node.getOperand().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(PrimitiveType node) {
        this.fBuffer.append(node.getPrimitiveTypeCode().toString());
        return false;
    }

    @Override
    public boolean visit(QualifiedName node) {
        node.getQualifier().accept((ASTVisitor)this);
        this.fBuffer.append(".");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(QualifiedType node) {
        node.getQualifier().accept((ASTVisitor)this);
        this.fBuffer.append(".");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        this.fBuffer.append("return");
        if (node.getExpression() != null) {
            this.fBuffer.append(" ");
            node.getExpression().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(SimpleName node) {
        this.fBuffer.append(node.getIdentifier());
        return false;
    }

    @Override
    public boolean visit(SimpleType node) {
        return true;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
            this.fBuffer.append("...");
        }
        this.fBuffer.append(" ");
        node.getName().accept((ASTVisitor)this);
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.fBuffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.fBuffer.append("=");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(StringLiteral node) {
        this.fBuffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        Iterator it;
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        this.fBuffer.append("super(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(");");
        return false;
    }

    @Override
    public boolean visit(SuperFieldAccess node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("super.");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        Iterator it;
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("super.");
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(SwitchCase node) {
        if (node.isDefault()) {
            this.fBuffer.append("default :");
        } else {
            this.fBuffer.append("case ");
            node.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(":");
        }
        return false;
    }

    @Override
    public boolean visit(SwitchStatement node) {
        this.fBuffer.append("switch (");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        this.fBuffer.append("{");
        for (Statement s : node.statements()) {
            s.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(TagElement node) {
        if (node.isNested()) {
            this.fBuffer.append("{");
        } else {
            this.fBuffer.append("\n * ");
        }
        boolean previousRequiresWhiteSpace = false;
        if (node.getTagName() != null) {
            this.fBuffer.append(node.getTagName());
            previousRequiresWhiteSpace = true;
        }
        boolean previousRequiresNewLine = false;
        for (ASTNode e : node.fragments()) {
            boolean currentIncludesWhiteSpace = e instanceof TextElement;
            if (previousRequiresNewLine && currentIncludesWhiteSpace) {
                this.fBuffer.append("\n * ");
            }
            previousRequiresNewLine = currentIncludesWhiteSpace;
            if (previousRequiresWhiteSpace && !currentIncludesWhiteSpace) {
                this.fBuffer.append(" ");
            }
            e.accept((ASTVisitor)this);
            boolean bl = previousRequiresWhiteSpace = !currentIncludesWhiteSpace && !(e instanceof TagElement);
        }
        if (node.isNested()) {
            this.fBuffer.append("}");
        }
        return false;
    }

    @Override
    public boolean visit(TextElement node) {
        this.fBuffer.append(node.getText());
        return false;
    }

    @Override
    public boolean visit(ThisExpression node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("this");
        return false;
    }

    @Override
    public boolean visit(ThrowStatement node) {
        this.fBuffer.append("throw ");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        this.fBuffer.append("try ");
        node.getBody().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        for (CatchClause cc : node.catchClauses()) {
            cc.accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            this.fBuffer.append("finally ");
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        this.fBuffer.append("class ");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        if (node.getAST().apiLevel() == 2 && node.getSuperclass() != null) {
            this.fBuffer.append("extends ");
            node.getSuperclass().accept((ASTVisitor)this);
            this.fBuffer.append(" ");
        }
        if (node.getAST().apiLevel() >= 3 && node.getSuperclassType() != null) {
            this.fBuffer.append("extends ");
            node.getSuperclassType().accept((ASTVisitor)this);
            this.fBuffer.append(" ");
        }
        this.fBuffer.append("{");
        for (BodyDeclaration d : node.bodyDeclarations()) {
            d.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        if (node.getAST().apiLevel() == 2) {
            node.getTypeDeclaration().accept((ASTVisitor)this);
        }
        if (node.getAST().apiLevel() >= 3) {
            node.getDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(TypeLiteral node) {
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append(".class");
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        this.fBuffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        node.getName().accept((ASTVisitor)this);
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.fBuffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.fBuffer.append("=");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.fBuffer.append("while (");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(WithStatement node) {
        this.fBuffer.append("with (");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }
}

