/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.local.launcher;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.terminal.connector.local.controls.LocalWizardConfigurationPanel;
import org.eclipse.tm.terminal.connector.local.launcher.LocalMementoHandler;
import org.eclipse.tm.terminal.connector.process.ProcessSettings;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.interfaces.IMementoHandler;
import org.eclipse.tm.terminal.view.ui.internal.SettingsStore;
import org.eclipse.tm.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.osgi.framework.Bundle;

public class LocalLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new LocalMementoHandler();

    public boolean needsUserConfiguration() {
        return false;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new LocalWizardConfigurationPanel(container);
    }

    public void execute(Map<String, Object> properties, ITerminalService.Done done) {
        ITerminalService terminal;
        ISelectionService service;
        String cwd;
        String terminalTitle;
        block30: {
            Assert.isNotNull(properties);
            terminalTitle = this.getTerminalTitle(properties);
            if (terminalTitle != null) {
                properties.put("title", terminalTitle);
            }
            if (!properties.containsKey("encoding")) {
                String encoding = null;
                encoding = "macosx".equals(Platform.getOS()) || "win32".equals(Platform.getOS()) ? "UTF-8" : WorkbenchEncoding.getWorkbenchDefaultEncoding();
                if (encoding != null && !"".equals(encoding)) {
                    properties.put("encoding", encoding);
                }
            }
            if (!properties.containsKey("terminal.forceNew")) {
                properties.put("terminal.forceNew", Boolean.TRUE);
            }
            String initialCwd = UIPlugin.getScopedPreferences().getString("terminals.localTerminalInitialCwd");
            cwd = null;
            if (initialCwd == null || "userhome".equals(initialCwd) || "".equals(initialCwd.trim())) {
                cwd = System.getProperty("user.home");
            } else if ("eclipsehome".equals(initialCwd)) {
                String eclipseHomeLocation = System.getProperty("eclipse.home.location");
                if (eclipseHomeLocation != null) {
                    try {
                        URI uri = URIUtil.fromString((String)eclipseHomeLocation);
                        File f = URIUtil.toFile((URI)uri);
                        cwd = f.getAbsolutePath();
                    }
                    catch (URISyntaxException uri) {}
                }
            } else if ("eclipsews".equals(initialCwd)) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
                if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16 && ResourcesPlugin.getWorkspace() != null && ResourcesPlugin.getWorkspace().getRoot() != null && ResourcesPlugin.getWorkspace().getRoot().getLocation() != null) {
                    cwd = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                }
            } else {
                try {
                    IStringVariableManager vm = VariablesPlugin.getDefault().getStringVariableManager();
                    String resolved = vm.performStringSubstitution(initialCwd);
                    Path p = new Path(resolved);
                    if (p.toFile().canRead() && p.toFile().isDirectory()) {
                        cwd = p.toOSString();
                    }
                }
                catch (CoreException ex) {
                    if (!Platform.inDebugMode()) break block30;
                    org.eclipse.tm.terminal.connector.local.activator.UIPlugin.getDefault().getLog().log(ex.getStatus());
                }
            }
        }
        if (cwd != null && !"".equals(cwd)) {
            properties.put("process.working_dir", cwd);
        }
        if ((service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()) != null && service.getSelection() != null || properties.containsKey("selection")) {
            ISelection selection = (ISelection)properties.get("selection");
            if (selection == null) {
                selection = service.getSelection();
            }
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                String dir = null;
                for (Object element : (IStructuredSelection)selection) {
                    File f;
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
                    if (bundle == null || bundle.getState() == 1 || bundle.getState() == 16) continue;
                    if (!(element instanceof IResource)) {
                        Object adapted;
                        Object object = adapted = element instanceof IAdaptable ? ((IAdaptable)element).getAdapter(IResource.class) : null;
                        if (adapted == null) {
                            adapted = Platform.getAdapterManager().getAdapter(element, IResource.class);
                        }
                        if (adapted != null) {
                            element = adapted;
                        }
                    }
                    if (element instanceof IResource && ((IResource)element).exists()) {
                        IPath location = ((IResource)element).getLocation();
                        if (location == null) continue;
                        if (location.toFile().isFile()) {
                            location = location.removeLastSegments(1);
                        }
                        if (location.toFile().isDirectory() && location.toFile().canRead()) {
                            dir = location.toFile().getAbsolutePath();
                            break;
                        }
                    }
                    if (!(element instanceof IPath) && !(element instanceof File)) continue;
                    File file = f = element instanceof IPath ? ((IPath)element).toFile() : (File)element;
                    if (!f.isDirectory() || !f.canRead()) continue;
                    dir = f.getAbsolutePath();
                    break;
                }
                if (dir != null) {
                    properties.put("process.working_dir", dir);
                    String basename = new Path(dir).lastSegment();
                    properties.put("title", String.valueOf(basename) + " (" + terminalTitle + ")");
                }
            }
        }
        if ((terminal = TerminalServiceFactory.getService()) != null) {
            terminal.openConsole(properties, done);
        }
    }

    private String getTerminalTitle(Map<String, Object> properties) {
        String title = this.getDefaultTerminalTitle(properties);
        if (title != null) {
            return title;
        }
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            if (hostname != null && !"".equals(hostname.trim())) {
                return hostname;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "Local";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IMementoHandler.class.equals(adapter)) {
            return adapter.cast(this.mementoHandler);
        }
        return (T)super.getAdapter(adapter);
    }

    private final File defaultShell() {
        String shell = null;
        if ("win32".equals(Platform.getOS())) {
            shell = System.getenv("ComSpec") != null && !"".equals(System.getenv("ComSpec").trim()) ? System.getenv("ComSpec").trim() : "cmd.exe";
        }
        if (shell == null && ((shell = UIPlugin.getScopedPreferences().getString("terminals.localTerminalDefaultShellUnix")) == null || "".equals(shell))) {
            shell = System.getenv("SHELL") != null && !"".equals(System.getenv("SHELL").trim()) ? System.getenv("SHELL").trim() : "/bin/sh";
        }
        return new File(shell);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        Bundle bundle;
        String eclipseHomeLocation;
        File defaultShell;
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tm.terminal.connector.local.LocalConnector";
        }
        String image = !properties.containsKey("process.path") || properties.get("process.path") == null ? ((defaultShell = this.defaultShell()).isAbsolute() ? defaultShell.getAbsolutePath() : defaultShell.getPath()) : (String)properties.get("process.path");
        String arguments = (String)properties.get("process.args");
        if (arguments == null && !"win32".equals(Platform.getOS())) {
            arguments = UIPlugin.getScopedPreferences().getString("terminals.localTerminalDefaultShellUnixArgs");
        }
        boolean isUsingPTY = properties.get("process") == null && PTY.isSupported((PTY.Mode)PTY.Mode.TERMINAL) || properties.get("pty") instanceof PTY;
        boolean localEcho = false;
        if (!properties.containsKey("localEcho") || !(properties.get("localEcho") instanceof Boolean)) {
            if ("win32".equals(Platform.getOS())) {
                localEcho = !isUsingPTY;
            }
        } else {
            localEcho = (Boolean)properties.get("localEcho");
        }
        String lineSeparator = null;
        if (!properties.containsKey("lineSeparator") || !(properties.get("lineSeparator") instanceof String)) {
            if (!isUsingPTY) {
                lineSeparator = "win32".equals(Platform.getOS()) ? "\\r\\n" : "\\n";
            }
        } else {
            lineSeparator = (String)properties.get("lineSeparator");
        }
        Process process = (Process)properties.get("process");
        PTY pty = (PTY)properties.get("pty");
        ITerminalServiceOutputStreamMonitorListener[] stdoutListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stdoutListeners");
        ITerminalServiceOutputStreamMonitorListener[] stderrListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stderrListeners");
        String workingDir = (String)properties.get("process.working_dir");
        String[] envp = null;
        if (properties.containsKey("process.environment") && properties.get("process.environment") != null && properties.get("process.environment") instanceof String[]) {
            envp = (String[])properties.get("process.environment");
        }
        ArrayList<Object> envpList = new ArrayList<Object>();
        if (envp != null) {
            envpList.addAll(Arrays.asList(envp));
        }
        if ((eclipseHomeLocation = System.getProperty("eclipse.home.location")) != null) {
            try {
                URI uri = URIUtil.fromString((String)eclipseHomeLocation);
                File f = URIUtil.toFile((URI)uri);
                envpList.add("ECLIPSE_HOME=" + f.getAbsolutePath());
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        if ((bundle = Platform.getBundle((String)"org.eclipse.core.resources")) != null && bundle.getState() != 1 && bundle.getState() != 16 && ResourcesPlugin.getWorkspace() != null && ResourcesPlugin.getWorkspace().getRoot() != null && ResourcesPlugin.getWorkspace().getRoot().getLocation() != null) {
            envpList.add("ECLIPSE_WORKSPACE=" + ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        }
        envp = envpList.toArray(new String[envpList.size()]);
        Assert.isTrue((image != null || process != null ? 1 : 0) != 0);
        SettingsStore store = new SettingsStore();
        ProcessSettings processSettings = new ProcessSettings();
        processSettings.setImage(image);
        processSettings.setArguments(arguments);
        processSettings.setProcess(process);
        processSettings.setPTY(pty);
        processSettings.setLocalEcho(localEcho);
        processSettings.setLineSeparator(lineSeparator);
        processSettings.setStdOutListeners(stdoutListeners);
        processSettings.setStdErrListeners(stderrListeners);
        processSettings.setWorkingDir(workingDir);
        processSettings.setEnvironment(envp);
        if (properties.containsKey("process.environment.merge")) {
            Object value = properties.get("process.environment.merge");
            processSettings.setMergeWithNativeEnvironment(value instanceof Boolean ? (Boolean)value : false);
        }
        processSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.setDefaultSettings();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

