/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import java.util.List;
import java.util.Optional;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.CenteringStyle;
import org.eclipse.sirius.diagram.description.tool.RequestDescription;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DEdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.ShowingViewUtil;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramEdgeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.EditStatusUpdater;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.DEdgeSelectionFeedbackEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusEdgeLabelSnapBackEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPropertyHandlerEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SiriusConnectionEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabelWithAttachment;
import org.eclipse.sirius.diagram.ui.tools.api.permission.EditPartAuthorityListener;
import org.eclipse.sirius.diagram.ui.tools.api.policy.CompoundEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies.SiriusConnectionEndPointEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.SiriusBendpointConnectionRouter;
import org.eclipse.sirius.diagram.ui.tools.internal.ruler.SiriusSnapToHelperUtil;
import org.eclipse.sirius.ext.gmf.runtime.draw2d.ui.figures.SiriusPolylineConnectionEx;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractDiagramEdgeEditPart
extends ConnectionNodeEditPart
implements IDiagramEdgeEditPart {
    private static final int EDGE_MINIMUM_LENGTH = 20;
    private static final int EDGE_MINIMUM_THICKNESS = 20;
    private static final int SOURCE_TARGET_MINIMUM_SIZE_SELECTION = 20;
    private static final BendpointConnectionRouter ROUTER = new SiriusBendpointConnectionRouter();
    protected EditPartAuthorityListener authListener = new EditPartAuthorityListener(this);
    private NotificationListener adapterDiagramElement;
    private NotificationPreCommitListener adapterRoutingStyle;
    private NotificationListener editModeListener = new EditStatusUpdater(this);
    private RoutingStyle routingStyle;
    private NotificationPreCommitListener routingStyleNotificationPreCommitListener;

    public AbstractDiagramEdgeEditPart(View view) {
        super(view);
    }

    protected void registerModel() {
        super.registerModel();
        DiagramElementEditPartOperation.registerModel(this);
    }

    protected void unregisterModel() {
        super.unregisterModel();
        DiagramElementEditPartOperation.unregisterModel(this);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("Connection Endpoint Policy");
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new SiriusConnectionEndPointEditPolicy());
        this.removeEditPolicy("PropertyHandlerPolicy");
        this.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new SiriusPropertyHandlerEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new SiriusConnectionEditPolicy());
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
        EditPolicy currentSelectionEditPolicy = this.getEditPolicy("Selection Feedback");
        DEdgeSelectionFeedbackEditPolicy selectionFeedBackEditPolicy = new DEdgeSelectionFeedbackEditPolicy();
        if (currentSelectionEditPolicy != null) {
            CompoundEditPolicy selectionCompoundEditPolicy = new CompoundEditPolicy();
            selectionCompoundEditPolicy.addEditPolicy(currentSelectionEditPolicy);
            selectionCompoundEditPolicy.addEditPolicy((EditPolicy)selectionFeedBackEditPolicy);
            this.removeEditPolicy("Selection Feedback");
            this.installEditPolicy("Selection Feedback", selectionCompoundEditPolicy);
        } else {
            this.installEditPolicy("Selection Feedback", (EditPolicy)selectionFeedBackEditPolicy);
        }
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SiriusEdgeLabelSnapBackEditPolicy());
    }

    public Command getCommand(Request request) {
        Command cmd = super.getCommand(request);
        return CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, cmd);
    }

    protected void addNotationalListeners() {
        ViewQuery viewQuery;
        Optional<DDiagram> diagram;
        super.addNotationalListeners();
        Object model = this.getModel();
        if (model instanceof View && (diagram = (viewQuery = new ViewQuery((View)this.getModel())).getDDiagram()).isPresent()) {
            this.addListenerFilter("ShowingMode", this, (EObject)diagram.get(), (EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagram_IsInShowingMode());
        }
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("ShowingMode");
    }

    public void setVisibility(boolean vis) {
        ViewQuery viewQuery;
        if (!vis && this.getSelected() != 0) {
            this.getViewer().deselect((EditPart)this);
        }
        if ((viewQuery = new ViewQuery((View)this.getModel())).isInShowingMode()) {
            this.figure.setVisible(true);
        } else {
            this.figure.setVisible(vis);
        }
        this.getFigure().revalidate();
    }

    protected void handleNotificationEvent(Notification notification) {
        DiagramElementEditPartOperation.handleNotificationEvent(this, notification);
        EObject element = this.resolveSemanticElement();
        if (element instanceof DEdge) {
            this.updateCenteringProperty((DEdge)element, notification);
            super.handleNotificationEvent(notification);
        }
    }

    private void updateCenteringProperty(DEdge element, Notification notification) {
        IFigure figure;
        EdgeStyle edgeStyle;
        if (DiagramPackage.eINSTANCE.getEdgeStyle_Centered() == notification.getFeature() && (edgeStyle = element.getOwnedStyle()) != null && (figure = this.getFigure()) instanceof ViewEdgeFigure) {
            ((ViewEdgeFigure)figure).setCentering(edgeStyle.getCentered());
        }
    }

    @Override
    public PolylineConnectionEx getPolylineConnectionFigure() {
        Connection connection = this.getConnectionFigure();
        if (connection instanceof PolylineConnectionEx) {
            return (PolylineConnectionEx)connection;
        }
        throw new IllegalStateException();
    }

    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        DiagramEdgeEditPartOperation.refreshVisuals(this);
    }

    protected void refreshVisibility() {
        boolean gmfModelVisibility = ((View)this.getModel()).isVisible();
        if (gmfModelVisibility) {
            IGraphicalEditPart source = (IGraphicalEditPart)this.getSource();
            IGraphicalEditPart target = (IGraphicalEditPart)this.getTarget();
            if (source == null || target == null) {
                this.setVisibility(false);
            } else if (!source.getFigure().isShowing() || !target.getFigure().isShowing()) {
                this.setVisibility(false);
            } else {
                this.setVisibility(true);
            }
        } else {
            this.setVisibility(false);
        }
    }

    protected void refreshFont() {
        super.refreshFont();
        DiagramEdgeEditPartOperation.refreshFont(this);
    }

    protected void refreshBendpoints() {
        DEdge edge = this.getEdgeWithPath();
        if (edge == null) {
            if (this.getEdge().getBendpoints() instanceof RelativeBendpoints) {
                super.refreshBendpoints();
            }
        } else {
            DiagramEdgeEditPartOperation.refreshBendpointsWithPath(this, edge);
        }
    }

    private DEdge getEdgeWithPath() {
        DEdge edge;
        EObject semanticElement = this.resolveSemanticElement();
        if (semanticElement instanceof DEdge && (edge = (DEdge)semanticElement).getPath() != null && !edge.getPath().isEmpty()) {
            return edge;
        }
        return null;
    }

    @Override
    public void refreshForegroundColor() {
        if (!DiagramEdgeEditPartOperation.isSelected((EditPart)this) && !DiagramEdgeEditPartOperation.isLabelSelected(this)) {
            super.refreshForegroundColor();
            DiagramEdgeEditPartOperation.refreshForegroundColor(this);
        }
    }

    @Override
    public void refreshSourceDecoration() {
        DiagramEdgeEditPartOperation.refreshSourceDecoration(this);
    }

    @Override
    public void refreshTargetDecoration() {
        DiagramEdgeEditPartOperation.refreshTargetDecoration(this);
    }

    @Override
    public void refreshLineStyle() {
        DiagramEdgeEditPartOperation.refreshLineStyle(this);
    }

    @Override
    public NotificationListener getEAdapterDiagramElement() {
        if (this.adapterDiagramElement == null) {
            this.adapterDiagramElement = DiagramElementEditPartOperation.createEApdaterDiagramElement(this);
        }
        return this.adapterDiagramElement;
    }

    @Override
    public NotificationListener getEditModeListener() {
        return this.editModeListener;
    }

    @Override
    public NotificationPreCommitListener getEAdapterRoutingStyle() {
        if (this.adapterRoutingStyle == null) {
            this.adapterRoutingStyle = DiagramEdgeEditPartOperation.createEAdapterRoutingStyle(this);
        }
        return this.adapterRoutingStyle;
    }

    @Override
    public EditPartAuthorityListener getEditPartAuthorityListener() {
        return this.authListener;
    }

    @Override
    public Class<?> getMetamodelType() {
        return DEdge.class;
    }

    @Override
    public IStyleEditPart getStyleEditPart() {
        return DiagramElementEditPartOperation.getStyleEditPart(this);
    }

    @Override
    public List<EObject> resolveAllSemanticElements() {
        return DiagramElementEditPartOperation.resolveAllSemanticElements(this);
    }

    @Override
    public DDiagramElement resolveDiagramElement() {
        return DiagramElementEditPartOperation.resolveDiagramElement(this);
    }

    @Override
    public EObject resolveTargetSemanticElement() {
        return DiagramElementEditPartOperation.resolveTargetSemanticElement(this);
    }

    @Override
    public void routingStyleChanged(Notification message) {
        DiagramEdgeEditPartOperation.routingStyleChanged(this, message);
    }

    public void activate() {
        EObject element;
        if (!this.isActive() && (element = this.resolveSemanticElement()) instanceof DEdge) {
            super.activate();
            DiagramElementEditPartOperation.activate(this);
            DiagramEdgeEditPartOperation.activate(this);
        }
        this.installRouter();
    }

    public void deactivate() {
        if (this.isActive()) {
            DiagramEdgeEditPartOperation.deactivate(this);
            DiagramElementEditPartOperation.deactivate(this);
            super.deactivate();
        }
    }

    public void enableEditMode() {
        if (!this.authListener.isLocked()) {
            super.enableEditMode();
        }
    }

    protected void installRouter() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DEdge) {
            DEdge edge = (DEdge)element;
            if (edge.getPath() != null && !edge.getPath().isEmpty()) {
                this.getPolylineConnectionFigure().setConnectionRouter((ConnectionRouter)ROUTER);
            } else {
                super.installRouter();
            }
        }
    }

    protected void refreshRoutingStyles() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DEdge) {
            super.refreshRoutingStyles();
        }
    }

    protected void refreshRouterChange() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DEdge) {
            super.refreshRouterChange();
        }
    }

    @Override
    public Image getLabelIcon() {
        return DiagramElementEditPartOperation.getLabelIcon(this);
    }

    protected Connection createConnectionFigure() {
        return new ViewEdgeFigure();
    }

    private static boolean invalidPath(AbstractDiagramEdgeEditPart editPart, DEdge edge) {
        return true;
    }

    public void performRequest(Request request) {
        if (request instanceof DirectEditRequest || "direct edit".equals(request.getType())) {
            this.performDirectEditRequest(request);
        } else {
            super.performRequest(request);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart result = null;
        AbstractToolDescription tool = null;
        if (request instanceof CreateRequest && !(request instanceof CreateUnspecifiedTypeConnectionRequest) && ((CreateRequest)request).getNewObject() instanceof AbstractToolDescription) {
            tool = (AbstractToolDescription)((CreateRequest)request).getNewObject();
        }
        if (tool instanceof RequestDescription || tool instanceof SelectionWizardDescription || tool instanceof PaneBasedSelectionWizardDescription) {
            return this;
        }
        if (request instanceof SelectionRequest) {
            Point location;
            boolean expandSource = false;
            boolean expandTarget = false;
            Rectangle sourceBoundsWithMargin = null;
            Rectangle targetBoundsWithMargin = null;
            int horizontalSourceIncrement = 0;
            int verticalSourceIncrement = 0;
            int horizontalTargetIncrement = 0;
            int verticalTargetIncrement = 0;
            Rectangle sourceBounds = null;
            Rectangle targetBounds = null;
            if (this.getSource() instanceof AbstractBorderItemEditPart) {
                sourceBounds = GraphicalHelper.getAbsoluteBounds((IGraphicalEditPart)((IGraphicalEditPart)this.getSource()));
                horizontalSourceIncrement = 20 > sourceBounds.width ? Math.round((20 - sourceBounds.width) / 2) : 0;
                int n = verticalSourceIncrement = 20 > sourceBounds.height ? Math.round((20 - sourceBounds.height) / 2) : 0;
                if (horizontalSourceIncrement > 0 || verticalSourceIncrement > 0) {
                    expandSource = true;
                    sourceBoundsWithMargin = sourceBounds.getExpanded(horizontalSourceIncrement, verticalSourceIncrement);
                } else {
                    sourceBoundsWithMargin = sourceBounds;
                }
            }
            if (this.getTarget() instanceof AbstractBorderItemEditPart) {
                targetBounds = GraphicalHelper.getAbsoluteBounds((IGraphicalEditPart)((IGraphicalEditPart)this.getTarget()));
                horizontalTargetIncrement = 20 > targetBounds.width ? Math.round((20 - targetBounds.width) / 2) : 0;
                int n = verticalTargetIncrement = 20 > targetBounds.height ? Math.round((20 - targetBounds.height) / 2) : 0;
                if (horizontalTargetIncrement > 0 || verticalTargetIncrement > 0) {
                    expandTarget = true;
                    targetBoundsWithMargin = targetBounds.getExpanded(horizontalTargetIncrement, verticalTargetIncrement);
                } else {
                    targetBoundsWithMargin = targetBounds;
                }
            }
            boolean isEdgeSelectableZonePresent = false;
            if (expandTarget || expandSource) {
                Rectangle edgeBounds = GraphicalHelper.getAbsoluteBounds((IGraphicalEditPart)this);
                isEdgeSelectableZonePresent = this.isEdgeSelectableZonePresent(edgeBounds, sourceBoundsWithMargin, targetBoundsWithMargin);
            }
            if ((location = ((SelectionRequest)request).getLocation()) != null) {
                boolean returnSource = isEdgeSelectableZonePresent && sourceBoundsWithMargin != null && sourceBoundsWithMargin.contains(location);
                boolean bl = returnSource = returnSource || sourceBounds != null && sourceBounds.contains(location);
                if (returnSource) {
                    result = this.getSource();
                } else if (result == null) {
                    boolean returnTarget = isEdgeSelectableZonePresent && targetBoundsWithMargin != null && targetBoundsWithMargin.contains(location);
                    boolean bl2 = returnTarget = returnTarget || targetBounds != null && targetBounds.contains(location);
                    if (returnTarget) {
                        result = this.getTarget();
                    }
                }
            }
        }
        if (result == null) {
            result = super.getTargetEditPart(request);
        }
        return result;
    }

    private boolean isEdgeSelectableZonePresent(Rectangle edgeBounds, Rectangle sourceBoundsWithMargins, Rectangle targetBoundsWithMargins) {
        if (sourceBoundsWithMargins == null && targetBoundsWithMargins == null) {
            return true;
        }
        boolean isEdgeSelectableZonePresent = false;
        if (sourceBoundsWithMargins != null && targetBoundsWithMargins != null) {
            Rectangle sourceTargetUnionBox = sourceBoundsWithMargins.getUnion(targetBoundsWithMargins);
            isEdgeSelectableZonePresent = isEdgeSelectableZonePresent || sourceTargetUnionBox.x - edgeBounds.x > 20;
            isEdgeSelectableZonePresent = isEdgeSelectableZonePresent || edgeBounds.x + edgeBounds.width - (sourceTargetUnionBox.x + sourceTargetUnionBox.width) > 20;
            isEdgeSelectableZonePresent = isEdgeSelectableZonePresent || sourceTargetUnionBox.y - edgeBounds.y > 20;
            boolean bl = isEdgeSelectableZonePresent = isEdgeSelectableZonePresent || edgeBounds.y + edgeBounds.height - (sourceTargetUnionBox.y + sourceTargetUnionBox.height) > 20;
        }
        if (!isEdgeSelectableZonePresent) {
            isEdgeSelectableZonePresent = sourceBoundsWithMargins == null || targetBoundsWithMargins == null ? edgeBounds.width - 20 >= 20 || edgeBounds.height - 20 > 20 : edgeBounds.width - 40 >= 20 || edgeBounds.height - 40 >= 20;
        }
        return isEdgeSelectableZonePresent;
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            return SiriusSnapToHelperUtil.getSnapHelper((GraphicalEditPart)this.getSource());
        }
        return super.getAdapter(key);
    }

    public RoutingStyle getRoutingStyle() {
        return this.routingStyle;
    }

    public void setRoutingStyle(RoutingStyle activatedRoutingStyle) {
        this.routingStyle = activatedRoutingStyle;
    }

    public NotificationPreCommitListener getRoutingStyleNotificationPreCommitListener() {
        return this.routingStyleNotificationPreCommitListener;
    }

    public void setRoutingStyleNotificationPreCommitListener(NotificationPreCommitListener activatedRoutingStyleNotificationPreCommitListener) {
        this.routingStyleNotificationPreCommitListener = activatedRoutingStyleNotificationPreCommitListener;
    }

    public class ViewEdgeFigure
    extends SiriusPolylineConnectionEx
    implements ITreeConnection {
        private SiriusWrapLabelWithAttachment fFigureViewEdgeNameFigure;
        private SiriusWrapLabelWithAttachment fFigureViewEdgeBeginNameFigure;
        private SiriusWrapLabelWithAttachment fFigureViewEdgeEndNameFigure;
        private Polyline attachmentToEdgeNameFigure;
        private Polyline attachmentToEdgeBeginNameFigure;
        private Polyline attachmentToEdgeEndNameFigure;
        private CenteringStyle centeringStyle;

        public ViewEdgeFigure() {
            this.createContents();
        }

        private void createContents() {
            EObject element = AbstractDiagramEdgeEditPart.this.resolveSemanticElement();
            this.createCenterLabelFigure(element);
            this.createBeginLabelFigure(element);
            this.createEndLabelFigure(element);
            this.initCentering(element);
        }

        private void initCentering(EObject element) {
            EdgeStyle edgeStyle;
            if (element instanceof DEdge && (edgeStyle = ((DEdge)element).getOwnedStyle()) != null) {
                this.setCentering(edgeStyle.getCentered());
            }
        }

        private void setCentering(CenteringStyle centering) {
            this.centeringStyle = centering;
        }

        public CenteringStyle getCenteringStyle() {
            return this.centeringStyle;
        }

        public boolean isSourceCentered() {
            return CenteringStyle.BOTH == this.getCenteringStyle() || CenteringStyle.SOURCE == this.getCenteringStyle();
        }

        public boolean isTargetCentered() {
            return CenteringStyle.BOTH == this.getCenteringStyle() || CenteringStyle.TARGET == this.getCenteringStyle();
        }

        private void createCenterLabelFigure(EObject element) {
            this.attachmentToEdgeNameFigure = this.addNewAttachmentFigure();
            this.fFigureViewEdgeNameFigure = new SiriusWrapLabelWithAttachmentWithModel(50, this.attachmentToEdgeNameFigure);
            if (element instanceof DEdge) {
                DEdge edge = (DEdge)element;
                this.fFigureViewEdgeNameFigure.setText(edge.getName());
                this.fFigureViewEdgeNameFigure.setVisible(!StringUtil.isEmpty((String)edge.getName()));
            } else {
                this.fFigureViewEdgeNameFigure.setVisible(false);
            }
            this.fFigureViewEdgeNameFigure.setLabelAlignment(2);
            this.fFigureViewEdgeNameFigure.setTextWrap(true);
            this.fFigureViewEdgeNameFigure.setTextWrapAlignment(2);
            this.add((IFigure)this.fFigureViewEdgeNameFigure);
        }

        private void createBeginLabelFigure(EObject element) {
            this.attachmentToEdgeBeginNameFigure = this.addNewAttachmentFigure();
            this.fFigureViewEdgeBeginNameFigure = new SiriusWrapLabelWithAttachmentWithModel(15, this.attachmentToEdgeBeginNameFigure);
            if (element instanceof DEdge) {
                DEdge edge = (DEdge)element;
                this.fFigureViewEdgeBeginNameFigure.setText(edge.getBeginLabel());
                this.fFigureViewEdgeBeginNameFigure.setVisible(!StringUtil.isEmpty((String)edge.getBeginLabel()));
            } else {
                this.fFigureViewEdgeBeginNameFigure.setVisible(false);
            }
            this.fFigureViewEdgeBeginNameFigure.setLabelAlignment(1);
            this.fFigureViewEdgeBeginNameFigure.setTextWrap(true);
            this.fFigureViewEdgeBeginNameFigure.setTextWrapAlignment(2);
            this.add((IFigure)this.fFigureViewEdgeBeginNameFigure);
        }

        private Polyline addNewAttachmentFigure() {
            Polyline newAttachment = new Polyline();
            newAttachment.setLineStyle(4);
            newAttachment.setForegroundColor(Display.getCurrent().getSystemColor(26));
            newAttachment.setVisible(false);
            this.add((IFigure)newAttachment);
            return newAttachment;
        }

        private void createEndLabelFigure(EObject element) {
            this.attachmentToEdgeEndNameFigure = this.addNewAttachmentFigure();
            this.fFigureViewEdgeEndNameFigure = new SiriusWrapLabelWithAttachmentWithModel(85, this.attachmentToEdgeEndNameFigure);
            if (element instanceof DEdge) {
                DEdge edge = (DEdge)element;
                this.fFigureViewEdgeEndNameFigure.setText(edge.getEndLabel());
                this.fFigureViewEdgeEndNameFigure.setVisible(!StringUtil.isEmpty((String)edge.getEndLabel()));
            } else {
                this.fFigureViewEdgeEndNameFigure.setVisible(false);
            }
            this.fFigureViewEdgeEndNameFigure.setLabelAlignment(2);
            this.fFigureViewEdgeEndNameFigure.setTextWrap(true);
            this.fFigureViewEdgeEndNameFigure.setTextWrapAlignment(2);
            this.add((IFigure)this.fFigureViewEdgeEndNameFigure);
        }

        public void layout() {
            if (!AbstractDiagramEdgeEditPart.this.isActive()) {
                return;
            }
            EObject element = AbstractDiagramEdgeEditPart.this.resolveSemanticElement();
            if (element != null && DEdge.class.isInstance(element)) {
                DEdge edge = (DEdge)element;
                boolean needRefreshVisuals = false;
                if (edge.getPath() != null && !edge.getPath().isEmpty() && AbstractDiagramEdgeEditPart.invalidPath(AbstractDiagramEdgeEditPart.this, edge) && AbstractDiagramEdgeEditPart.this.getSelected() != 2) {
                    needRefreshVisuals = true;
                }
                if (needRefreshVisuals || edge.isIsMockEdge()) {
                    AbstractDiagramEdgeEditPart.this.refreshVisuals();
                }
                if (this.getBounds() != null && AbstractDiagramEdgeEditPart.this.getSource() != null && AbstractDiagramEdgeEditPart.this.getTarget() != null) {
                    super.layout();
                }
                if (edge.getName() == null || StringUtil.isEmpty((String)edge.getName())) {
                    this.fFigureViewEdgeNameFigure.setVisible(false);
                }
                if (!(edge.getName() == null || StringUtil.isEmpty((String)edge.getName()) || new DDiagramElementQuery((DDiagramElement)edge).isLabelHidden() || this.fFigureViewEdgeNameFigure.isVisible())) {
                    this.fFigureViewEdgeNameFigure.setVisible(true);
                }
                if (edge.getEndLabel() == null || StringUtil.isEmpty((String)edge.getEndLabel())) {
                    this.fFigureViewEdgeEndNameFigure.setVisible(false);
                }
                if (!(edge.getEndLabel() == null || StringUtil.isEmpty((String)edge.getEndLabel()) || new DDiagramElementQuery((DDiagramElement)edge).isLabelHidden() || this.fFigureViewEdgeEndNameFigure.isVisible())) {
                    this.fFigureViewEdgeEndNameFigure.setVisible(true);
                }
                if (edge.getBeginLabel() == null || StringUtil.isEmpty((String)edge.getBeginLabel())) {
                    this.fFigureViewEdgeBeginNameFigure.setVisible(false);
                }
                if (!(edge.getBeginLabel() == null || StringUtil.isEmpty((String)edge.getBeginLabel()) || new DDiagramElementQuery((DDiagramElement)edge).isLabelHidden() || this.fFigureViewEdgeBeginNameFigure.isVisible())) {
                    this.fFigureViewEdgeBeginNameFigure.setVisible(true);
                }
            }
        }

        public void paintFigure(Graphics graphics) {
            if (!AbstractDiagramEdgeEditPart.this.isActive()) {
                return;
            }
            EObject element = AbstractDiagramEdgeEditPart.this.resolveSemanticElement();
            if (element != null && DEdge.class.isInstance(element)) {
                DEdge viewEdge = (DEdge)element;
                DDiagram diagram = viewEdge.getParentDiagram();
                if (!viewEdge.isIsMockEdge() && viewEdge.isVisible() || diagram != null && diagram.isIsInShowingMode()) {
                    ShowingViewUtil.initGraphicsForVisibleAndInvisibleElements((IFigure)this, graphics, (View)AbstractDiagramEdgeEditPart.this.getModel());
                    try {
                        super.paintFigure(graphics);
                        graphics.restoreState();
                    }
                    finally {
                        graphics.popState();
                    }
                }
            }
        }

        protected void paintChildren(Graphics graphics) {
            if (!AbstractDiagramEdgeEditPart.this.isActive()) {
                return;
            }
            EObject element = AbstractDiagramEdgeEditPart.this.resolveSemanticElement();
            if (element != null && DEdge.class.isInstance(element)) {
                DEdge viewEdge = (DEdge)element;
                DEdgeQuery dEdgeQuery = new DEdgeQuery(viewEdge);
                Optional<DDiagram> diagram = dEdgeQuery.getDDiagram();
                if (viewEdge.isVisible() || diagram.isPresent() && diagram.get().isIsInShowingMode()) {
                    super.paintChildren(graphics);
                }
            }
        }

        public SiriusWrapLabel getFigureViewEdgeNameFigure() {
            return this.fFigureViewEdgeNameFigure;
        }

        public SiriusWrapLabel getFigureViewBeginEdgeNameFigure() {
            return this.fFigureViewEdgeBeginNameFigure;
        }

        public SiriusWrapLabel getFigureViewEndEdgeNameFigure() {
            return this.fFigureViewEdgeEndNameFigure;
        }

        public RotatableDecoration getSourceDecoration() {
            return super.getSourceDecoration();
        }

        public RotatableDecoration getTargetDecoration() {
            return super.getTargetDecoration();
        }

        public String getHint() {
            if (AbstractDiagramEdgeEditPart.this.getTarget() != null) {
                return AbstractDiagramEdgeEditPart.this.getTarget().toString();
            }
            return "base";
        }

        public ITreeConnection.Orientation getOrientation() {
            return ITreeConnection.Orientation.VERTICAL;
        }

        public IGraphicalEditPart getEditPart() {
            return AbstractDiagramEdgeEditPart.this;
        }

        public final class SiriusWrapLabelWithAttachmentWithModel
        extends SiriusWrapLabelWithAttachment {
            private View model;

            private SiriusWrapLabelWithAttachmentWithModel(int location, Polyline attachment) {
                super(location, attachment);
            }

            public void setModel(View model) {
                this.model = model;
            }

            public void paint(Graphics graphics) {
                ShowingViewUtil.initGraphicsForVisibleAndInvisibleElements((IFigure)this, graphics, this.model);
                try {
                    super.paint(graphics);
                    graphics.restoreState();
                }
                finally {
                    graphics.popState();
                }
            }
        }
    }
}

