/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.IUserActionContext;
import org.eclipse.rse.internal.useractions.IUserActionModel;

public class UserActionRegistry {
    private static UserActionRegistry registry;
    private Map userActionContextMap = new HashMap();
    private Map userActionModelMap = new HashMap();

    private UserActionRegistry() {
    }

    public static UserActionRegistry getInstance() {
        if (registry == null) {
            registry = new UserActionRegistry();
        }
        return registry;
    }

    private Map getUserActionContextMap(ISystemProfile profile) {
        if (!this.userActionContextMap.containsKey(profile)) {
            this.userActionContextMap.put(profile, new HashMap());
        }
        return (Map)this.userActionContextMap.get(profile);
    }

    private Map getUserActionModelMap(ISystemProfile profile) {
        if (!this.userActionModelMap.containsKey(profile)) {
            this.userActionModelMap.put(profile, new HashMap());
        }
        return (Map)this.userActionModelMap.get(profile);
    }

    private List getUserActionContexts(Map map, ISubSystemConfiguration configuration) {
        if (!map.containsKey(configuration)) {
            map.put(configuration, new ArrayList());
        }
        return (List)map.get(configuration);
    }

    private List getUserActionModels(Map map, ISubSystemConfiguration configuration) {
        if (!map.containsKey(configuration)) {
            map.put(configuration, new ArrayList());
        }
        return (List)map.get(configuration);
    }

    public boolean containsUserActionContext(ISystemProfile profile, ISubSystemConfiguration configuration, IUserActionContext context) {
        Map map = this.getUserActionContextMap(profile);
        List list = this.getUserActionContexts(map, configuration);
        return list.contains(context);
    }

    public boolean containsUserActionModel(ISystemProfile profile, ISubSystemConfiguration configuration, IUserActionContext context) {
        Map map = this.getUserActionModelMap(profile);
        List list = this.getUserActionModels(map, configuration);
        return list.contains(context);
    }

    public void addUserActionContext(ISystemProfile profile, ISubSystemConfiguration configuration, IUserActionContext context) {
        Map map = this.getUserActionContextMap(profile);
        List list = this.getUserActionContexts(map, configuration);
        list.add(context);
    }

    public void addUserActionModel(ISystemProfile profile, ISubSystemConfiguration configuration, IUserActionModel model) {
        Map map = this.getUserActionModelMap(profile);
        List list = this.getUserActionModels(map, configuration);
        list.add(model);
    }

    public void removeUserActionContext(ISystemProfile profile, ISubSystemConfiguration configuration, IUserActionContext context) {
        Map map = this.getUserActionContextMap(profile);
        List list = this.getUserActionContexts(map, configuration);
        list.remove(context);
    }

    public void removeUserActionModel(ISystemProfile profile, ISubSystemConfiguration configuration, IUserActionModel model) {
        Map map = this.getUserActionModelMap(profile);
        List list = this.getUserActionModels(map, configuration);
        list.remove(model);
    }

    public IUserActionContext[] getUserActionContexts(ISystemProfile profile, ISubSystemConfiguration configuration) {
        Map map = this.getUserActionContextMap(profile);
        List list = this.getUserActionContexts(map, configuration);
        return (IUserActionContext[])list.toArray();
    }

    public IUserActionModel[] getUserActionModels(ISystemProfile profile, ISubSystemConfiguration configuration) {
        Map map = this.getUserActionModelMap(profile);
        List list = this.getUserActionModels(map, configuration);
        return (IUserActionModel[])list.toArray();
    }
}

