/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.server;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.wst.server.ui.Runtime;
import org.eclipse.reddeer.eclipse.wst.server.ui.RuntimePreferencePage;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersView2;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersViewEnums;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfiguration;
import org.eclipse.reddeer.requirements.server.ServerRequirementState;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;

public abstract class AbstractServerRequirement {
    private static final Logger LOGGER = Logger.getLogger(AbstractServerRequirement.class);

    protected void setupServerState(ServerRequirementState requiredState) {
        LOGGER.info("Checking the state of the server '" + this.getServerName() + "'");
        Server serverInView = this.getConfiguredServer();
        ServersViewEnums.ServerState state = serverInView.getLabel().getState();
        switch (state) {
            case STARTED: {
                if (requiredState != ServerRequirementState.STOPPED) break;
                serverInView.stop();
                break;
            }
            case STOPPED: {
                if (requiredState != ServerRequirementState.RUNNING) break;
                serverInView.start();
                break;
            }
            default: {
                new AssertionError((Object)("It was expected to have server in " + ServersViewEnums.ServerState.STARTED + " or " + ServersViewEnums.ServerState.STOPPED + "state." + " Not in state " + state + "."));
            }
        }
    }

    protected void removeServerAndRuntime() {
        Server serverInView = this.getConfiguredServer();
        if (serverInView == null) {
            return;
        }
        serverInView.delete(true);
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        preferenceDialog.open();
        RuntimePreferencePage runtimePage = new RuntimePreferencePage((ReferencedComposite)preferenceDialog);
        preferenceDialog.select((PreferencePage)runtimePage);
        runtimePage.removeRuntime(new Runtime(this.getRuntimeName(), "test"));
        preferenceDialog.ok();
    }

    protected Server getConfiguredServer() {
        ServersView2 serversView = new ServersView2();
        serversView.open();
        for (Server server : serversView.getServers()) {
            if (!this.getServerName().equals(server.getLabel().getName())) continue;
            return server;
        }
        return null;
    }

    protected boolean isLastConfiguredServerPresent() {
        return this.getConfiguredServer() != null;
    }

    public abstract String getServerName();

    public abstract String getRuntimeName();

    public abstract RequirementConfiguration getConfiguration();
}

