/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.m2e.core.ui.preferences;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;

public class WarningsPreferencePage
extends PreferencePage {
    public static final String GROUP_ID = "\"groupId\" duplicate of parent groupId";
    public static final String VERSION = "\"version\" duplicate of parent version";
    public static final String PROJECT_CONFIG = "Out-of-date project configuration";
    public static final String PLUGIN_EXECUTION = "Plugin execution not covered by lifecycle configuration";
    public static final String MANAGED_VERSION = "Overriding managed version";
    private static final Logger log = Logger.getLogger(WarningsPreferencePage.class);

    public WarningsPreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"Maven", "Errors/Warnings"});
    }

    public String getGroupId() {
        return new LabeledCombo((ReferencedComposite)this, GROUP_ID).getSelection();
    }

    public WarningsPreferencePage setGroupId(MavenErrorSeverity groupIdSeverity) {
        new LabeledCombo((ReferencedComposite)this, GROUP_ID).setSelection(groupIdSeverity.getValue());
        log.info("Set Maven error/warning Group ID to: " + groupIdSeverity.getValue());
        return this;
    }

    public String getVersion() {
        return new LabeledCombo((ReferencedComposite)this, VERSION).getSelection();
    }

    public WarningsPreferencePage setVersion(MavenErrorSeverity versionSeverity) {
        new LabeledCombo((ReferencedComposite)this, VERSION).setSelection(versionSeverity.getValue());
        log.info("Set Maven error/warning Version to: " + (Object)((Object)versionSeverity));
        return this;
    }

    public String getProjectConfig() {
        return new LabeledCombo((ReferencedComposite)this, PROJECT_CONFIG).getSelection();
    }

    public WarningsPreferencePage setProjectConfig(MavenErrorSeverity projectConfigSeverity) {
        new LabeledCombo((ReferencedComposite)this, PROJECT_CONFIG).setSelection(projectConfigSeverity.getValue());
        log.info("Set Maven error/warning Project Config to: " + (Object)((Object)projectConfigSeverity));
        return this;
    }

    public String getPluginExecution() {
        return new LabeledCombo((ReferencedComposite)this, PLUGIN_EXECUTION).getSelection();
    }

    public WarningsPreferencePage setPluginExecution(MavenErrorSeverity pluginExecutionSeverity) {
        new LabeledCombo((ReferencedComposite)this, PLUGIN_EXECUTION).setSelection(pluginExecutionSeverity.getValue());
        log.info("Set Maven error/warning Plugin Execution to: " + (Object)((Object)pluginExecutionSeverity));
        return this;
    }

    public String getManagedVersion() {
        return new LabeledCombo((ReferencedComposite)this, MANAGED_VERSION).getSelection();
    }

    public WarningsPreferencePage setManagedVersion(MavenErrorSeverity managedVersionSeverity) {
        new LabeledCombo((ReferencedComposite)this, MANAGED_VERSION).setSelection(managedVersionSeverity.getValue());
        log.info("Set Maven error/warning Managed Version to: " + (Object)((Object)managedVersionSeverity));
        return this;
    }

    public static enum MavenErrorSeverity {
        IGNORE("Ignore"),
        WARNING("Warning"),
        ERROR("Error");

        private String value;

        private MavenErrorSeverity(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

