/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class PDERuntimePlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.pde.runtime";
    private static PDERuntimePlugin inst;
    private BundleContext fContext;
    private ServiceTracker<?, PackageAdmin> packageAdminTracker;
    private ServiceTracker<?, PlatformAdmin> platformAdminTracker;
    public static final boolean HAS_IDE_BUNDLES;

    static {
        boolean result = false;
        try {
            result = PDERuntimePlugin.isBundleAvailable("org.eclipse.core.resources") && PDERuntimePlugin.isBundleAvailable("org.eclipse.pde.core") && PDERuntimePlugin.isBundleAvailable("org.eclipse.jdt.core") && PDERuntimePlugin.isBundleAvailable("org.eclipse.help") && PDERuntimePlugin.isBundleAvailable("org.eclipse.pde.ui") && PDERuntimePlugin.isBundleAvailable("org.eclipse.jdt.ui");
        }
        catch (Throwable throwable) {}
        HAS_IDE_BUNDLES = result;
    }

    public PDERuntimePlugin() {
        inst = this;
    }

    private static boolean isBundleAvailable(String bundleID) {
        Bundle bundle = Platform.getBundle((String)bundleID);
        return bundle != null && (bundle.getState() & 0x2C) != 0;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null) {
            return activeWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow activeWindow = PDERuntimePlugin.getActiveWorkbenchWindow();
        if (activeWindow != null) {
            return activeWindow.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public PackageAdmin getPackageAdmin() {
        if (this.packageAdminTracker == null) {
            return null;
        }
        return (PackageAdmin)this.packageAdminTracker.getService();
    }

    public PlatformAdmin getPlatformAdmin() {
        if (this.platformAdminTracker == null) {
            return null;
        }
        return (PlatformAdmin)this.platformAdminTracker.getService();
    }

    public static PDERuntimePlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return PDERuntimePlugin.getDefault().getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fContext = context;
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class, null);
        this.packageAdminTracker.open();
        this.platformAdminTracker = new ServiceTracker(context, PlatformAdmin.class, null);
        this.platformAdminTracker.open();
    }

    public BundleContext getBundleContext() {
        return this.fContext;
    }

    public State getState() {
        return this.getPlatformAdmin().getState(false);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else if (e.getMessage() != null) {
            status = new Status(4, ID, 0, e.getMessage(), e);
        }
        if (status != null) {
            PDERuntimePlugin.getDefault().getLog().log(status);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.packageAdminTracker != null) {
            this.packageAdminTracker.close();
            this.packageAdminTracker = null;
        }
        if (this.platformAdminTracker != null) {
            this.platformAdminTracker.close();
            this.platformAdminTracker = null;
        }
    }
}

