/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.acquire;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.acquire.HeapDumpProviderDescriptor;
import org.eclipse.mat.internal.acquire.VmInfoDescriptor;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.AnnotatedObjectArgumentsSet;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.acquire.AcquireSnapshotAction;
import org.eclipse.mat.ui.internal.acquire.ProviderContextImpl;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.mat.ui.internal.query.arguments.LinkEditor;
import org.eclipse.mat.ui.internal.query.arguments.TableEditorFactory;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ProviderArgumentsTable
implements ArgumentEditor.IEditorListener {
    private static final int MIN_EDITOR_WIDTH = 50;
    private static final String ARGUMENT = Messages.ArgumentsTable_Argument;
    private static final String VALUE = Messages.ArgumentsTable_Value;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Table table;
    private Font boldFont;
    private Font normalFont;
    private int tableRowHeight = -1;
    private IAnnotatedObjectDescriptor providerDescriptor;
    private AnnotatedObjectArgumentsSet argumentSet;
    private IQueryContext context;
    private List<ITableListener> listeners = Collections.synchronizedList(new ArrayList());
    private Map<ArgumentEditor, String> errors = Collections.synchronizedMap(new HashMap());

    public ProviderArgumentsTable(Composite parent, int style) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        parent.setLayout((Layout)tableColumnLayout);
        this.table = new Table(parent, style);
        Font parentFont = parent.getFont();
        this.table.setFont(parentFont);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(ARGUMENT);
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(0, 100));
        column = new TableColumn(this.table, 0);
        column.setText(VALUE);
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, 100));
        this.boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)parentFont).setStyle(1));
        this.normalFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)parentFont).setStyle(0));
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = ProviderArgumentsTable.this.tableRowHeight;
            }
        });
        new DefaultToolTip((Control)this.table, 2, false){

            private ArgumentDescriptor getEntry(Event event) {
                TableItem item = ProviderArgumentsTable.this.table.getItem(new Point(event.x, event.y));
                if (item != null && item.getData() != null) {
                    return ((ArgumentEditor)((Object)item.getData())).getDescriptor();
                }
                return null;
            }

            protected String getText(Event event) {
                ArgumentDescriptor entry = this.getEntry(event);
                if (entry != null) {
                    return entry.getHelp();
                }
                return null;
            }

            protected boolean shouldCreateToolTip(Event event) {
                ProviderArgumentsTable.this.table.setToolTipText("");
                return this.getEntry(event) != null && super.shouldCreateToolTip(event);
            }

            protected Object getToolTipArea(Event event) {
                return this.getEntry(event);
            }
        }.activate();
    }

    private void setTableRowHeight(int height) {
        if (height > this.tableRowHeight) {
            this.tableRowHeight = height;
            this.table.pack();
            this.table.getParent().pack();
        }
    }

    public AnnotatedObjectArgumentsSet getArgumentSet() {
        return this.argumentSet;
    }

    public IAnnotatedObjectDescriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    void createTableContent() {
        List argumentDescriptors = this.providerDescriptor.getArguments();
        for (ArgumentDescriptor descriptor : argumentDescriptors) {
            String flag = this.createArgumentLabel(descriptor);
            Object argumentValue = this.argumentSet.getArgumentValue(descriptor);
            if (descriptor.isMultiple()) {
                List values = (List)argumentValue;
                if (values == null) {
                    values = (List)descriptor.getDefaultValue();
                }
                if (values == null || values.isEmpty()) {
                    this.addEditorRow(descriptor, flag, null, -1);
                    continue;
                }
                Iterator valueIt = values.iterator();
                Object firstValue = valueIt.next();
                this.addEditorRow(descriptor, flag, firstValue, -1);
                while (valueIt.hasNext()) {
                    Object objValue = valueIt.next();
                    this.addEditorRow(descriptor, "..\"..", objValue, -1);
                }
                this.addEditorRow(descriptor, "..\"..", null, -1);
                continue;
            }
            Object value = argumentValue;
            if (value == null) {
                value = descriptor.getDefaultValue();
            }
            this.addEditorRow(descriptor, flag, value, -1);
        }
        Control[] controlArray = this.table.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof ArgumentEditor) {
                ((ArgumentEditor)control).addListener(this);
            }
            ++n2;
        }
        try {
            this.table.getChildren()[0].setFocus();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void addListener(ITableListener listener) {
        this.listeners.add(listener);
    }

    private String createArgumentLabel(ArgumentDescriptor descriptor) {
        String flag = descriptor.getFlag();
        if (flag == null) {
            return descriptor.getName();
        }
        return "-" + flag;
    }

    private void addEditorRow(ArgumentDescriptor descriptor, String flag, Object value, int index) {
        TableItem item = index > 0 ? new TableItem(this.table, 0, index) : new TableItem(this.table, 0);
        item.setText(flag);
        this.setFont(descriptor, item);
        TableEditor editor = this.createEditor();
        ArgumentEditor aec = TableEditorFactory.createTableEditor((Composite)this.table, this.context, descriptor, item);
        aec.setFont(item.getFont());
        editor.setEditor((Control)aec, item, 1);
        item.setData((Object)aec);
        this.setTableRowHeight(aec.computeSize((int)-1, (int)-1).y);
        if (index > 0) {
            aec.addListener(this);
            this.table.pack();
            this.table.getParent().pack();
            this.setNewTabOrder();
        }
        try {
            if (value != null) {
                aec.setValue(value);
            }
        }
        catch (SnapshotException snapshotException) {
            // empty catch block
        }
    }

    private void setFont(ArgumentDescriptor descriptor, TableItem item) {
        if (descriptor.isMandatory()) {
            item.setFont(this.normalFont);
            item.setFont(0, this.boldFont);
        } else {
            item.setFont(this.normalFont);
        }
    }

    private void setNewTabOrder() {
        TableItem[] items = this.table.getItems();
        Control[] newTabOrder = new Control[this.table.getChildren().length];
        int i = 0;
        int j = 0;
        while (i < items.length) {
            if (items[i].getData() != null) {
                newTabOrder[j] = (ArgumentEditor)((Object)items[i].getData());
            } else {
                --j;
            }
            ++i;
            ++j;
        }
        this.table.setTabList(newTabOrder);
    }

    private TableEditor createEditor() {
        TableEditor editor = new TableEditor(this.table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        return editor;
    }

    @Override
    public synchronized void onValueChanged(Object value, ArgumentDescriptor descriptor, TableItem item, ArgumentEditor argEditor) {
        boolean isLastOne;
        int myIndex = this.table.indexOf(item);
        this.onError(argEditor, null);
        this.onError(null, null);
        boolean bl = isLastOne = descriptor.isMultiple() && (myIndex + 1 == this.table.getItemCount() || ((ArgumentEditor)((Object)this.table.getItem(myIndex + 1).getData())).getDescriptor() != descriptor);
        if (descriptor.isMultiple()) {
            Object defaultValue;
            ArrayList<Object> values = new ArrayList<Object>();
            Control[] children = this.table.getChildren();
            int ii = 0;
            while (ii < children.length) {
                Object v;
                ArgumentEditor editor;
                if (children[ii] instanceof ArgumentEditor && (editor = (ArgumentEditor)children[ii]).getDescriptor() == descriptor && (v = editor.getValue()) != null) {
                    values.add(v);
                }
                ++ii;
            }
            if (values.isEmpty()) {
                values = null;
            }
            if ((defaultValue = descriptor.getDefaultValue()) == null || !defaultValue.equals(values)) {
                this.argumentSet.setArgumentValue(descriptor, values);
            } else {
                this.argumentSet.removeArgumentValue(descriptor);
            }
            if (descriptor.isMandatory() && values == null) {
                this.onError(argEditor, MessageUtil.format((String)Messages.ArgumentsTable_isMandatory, (Object[])new Object[]{descriptor.getName()}));
            }
            if (isLastOne && value != null) {
                this.addEditorRow(descriptor, "..\"..", null, myIndex + 1);
            }
        } else {
            Object defaultValue = descriptor.getDefaultValue();
            if (defaultValue == null || !defaultValue.equals(value)) {
                this.argumentSet.setArgumentValue(descriptor, value);
            } else {
                this.argumentSet.removeArgumentValue(descriptor);
            }
            if (descriptor.isMandatory() && value == null) {
                this.onError(argEditor, MessageUtil.format((String)Messages.ArgumentsTable_isMandatory, (Object[])new Object[]{descriptor.getName()}));
            }
        }
        if (this.providerDescriptor instanceof VmInfoDescriptor) {
            VmInfoDescriptor vmd = (VmInfoDescriptor)this.providerDescriptor;
            try {
                AcquireSnapshotAction.AcquireDumpOperation.setupVmInfo(vmd.getVmInfo(), this.argumentSet);
            }
            catch (SnapshotException snapshotException) {
                // empty catch block
            }
        }
        this.fireValueChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInputChangedEvent() {
        List<ITableListener> list = this.listeners;
        synchronized (list) {
            for (ITableListener listener : this.listeners) {
                listener.onInputChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireValueChangedEvent() {
        List<ITableListener> list = this.listeners;
        synchronized (list) {
            for (ITableListener listener : this.listeners) {
                listener.onValueChanged();
            }
        }
    }

    @Override
    public void onFocus(String message) {
        this.fireFocusChangedEvent(message);
    }

    @Override
    public void onModeChange(LinkEditor.Mode mode, ArgumentDescriptor descriptor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(ArgumentEditor editor, String message) {
        Map<ArgumentEditor, String> map = this.errors;
        synchronized (map) {
            if (message == null) {
                this.errors.remove((Object)editor);
                Iterator<Map.Entry<ArgumentEditor, String>> i = this.errors.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<ArgumentEditor, String> e = i.next();
                    if (!e.getKey().isDisposed()) continue;
                    i.remove();
                }
                if (this.errors.isEmpty()) {
                    this.fireErrorMessageEvent(null);
                } else {
                    this.fireErrorMessageEvent(this.errors.values().iterator().next());
                }
            } else {
                this.errors.put(editor, message);
                this.fireErrorMessageEvent(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireErrorMessageEvent(String message) {
        List<ITableListener> list = this.listeners;
        synchronized (list) {
            for (ITableListener listener : this.listeners) {
                listener.onError(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFocusChangedEvent(String message) {
        List<ITableListener> list = this.listeners;
        synchronized (list) {
            for (ITableListener listener : this.listeners) {
                listener.onFocus(message);
            }
        }
    }

    public void providerSelected(AnnotatedObjectArgumentsSet newArgumentsSet) {
        if (newArgumentsSet == null) {
            this.providerDescriptor = null;
            this.clearTable();
            this.argumentSet = null;
            this.context = null;
            return;
        }
        IAnnotatedObjectDescriptor newProviderDescriptor = newArgumentsSet.getDescriptor();
        if (!newProviderDescriptor.equals(this.providerDescriptor)) {
            for (ArgumentDescriptor ad : newProviderDescriptor.getArguments()) {
                try {
                    Object defaultValue = newProviderDescriptor instanceof HeapDumpProviderDescriptor ? ad.getField().get(((HeapDumpProviderDescriptor)newProviderDescriptor).getHeapDumpProvider()) : (newProviderDescriptor instanceof VmInfoDescriptor ? ad.getField().get(((VmInfoDescriptor)newProviderDescriptor).getVmInfo()) : null);
                    if (ad.isArray() && defaultValue != null) {
                        int size = Array.getLength(defaultValue);
                        ArrayList<Object> l = new ArrayList<Object>(size);
                        int ii = 0;
                        while (ii < size) {
                            l.add(Array.get(defaultValue, ii));
                            ++ii;
                        }
                        ad.setDefaultValue(Collections.unmodifiableList(l));
                        continue;
                    }
                    ad.setDefaultValue(defaultValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            this.providerDescriptor = newProviderDescriptor;
            this.clearTable();
            this.argumentSet = newArgumentsSet;
            this.context = new ProviderContextImpl();
            this.createTableContent();
        }
        this.fireInputChangedEvent();
    }

    private void clearTable() {
        Control[] controls;
        this.table.removeAll();
        Control[] controlArray = controls = this.table.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof ArgumentEditor) {
                control.dispose();
            }
            ++n2;
        }
    }

    public static interface ITableListener {
        public void onInputChanged();

        public void onValueChanged();

        public void onError(String var1);

        public void onFocus(String var1);
    }
}

