/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.util;

import org.eclipse.mat.util.IProgressListener;

public class SimpleMonitor {
    String task;
    IProgressListener delegate;
    int currentMonitor;
    int[] percentages;

    public SimpleMonitor(String task, IProgressListener monitor, int[] percentages) {
        this.task = task;
        this.delegate = monitor;
        this.percentages = percentages;
    }

    public IProgressListener nextMonitor() {
        if (this.delegate instanceof Listener) {
            Listener l = (Listener)this.delegate;
            int togo = l.majorUnits - l.unitsReported;
            int todo = 0;
            int i = this.currentMonitor;
            while (i < this.percentages.length) {
                todo += this.percentages[i];
                ++i;
            }
            if (this.currentMonitor == 0) {
                this.delegate.beginTask(this.task, togo);
            }
            return new Listener((int)((long)this.percentages[this.currentMonitor++] * (long)togo / (long)todo));
        }
        if (this.currentMonitor == 0) {
            int total = 0;
            int[] nArray = this.percentages;
            int n = this.percentages.length;
            int n2 = 0;
            while (n2 < n) {
                int ii = nArray[n2];
                total += ii;
                ++n2;
            }
            this.delegate.beginTask(this.task, total);
        }
        return new Listener(this.percentages[this.currentMonitor++]);
    }

    public class Listener
    implements IProgressListener {
        long counter;
        int majorUnits;
        int unitsReported;
        long workDone;
        long workPerUnit;
        boolean isSmaller;

        public Listener(int majorUnits) {
            this.majorUnits = majorUnits;
        }

        @Override
        public void beginTask(String name, int totalWork) {
            if (name != null) {
                SimpleMonitor.this.delegate.subTask(name);
            }
            if (totalWork == 0) {
                return;
            }
            if (this.workDone > 0L) {
                this.majorUnits = this.unitsReported < this.majorUnits ? (this.majorUnits -= this.unitsReported) : 0;
                this.workDone = 0L;
            }
            this.isSmaller = totalWork < this.majorUnits || this.majorUnits == 0;
            this.workPerUnit = this.isSmaller ? this.majorUnits / totalWork : totalWork / this.majorUnits;
            this.unitsReported = 0;
        }

        @Override
        public void subTask(String name) {
            SimpleMonitor.this.delegate.subTask(name);
        }

        @Override
        public void done() {
            if (this.majorUnits - this.unitsReported > 0) {
                SimpleMonitor.this.delegate.worked(this.majorUnits - this.unitsReported);
            }
        }

        @Override
        public boolean isCanceled() {
            return SimpleMonitor.this.delegate.isCanceled();
        }

        public boolean isProbablyCanceled() {
            return this.counter++ % 5000L == 0L ? this.isCanceled() : false;
        }

        public void totalWorkDone(long work) {
            if (this.workDone >= work) {
                return;
            }
            if (this.workPerUnit == 0L) {
                return;
            }
            this.workDone = work;
            int unitsWorked = this.isSmaller ? (int)(work * this.workPerUnit) : (int)(work / this.workPerUnit);
            int unitsToReport = (unitsWorked = Math.min(unitsWorked, this.majorUnits)) - this.unitsReported;
            if (unitsToReport > 0) {
                SimpleMonitor.this.delegate.worked(unitsToReport);
                this.unitsReported += unitsToReport;
            }
        }

        @Override
        public void worked(int work) {
            this.totalWorkDone(this.workDone + (long)work);
        }

        @Override
        public void setCanceled(boolean value) {
            SimpleMonitor.this.delegate.setCanceled(value);
        }

        @Override
        public void sendUserMessage(IProgressListener.Severity severity, String message, Throwable exception) {
            SimpleMonitor.this.delegate.sendUserMessage(severity, message, exception);
        }

        public long getWorkDone() {
            return this.workDone;
        }
    }
}

