/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.ArrayDescription;
import org.eclipse.mat.hprof.CompressedRandomAccessFile;
import org.eclipse.mat.hprof.DefaultPositionInputStream;
import org.eclipse.mat.hprof.FileCacheCompressedRandomAccessFile;
import org.eclipse.mat.hprof.IPositionInputStream;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.describer.Version;
import org.eclipse.mat.hprof.ui.HprofPreferences;
import org.eclipse.mat.parser.io.BufferedRandomAccessInputStream;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.ClassLoaderImpl;
import org.eclipse.mat.parser.model.InstanceImpl;
import org.eclipse.mat.parser.model.ObjectArrayImpl;
import org.eclipse.mat.parser.model.PrimitiveArrayImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.util.MessageUtil;

public class HprofRandomAccessParser
extends AbstractParser {
    public static final int LAZY_LOADING_LIMIT = 256;
    private final IPositionInputStream in;

    public HprofRandomAccessParser(File file, Version version, int identifierSize, long len, HprofPreferences.HprofStrictness strictnessPreference) throws IOException {
        super(strictnessPreference);
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        boolean gzip = CompressedRandomAccessFile.isGZIP(raf);
        if (gzip) {
            raf.close();
            long requested = len / 10L;
            long maxFree = CompressedRandomAccessFile.checkMemSpace(requested);
            raf = requested > maxFree && FileCacheCompressedRandomAccessFile.isDiskSpace(file, len) ? new FileCacheCompressedRandomAccessFile(file) : new CompressedRandomAccessFile(file, true, len);
        }
        this.in = new DefaultPositionInputStream((InputStream)new BufferedRandomAccessInputStream(raf, 512));
        this.version = version;
        this.idSize = identifierSize;
    }

    public synchronized void close() throws IOException {
        this.in.close();
    }

    public synchronized IObject read(int objectId, long position, ISnapshot dump) throws IOException, SnapshotException {
        this.in.seek(position);
        int segmentType = this.in.readUnsignedByte();
        switch (segmentType) {
            case 33: {
                return this.readInstanceDump(objectId, dump);
            }
            case 34: {
                return this.readObjectArrayDump(objectId, dump);
            }
            case 35: {
                return this.readPrimitiveArrayDump(objectId, dump);
            }
        }
        throw new IOException(MessageUtil.format((String)Messages.HprofRandomAccessParser_Error_IllegalDumpSegment, (Object[])new Object[]{segmentType, Long.toHexString(position)}));
    }

    public List<IClass> resolveClassHierarchy(ISnapshot snapshot, IClass clazz) throws SnapshotException {
        ArrayList<IClass> answer = new ArrayList<IClass>();
        answer.add(clazz);
        while (clazz.hasSuperClass()) {
            if ((clazz = (IClass)snapshot.getObject(clazz.getSuperClassId())) == null) {
                return null;
            }
            answer.add(clazz);
        }
        return answer;
    }

    private IObject readInstanceDump(int objectId, ISnapshot dump) throws IOException, SnapshotException {
        long address = this.in.readID(this.idSize);
        if (this.in.skipBytes(8 + this.idSize) != 8 + this.idSize) {
            throw new IOException();
        }
        List<IClass> hierarchy = this.resolveClassHierarchy(dump, dump.getClassOf(objectId));
        if (hierarchy == null) {
            throw new IOException(Messages.HprofRandomAccessParser_Error_DumpIncomplete);
        }
        ArrayList<Field> instanceFields = new ArrayList<Field>();
        for (IClass clazz : hierarchy) {
            List fields = clazz.getFieldDescriptors();
            int ii = 0;
            while (ii < fields.size()) {
                FieldDescriptor field = (FieldDescriptor)fields.get(ii);
                int type = field.getType();
                Object value = this.readValue(this.in, dump, type);
                instanceFields.add(new Field(field.getName(), field.getType(), value));
                ++ii;
            }
        }
        ClassImpl classImpl = (ClassImpl)hierarchy.get(0);
        if (dump.isClassLoader(objectId)) {
            return new ClassLoaderImpl(objectId, address, classImpl, instanceFields);
        }
        return new InstanceImpl(objectId, address, classImpl, instanceFields);
    }

    private IArray readObjectArrayDump(int objectId, ISnapshot dump) throws IOException, SnapshotException {
        long id = this.in.readID(this.idSize);
        this.in.skipBytes(4);
        int size = this.in.readInt();
        long arrayClassObjectID = this.in.readID(this.idSize);
        IClass arrayType = (IClass)dump.getObject(dump.mapAddressToId(arrayClassObjectID));
        if (arrayType == null) {
            throw new RuntimeException(Messages.HprofRandomAccessParser_Error_MissingFakeClass);
        }
        Object content = null;
        if ((long)size * (long)this.idSize < 256L) {
            long[] data = new long[size];
            int ii = 0;
            while (ii < data.length) {
                data[ii] = this.in.readID(this.idSize);
                ++ii;
            }
            content = data;
        } else {
            content = new ArrayDescription.Offline(false, this.in.position(), 0, size);
        }
        ObjectArrayImpl array = new ObjectArrayImpl(objectId, id, (ClassImpl)arrayType, size);
        array.setInfo(content);
        return array;
    }

    private IArray readPrimitiveArrayDump(int objectId, ISnapshot dump) throws IOException, SnapshotException {
        long id = this.in.readID(this.idSize);
        this.in.skipBytes(4);
        int arraySize = this.in.readInt();
        long elementType = this.in.readByte();
        if (elementType < 4L || elementType > 11L) {
            throw new IOException(Messages.Pass1Parser_Error_IllegalType);
        }
        int elementSize = IPrimitiveArray.ELEMENT_SIZE[(int)elementType];
        long len = (long)elementSize * (long)arraySize;
        Object content = null;
        if (len < 256L) {
            Object object;
            byte[] data = new byte[(int)len];
            this.in.readFully(data);
            if (elementType == 8L) {
                object = data;
            } else {
                ArrayDescription.Raw raw;
                object = raw;
                raw = new ArrayDescription.Raw(data);
            }
            content = object;
        } else {
            content = new ArrayDescription.Offline(true, this.in.position(), elementSize, arraySize);
        }
        IClass clazz = null;
        String name = IPrimitiveArray.TYPE[(int)elementType];
        Collection classes = dump.getClassesByName(name, false);
        if (classes == null || classes.isEmpty()) {
            throw new IOException(MessageUtil.format((String)Messages.HprofRandomAccessParser_Error_MissingClass, (Object[])new Object[]{name}));
        }
        if (classes.size() > 1) {
            throw new IOException(MessageUtil.format((String)Messages.HprofRandomAccessParser_Error_DuplicateClass, (Object[])new Object[]{name}));
        }
        clazz = (IClass)classes.iterator().next();
        PrimitiveArrayImpl array = new PrimitiveArrayImpl(objectId, id, (ClassImpl)clazz, arraySize, (int)elementType);
        array.setInfo(content);
        return array;
    }

    public synchronized long[] readObjectArray(ArrayDescription.Offline descriptor, int offset, int length) throws IOException {
        int elementSize = this.idSize;
        this.in.seek(descriptor.getPosition() + (long)offset * (long)elementSize);
        long[] data = new long[length];
        int ii = 0;
        while (ii < data.length) {
            data[ii] = this.in.readID(this.idSize);
            ++ii;
        }
        return data;
    }

    public synchronized byte[] readPrimitiveArray(ArrayDescription.Offline descriptor, int offset, int length) throws IOException {
        int elementSize = descriptor.getElementSize();
        this.in.seek(descriptor.getPosition() + (long)offset * (long)elementSize);
        byte[] data = new byte[length * elementSize];
        this.in.readFully(data);
        return data;
    }
}

