/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.businessprocess.ProjectBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.VersionDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class CreateNewProjectVersionHandler
extends AbstractHandler {
    private void fireReady() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.fireProjectLoadedListener((IProgressMonitor)new NullProgressMonitor());
        ded.fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
    }

    private IRunnableWithProgress createOperation(ProjectVersion projectVersion) {
        return new ProjectBP.NewVersionOperation(GeneralStorage.getInstance().getProject(), projectVersion);
    }

    private VersionDialog openVersionDialog() {
        ProjectVersion actualVersion = new ProjectVersion(Integer.valueOf(1), Integer.valueOf(0), null);
        try {
            GeneralStorage.getInstance().validateProjectExists(GeneralStorage.getInstance().getProject());
            actualVersion = GeneralStorage.getInstance().getProject().getProjectVersion();
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
            return null;
        }
        VersionDialog dialog = new VersionDialog(this.getActiveShell(), Messages.CreateNewProjectVersionActionTitle, actualVersion, Messages.CreateNewProjectVersionActionMessage, "bigProject.gif", Messages.CreateNewProjectVersionActionShellTitle){

            @Override
            protected boolean isInputAllowed() {
                ProjectVersion version = this.getFieldVersion();
                if (ProjectPM.doesProjectVersionExist((String)GeneralStorage.getInstance().getProject().getGuid(), (Integer)version.getMajorNumber(), (Integer)version.getMinorNumber(), (Integer)version.getMicroNumber(), (String)version.getVersionQualifier())) {
                    this.setErrorMessage(Messages.CreateNewProjectVersionActionDoubleVersion);
                    return false;
                }
                return true;
            }

            @Override
            protected void okPressed() {
                ProjectVersion version = this.getFieldVersion();
                if (ProjectPM.doesProjectVersionExist((String)GeneralStorage.getInstance().getProject().getGuid(), (Integer)version.getMajorNumber(), (Integer)version.getMinorNumber(), (Integer)version.getMicroNumber(), (String)version.getVersionQualifier())) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_PROJECTVERSION_ALREADY_EXISTS, (Object[])new Object[]{this.getProjectVersion()}, null);
                    return;
                }
                super.okPressed();
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogProjectCreateNewVersionContextId");
        dialog.open();
        return dialog;
    }

    public Object executeImpl(ExecutionEvent event) {
        Plugin.startLongRunning(Messages.SaveProjectAsActionWaitWhileSaving);
        VersionDialog dialog = this.openVersionDialog();
        if (dialog != null && dialog.getReturnCode() == 0) {
            ProjectVersion version = dialog.getProjectVersion();
            IRunnableWithProgress op = this.createOperation(version);
            try {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.busyCursorWhile(op);
                this.fireReady();
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof PMSaveException) {
                    PMExceptionHandler.handlePMExceptionForMasterSession((PMException)new PMSaveException(targetException.getMessage(), MessageIDs.E_CREATE_NEW_VERSION_FAILED));
                } else if (targetException instanceof PMException) {
                    PMExceptionHandler.handlePMExceptionForMasterSession((PMException)targetException);
                } else if (targetException instanceof ProjectDeletedException) {
                    PMExceptionHandler.handleProjectDeletedException();
                }
            }
            catch (InterruptedException interruptedException) {
                Utils.clearClient();
            }
        } else {
            Plugin.stopLongRunning();
        }
        return null;
    }
}

