/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICondStructPO;
import org.eclipse.jubula.client.core.model.IExecStackModificationListener;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.utils.Traverser;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;

public class ResultTreeBuilder
implements IExecStackModificationListener {
    private TestResultNode m_endNode;
    private TestResultNode m_rootNode;
    private TestResultNode m_lastCap;
    private int m_ignoreDepth;

    public ResultTreeBuilder(Traverser trav) {
        Validate.notNull((Object)trav, (String)Messages.NoTraverserInstance);
        this.m_endNode = this.m_rootNode = new TestResultNode(trav.getRoot(), null);
        this.m_ignoreDepth = 0;
    }

    @Override
    public void stackIncremented(INodePO node) {
        if (this.m_ignoreDepth > 0) {
            ++this.m_ignoreDepth;
            return;
        }
        if (node instanceof IAbstractContainerPO && node.getParentNode() instanceof ICondStructPO && !((ICondStructPO)node.getParentNode()).needIncludeInTRTree(node)) {
            this.m_ignoreDepth = 1;
            return;
        }
        this.m_endNode = new TestResultNode(node, this.m_endNode);
    }

    @Override
    public void stackDecremented() {
        if (this.m_ignoreDepth > 0) {
            --this.m_ignoreDepth;
            return;
        }
        this.m_endNode = this.m_endNode.getParent();
    }

    @Override
    public void nextDataSetIteration() {
        if (this.m_ignoreDepth > 0) {
            return;
        }
        this.m_endNode = new TestResultNode(this.m_endNode.getNode(), this.m_endNode.getParent());
    }

    @Override
    public void nextCap(ICapPO cap) {
        if (this.m_ignoreDepth > 0) {
            return;
        }
        this.m_lastCap = new TestResultNode(cap, this.m_endNode);
        this.m_lastCap.setActionName(CompSystemI18n.getString((String)cap.getActionName()));
        this.m_lastCap.setComponentType(CompSystemI18n.getString((String)cap.getComponentType()));
    }

    public TestResultNode getRootNode() {
        return this.m_rootNode;
    }

    @Override
    public void retryCap(ICapPO cap) {
        this.nextCap(cap);
    }

    @Override
    public void infiniteLoop() {
    }
}

