/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tooltip;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.tooltip.AbstractTooltipProvider;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

public class ReferenceChangeTooltipProvider
extends AbstractTooltipProvider<ReferenceChange> {
    public ReferenceChangeTooltipProvider(ComposedAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.labelProvider = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
    }

    @Override
    public String getTooltip(MergeMode mode) throws IllegalArgumentException {
        String tooltip;
        ReferenceChange diff = (ReferenceChange)this.target;
        boolean isFromLeft = this.isFromLeft(diff);
        boolean isContainment = diff.getReference().isContainment();
        switch (diff.getKind()) {
            case DELETE: {
                if (isContainment) {
                    tooltip = this.setDeleteContainmentTooltip(mode, diff, isFromLeft);
                    break;
                }
                tooltip = this.setDeleteNonContainmentTooltip(mode, diff, isFromLeft);
                break;
            }
            case ADD: {
                if (isContainment) {
                    tooltip = this.setAddContainmentTooltip(mode, diff, isFromLeft);
                    break;
                }
                tooltip = this.setAddNonContainmentTooltip(mode, diff, isFromLeft);
                break;
            }
            case MOVE: {
                if (isContainment) {
                    Match valueMatch = diff.getMatch().getComparison().getMatch(diff.getValue());
                    EObject left = valueMatch.getLeft();
                    EObject right = valueMatch.getRight();
                    EObject ancestor = valueMatch.getOrigin();
                    if (this.isContainerMove(isFromLeft, ancestor, right, left)) {
                        tooltip = this.setMoveContainerTooltip(mode, diff, isFromLeft, left, right, ancestor);
                        break;
                    }
                    tooltip = this.setMovePositionTooltip(mode, diff, isFromLeft);
                    break;
                }
                tooltip = this.setMovePositionTooltip(mode, diff, isFromLeft);
                break;
            }
            case CHANGE: {
                if (this.isUnset(diff)) {
                    tooltip = this.setUnsetTooltip(mode, diff, isFromLeft);
                    break;
                }
                tooltip = this.setSetTooltip(mode, diff, isFromLeft);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return tooltip;
    }

    private boolean isUnset(ReferenceChange diff) {
        boolean isUnset = false;
        Match match = diff.getMatch();
        EObject container = diff.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight();
        if (container == null) {
            isUnset = true;
        } else if (!ReferenceUtil.safeEIsSet((EObject)container, (EStructuralFeature)diff.getReference())) {
            isUnset = true;
        }
        return isUnset;
    }

    private boolean isContainerMove(boolean isFromLeft, EObject origin, EObject right, EObject left) {
        boolean isContainerMove = false;
        if (origin == null) {
            if (!(left == null || right == null || left.eContainingFeature() == right.eContainingFeature() && this.getLabelFromObject(left.eContainer()).equals(this.getLabelFromObject(right.eContainer())))) {
                isContainerMove = true;
            }
        } else if (isFromLeft) {
            if (!(left == null || left.eContainingFeature() == origin.eContainingFeature() && this.getLabelFromObject(left.eContainer()).equals(this.getLabelFromObject(origin.eContainer())))) {
                isContainerMove = true;
            }
        } else if (!(right == null || right.eContainingFeature() == origin.eContainingFeature() && this.getLabelFromObject(right.eContainer()).equals(this.getLabelFromObject(origin.eContainer())))) {
            isContainerMove = true;
        }
        return isContainerMove;
    }

    private String setMoveContainerTooltip(MergeMode mode, ReferenceChange diff, boolean isFromLeft, EObject left, EObject right, EObject ancestor) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        String leftContainerValue = "";
        if (left != null) {
            leftContainerValue = this.getLabelFromObject(left.eContainer());
        }
        String rightContainerValue = "";
        if (right != null) {
            rightContainerValue = this.getLabelFromObject(right.eContainer());
        }
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: 
            case RIGHT_TO_LEFT: {
                String key = "ContextualTooltip.move.container.";
                boolean isLeftToRightMode = mode == MergeMode.LEFT_TO_RIGHT;
                String effectiveLeft = this.getDirectionalValue(mirrored == isLeftToRightMode, leftContainerValue, rightContainerValue);
                String effectiveRight = this.getDirectionalValue(mirrored == isLeftToRightMode, rightContainerValue, leftContainerValue);
                key = isFromLeft != mirrored ? (isLeftToRightMode ? String.valueOf(key) + "left.leftToRight" : String.valueOf(key) + "left.rightToLeft") : (isLeftToRightMode ? String.valueOf(key) + "right.leftToRight" : String.valueOf(key) + "right.rightToLeft");
                String body = EMFCompareEditMessages.getString(key, value, effectiveLeft, effectiveRight);
                if (isLeftToRightMode) {
                    tooltip = this.rightChanged(body);
                    break;
                }
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                String effectiveLeft = this.getDirectionalValue(isLeftToRight == mirrored, leftContainerValue, rightContainerValue);
                String effectiveRight = this.getDirectionalValue(isLeftToRight == mirrored, rightContainerValue, leftContainerValue);
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.container.left.accept"), value, effectiveRight);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.container.right.accept"), value, effectiveLeft, effectiveRight);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                String effectiveLeft = this.getDirectionalValue(isLeftToRight == mirrored, leftContainerValue, rightContainerValue);
                String effectiveRight = this.getDirectionalValue(isLeftToRight == mirrored, rightContainerValue, leftContainerValue);
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String previousValue = null;
                    previousValue = diff.getMatch().getComparison().isThreeWay() && ancestor != null ? this.getLabelFromObject(ancestor.eContainer()) : effectiveLeft;
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.container.left.reject"), value, previousValue, effectiveRight);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.container.right.reject"), value, effectiveRight);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    private String setDeleteContainmentTooltip(MergeMode mode, ReferenceChange diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        String containerValue = this.getLabel((EObject)diff.getMatch());
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.left.leftToRight", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.right.leftToRight", value, containerValue);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.left.rightToLeft", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.right.rightToLeft", value, containerValue);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.delete.containment.left.accept"), value, containerValue);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.delete.containment.right.accept"), value, containerValue);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.delete.containment.left.reject"), value, containerValue);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.delete.containment.right.reject"), value, containerValue);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    private String setAddContainmentTooltip(MergeMode mode, ReferenceChange diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        String containerValue = this.getLabel((EObject)diff.getMatch());
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.add.containment.left.leftToRight", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.add.containment.right.leftToRight", value, containerValue);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.add.containment.left.rightToLeft", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.add.containment.right.rightToLeft", value, containerValue);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.add.containment.left.accept"), value, containerValue);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.add.containment.right.accept"), value, containerValue);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.add.containment.left.reject"), value, containerValue);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.add.containment.right.reject"), value, containerValue);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }
}

