/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.AbstractVMProviderActionDelegate;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.FetchMoreChildrenEvent;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbExpressionVMProvider;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbVariableVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbVariableVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class FetchMoreChildrenAction
extends AbstractVMProviderActionDelegate
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        GdbVariableVMNode.IncompleteChildrenVMC incompleteChildrenVmc = this.getIncompleteChildrenVMC();
        if (incompleteChildrenVmc != null && this.selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)this.selection;
            TreePath path = treeSelection.getPaths()[0];
            IVMNode node = incompleteChildrenVmc.getVMNode();
            IExpressions.IExpressionDMContext exprCtx = incompleteChildrenVmc.getParentDMContext();
            ((GdbVariableVMNode)node).incrementChildCountLimit(exprCtx);
            final FetchMoreChildrenEvent fetchMoreChildrenEvent = new FetchMoreChildrenEvent(exprCtx, path);
            final AbstractVMProvider vmProvider = (AbstractVMProvider)this.getVMProvider();
            vmProvider.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    vmProvider.handleEvent((Object)fetchMoreChildrenEvent);
                }
            });
        }
    }

    public void init(IViewPart view) {
        super.init(view);
        this.updateEnablement();
    }

    public void debugContextChanged(DebugContextEvent event) {
        super.debugContextChanged(event);
        this.updateEnablement();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.selection = selection;
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean enabled = false;
        if (this.getVMProvider() instanceof GdbExpressionVMProvider || this.getVMProvider() instanceof GdbVariableVMProvider) {
            enabled = this.getIncompleteChildrenVMC() != null;
        }
        this.getAction().setEnabled(enabled);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof IViewPart) {
            this.init((IViewPart)targetPart);
        }
    }

    private GdbVariableVMNode.IncompleteChildrenVMC getIncompleteChildrenVMC() {
        Object selectedObject;
        IStructuredSelection ss;
        if (this.selection instanceof IStructuredSelection && (ss = (IStructuredSelection)this.selection).size() == 1 && (selectedObject = ss.getFirstElement()) instanceof GdbVariableVMNode.IncompleteChildrenVMC) {
            return (GdbVariableVMNode.IncompleteChildrenVMC)((Object)selectedObject);
        }
        return null;
    }
}

