/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.win32;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.internal.core.win32.ProcessInfo;

public class ProcessList
implements IProcessList {
    private IProcessInfo[] NOPROCESS = new IProcessInfo[0];

    public IProcessInfo[] getProcessList() {
        try {
            ArrayList<ProcessInfo> processList = new ArrayList<ProcessInfo>();
            int[] nArray = PsapiUtil.enumProcesses();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int pid = nArray[n2];
                try {
                    String name = Kernel32Util.QueryFullProcessImageName(pid, 0);
                    processList.add(new ProcessInfo(pid, name));
                }
                catch (Win32Exception win32Exception) {
                    // empty catch block
                }
                ++n2;
            }
            return processList.toArray(new IProcessInfo[processList.size()]);
        }
        catch (Win32Exception e) {
            return this.NOPROCESS;
        }
    }

    private static abstract class Kernel32Util
    extends com.sun.jna.platform.win32.Kernel32Util {
        private Kernel32Util() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static final String QueryFullProcessImageName(int pid, int dwFlags) {
            String string;
            WinNT.HANDLE hProcess = null;
            Win32Exception we = null;
            try {
                hProcess = Kernel32.INSTANCE.OpenProcess(1040, false, pid);
                if (hProcess == null) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                string = Kernel32Util.QueryFullProcessImageName((WinNT.HANDLE)hProcess, (int)dwFlags);
            }
            catch (Win32Exception e) {
                try {
                    we = e;
                    throw we;
                }
                catch (Throwable throwable) {
                    block13: {
                        try {
                            Kernel32Util.closeHandle(hProcess);
                        }
                        catch (Win32Exception e2) {
                            if (we == null) {
                                we = e2;
                                break block13;
                            }
                            we.addSuppressed((Throwable)e2);
                        }
                    }
                    if (we != null) {
                        throw we;
                    }
                    throw throwable;
                }
            }
            try {
                Kernel32Util.closeHandle((WinNT.HANDLE)hProcess);
            }
            catch (Win32Exception e) {
                if (we == null) {
                    we = e;
                }
                we.addSuppressed((Throwable)e);
            }
            if (we != null) {
                throw we;
            }
            return string;
        }
    }

    private static abstract class PsapiUtil {
        private PsapiUtil() {
        }

        public static int[] enumProcesses() {
            int size = 0;
            int[] lpidProcess = null;
            IntByReference lpcbNeeded = new IntByReference();
            do {
                if (Psapi.INSTANCE.EnumProcesses(lpidProcess = new int[size += 1024], size * 4, lpcbNeeded)) continue;
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            } while (size == lpcbNeeded.getValue() / 4);
            return Arrays.copyOf(lpidProcess, lpcbNeeded.getValue() / 4);
        }

        public static interface Psapi
        extends com.sun.jna.platform.win32.Psapi {
            public static final Psapi INSTANCE = (Psapi)Native.loadLibrary((String)"psapi", Psapi.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

            public boolean EnumProcesses(int[] var1, int var2, IntByReference var3);
        }
    }
}

