/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CPartnerActivityValidator;

public class InvokeValidator
extends CPartnerActivityValidator {
    INode fPartnerRoleNode;
    INode fInputVariableNode;
    INode fOutputVariableNode;
    INode fPortTypeFromRoleNode;
    List<INode> fToPartsParts;
    List<INode> fFromParts;
    String fInputVariableName;
    String fOutputVariableName;
    INode fOutputMessageType;
    INode fInputMessageType;
    protected boolean fbIs2Way;

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_CATCH, 0, Integer.MAX_VALUE);
        this.checkChild(ND_CATCH_ALL, 0, 1);
        this.checkChild(ND_COMPENSATION_HANDLER, 0, 1);
        this.checkChild(ND_TO_PARTS, 0, 1);
        this.checkChild(ND_FROM_PARTS, 0, 1);
    }

    @Override
    protected void start() {
        super.start();
        this.fInputVariableName = this.getAttribute(this.mNode, AT_INPUT_VARIABLE, 1, Filters.NC_NAME, false);
        if (!InvokeValidator.isEmpty(this.fInputVariableName)) {
            this.fInputVariableNode = this.mModelQuery.lookup(this.mNode, 1, this.fInputVariableName);
        }
        this.fOutputVariableName = this.getAttribute(this.mNode, AT_OUTPUT_VARIABLE, 1, Filters.NC_NAME, false);
        if (!InvokeValidator.isEmpty(this.fOutputVariableName)) {
            this.fOutputVariableNode = this.mModelQuery.lookup(this.mNode, 1, this.fOutputVariableName);
        }
        this.fPartnerLinkType = null;
        this.fPartnerRoleNode = null;
    }

    @ARule(sa=2003, desc="Check if inputVariable is set and exists and is defined correctly.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckInputVariable_3() {
        this.fInputVariableNode = this.verifyVariable(this.fInputVariableNode, AT_INPUT_VARIABLE);
    }

    @ARule(sa=2004, desc="Check if outputVariable is set and exists and is defined correctly.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckOutputVariable_3() {
        this.fOutputVariableNode = this.verifyVariable(this.fOutputVariableNode, AT_OUTPUT_VARIABLE);
    }

    @ARule(sa=51, desc="Check to see if toPart is specified; if so then  inputVariable must not be used on the reply.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__PA_PARTS")
    public void rule_checkToPartsPresence_10() {
        this.fToPartsParts = mSelector.selectNodes(this.mNode, ND_TO_PARTS, ND_TO_PART);
        if (this.fToPartsParts.size() > 0 && !InvokeValidator.isEmpty(this.fInputVariableName)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__PA_PARTS", this.toString(this.mNode.nodeName()), ND_TO_PART, AT_INPUT_VARIABLE, 1);
        }
    }

    @ARule(sa=52, desc="Check to see if fromPart is specified; if so then  outputVariable must not be used on invoke.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__PA_PARTS")
    public void rule_checkFromPartsPresence_11() {
        this.fFromParts = mSelector.selectNodes(this.mNode, ND_FROM_PARTS, ND_FROM_PART);
        if (this.fFromParts.size() > 0 && !InvokeValidator.isEmpty(this.fOutputVariableName)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__PA_PARTS", this.toString(this.mNode.nodeName()), ND_FROM_PART, AT_OUTPUT_VARIABLE, 1);
            return;
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks if partner role is defined in invoke activity.", errors="BPELC_MISSING_ROLE")
    public void rule_CheckIfPartnerRoleIsDefined_5() {
        this.fPartnerRoleNode = this.lookupRoleNode(this.fPartnerLinkNode, AT_PARTNER_ROLE);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks portType and derived portType values on invoke activity.", sa=5, errors="BPELC_MISMATCH_ROLE_PORT_TYPE")
    public void rule_CheckRolePortTypeWithInvokePortType_10() {
        this.fPortTypeFromRoleNode = this.verifyPortTypeFromRole(this.fPartnerRoleNode, AT_PARTNER_ROLE, this.fPortType);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks if input and output messages are defined for invoke activity.", errors="BPELC_PA__NO_MESSAGE,BPELC_PA__MSG_TYPE")
    public void rule_CheckInputOutputMessages_12() {
        this.fInputMessageType = this.findMessageType(this.fPortTypeFromRoleNode, this.fOperation, WSDL_ND_INPUT, true);
        this.setValue("input.message.type", this.fInputMessageType);
        this.fOutputMessageType = this.findMessageType(this.fPortTypeFromRoleNode, this.fOperation, WSDL_ND_OUTPUT, false);
        this.setValue("output.message.type", this.fOutputMessageType);
    }

    @ARule(sa=47, desc="One invocation requires inputVariable (or toPart);  2-way invocation requires outputVariable (or fromPart)", author="michal.chmielewski@oracle.com", date="02/22/2007", errors="BPELC_PA__OMIT,BPELC__UNSET_ATTRIBUTE,")
    public void rule_CheckTwoWayInvocation_25() {
        IProblem problem;
        boolean is2Way = this.isDefined(this.fInputMessageType) && this.isDefined(this.fOutputMessageType);
        this.setValue("2way", is2Way);
        if (this.isUndefined(this.fPartnerLinkNode)) {
            return;
        }
        if (this.isUndefined(this.fInputMessageType)) {
            if (this.fToPartsParts.size() > 0) {
                problem = this.createError();
                problem.fill("BPELC_PA__OMIT", this.toString(this.mNode.nodeName()), this.fPartnerLinkNode.getAttribute(AT_NAME), WSDL_ND_INPUT, 0, ND_TO_PART);
            }
        } else if (InvokeValidator.isEmpty(this.fInputVariableName) && this.fToPartsParts.size() == 0) {
            problem = this.createError();
            problem.fill("BPELC__UNSET_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_INPUT_VARIABLE, 1);
        }
        if (this.isUndefined(this.fOutputMessageType)) {
            if (this.isDefined(this.fOutputVariableNode)) {
                problem = this.createError();
                problem.fill("BPELC_PA__OMIT", this.toString(this.mNode.nodeName()), this.fPartnerLinkNode.getAttribute(AT_NAME), WSDL_ND_OUTPUT, 2, AT_OUTPUT_VARIABLE);
            }
            if (this.fFromParts.size() > 0) {
                problem = this.createError();
                problem.fill("BPELC_PA__OMIT", this.toString(this.mNode.nodeName()), this.fPartnerLinkNode.getAttribute(AT_NAME), WSDL_ND_OUTPUT, 0, ND_FROM_PART);
            }
        } else if (InvokeValidator.isEmpty(this.fOutputVariableName) && this.fFromParts.size() == 0) {
            problem = this.createError();
            problem.fill("BPELC__UNSET_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_OUTPUT_VARIABLE, 1);
        }
    }

    @ARule(sa=48, desc="Check message type compatability on invoke", author="michal.chmielewski@oracle.com", date="02/22/2007", errors="BPELC_PA__MESSAGE_TYPE_MISMATCH")
    public void rule_CheckVariableAndMessageStructureCompatibility_40() {
        IProblem problem;
        INode varType;
        if (this.isDefined(this.fInputMessageType) && this.isDefined(this.fInputVariableNode) && this.isDefined(varType = (INode)this.getValue(this.fInputVariableNode, "type", null)) && !this.mModelQuery.check(3, varType, this.fInputMessageType)) {
            problem = this.createError();
            problem.fill("BPELC_PA__MESSAGE_TYPE_MISMATCH", this.toString(this.mNode.nodeName()), AT_INPUT_VARIABLE, this.fInputVariableNode.getAttribute(AT_NAME), this.fInputMessageType, varType);
        }
        if (this.isDefined(this.fOutputMessageType) && this.isDefined(this.fOutputVariableNode) && this.isDefined(varType = (INode)this.getValue(this.fOutputVariableNode, "type", null)) && !this.mModelQuery.check(3, varType, this.fOutputMessageType)) {
            problem = this.createError();
            problem.fill("BPELC_PA__MESSAGE_TYPE_MISMATCH", this.toString(this.mNode.nodeName()), AT_OUTPUT_VARIABLE, this.fOutputVariableNode.getAttribute(AT_NAME), this.fOutputMessageType, varType);
        }
    }
}

