/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.internal.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.xwt.internal.core.Core;
import org.eclipse.xwt.internal.xml.Attribute;
import org.eclipse.xwt.internal.xml.DocumentObject;

public class Element
extends DocumentObject {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String path;
    private Map<String, Attribute> originalAttributes;
    private Map<String, Map<String, Attribute>> externalAttributes;
    private String[] xmlnsMapping;

    public String getPath() {
        return this.path;
    }

    public String getXmlns(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.xmlnsMapping != null) {
            int i = 0;
            while (i < this.xmlnsMapping.length) {
                if (prefix.equals(this.xmlnsMapping[i++])) {
                    return this.xmlnsMapping[i];
                }
                ++i;
            }
        }
        return null;
    }

    public Element(String namespace, String name, Map<String, String> xmlnsMapping) {
        this(namespace, name, null, null, xmlnsMapping);
    }

    public Element(String namespace, String name, String path, Collection<Attribute> attributes, Map<String, String> xmlnsMapping) {
        super(namespace, name);
        this.path = path;
        if (xmlnsMapping != null) {
            this.xmlnsMapping = new String[xmlnsMapping.size() * 2];
            int i = 0;
            for (Map.Entry<String, String> entry : xmlnsMapping.entrySet()) {
                String key = entry.getKey();
                if (key == null) {
                    key = "";
                }
                this.xmlnsMapping[i++] = key;
                this.xmlnsMapping[i++] = entry.getValue();
            }
        }
        this.originalAttributes = Collections.EMPTY_MAP;
        this.externalAttributes = Collections.EMPTY_MAP;
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                this.setInternalAttribute(attribute);
            }
        }
    }

    public String[] attributeNames() {
        return this.originalAttributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String[] attributeNamespaces() {
        return this.externalAttributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public void setAttribute(Attribute attribute) {
        this.setInternalAttribute(attribute);
        this.firePropertyChanged(attribute);
    }

    public String[] attributeNames(String namespace) {
        if (this.getNamespace().equals(namespace)) {
            return this.attributeNames();
        }
        Map<String, Attribute> externalAttribute = this.externalAttributes.get(namespace);
        if (externalAttribute != null) {
            return externalAttribute.keySet().toArray(EMPTY_STRING_ARRAY);
        }
        return Core.EMPTY_STRING_ARRAY;
    }

    public Attribute getAttribute(String name) {
        assert (name != null);
        return this.originalAttributes.get(name);
    }

    public Attribute getAttribute(String namespace, String name) {
        Map<String, Attribute> externalAttribute = this.externalAttributes.get(namespace);
        if (externalAttribute != null) {
            return externalAttribute.get(name);
        }
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Element element = (Element)super.clone();
        element.parent = null;
        if (this.originalAttributes.isEmpty()) {
            this.originalAttributes = Collections.EMPTY_MAP;
        } else {
            element.originalAttributes = new LinkedHashMap<String, Attribute>(this.originalAttributes.size());
            for (String attrName : this.originalAttributes.keySet()) {
                Attribute attrValue = (Attribute)this.originalAttributes.get(attrName).clone();
                element.originalAttributes.put(attrName, attrValue);
            }
        }
        if (this.externalAttributes.isEmpty()) {
            element.originalAttributes = Collections.EMPTY_MAP;
        } else {
            element.externalAttributes = new LinkedHashMap<String, Map<String, Attribute>>(this.externalAttributes.size());
            for (String ns : this.externalAttributes.keySet()) {
                Map<String, Attribute> oAttributes = this.externalAttributes.get(ns);
                LinkedHashMap<String, Attribute> nAttributes = new LinkedHashMap<String, Attribute>(oAttributes.size());
                for (Map.Entry<String, Attribute> entry : oAttributes.entrySet()) {
                    String attrName = entry.getKey();
                    Attribute attrValue = (Attribute)entry.getValue().clone();
                    nAttributes.put(attrName, attrValue);
                }
                element.externalAttributes.put(ns, nAttributes);
            }
        }
        return element;
    }

    protected void setAttributes(Collection<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.setInternalAttribute(attribute);
        }
        this.firePropertyChanged(attributes);
    }

    private void firePropertyChanged(Attribute attribute) {
        this.notifyObservers(attribute);
    }

    private void firePropertyChanged(Collection<Attribute> attributes) {
        this.notifyObservers(attributes);
    }

    private boolean isXWTNamespace(String namespace) {
        String scopeNamespace = this.getNamespace();
        if (namespace == null || "".equals(namespace)) {
            return true;
        }
        if (scopeNamespace.startsWith("clr-namespace:") || scopeNamespace.equals("http://www.eclipse.org/xwt/presentation")) {
            return namespace.equalsIgnoreCase(scopeNamespace) || namespace.equals("http://www.eclipse.org/xwt/presentation");
        }
        return false;
    }

    private void setInternalAttribute(Attribute attribute) {
        assert (attribute != null);
        String namespace = attribute.getNamespace();
        String name = attribute.getName();
        if (this.isXWTNamespace(namespace)) {
            if (this.originalAttributes == Collections.EMPTY_MAP) {
                this.originalAttributes = new LinkedHashMap<String, Attribute>();
            }
            this.originalAttributes.put(name, attribute);
        } else {
            Map<String, Attribute> externalAttribute = this.externalAttributes.get(namespace);
            if (externalAttribute == null) {
                externalAttribute = new HashMap<String, Attribute>();
            }
            if (this.externalAttributes == Collections.EMPTY_MAP) {
                this.externalAttributes = new LinkedHashMap<String, Map<String, Attribute>>();
            }
            externalAttribute.put(name, attribute);
            this.externalAttributes.put(namespace, externalAttribute);
        }
        attribute.setParent(this);
    }
}

