/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.editor.quickfix;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.formatting.ILineSeparatorInformation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.services.XtextGrammarAccess;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.Fixes;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.util.internal.Nullable;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xtext.RuleWithoutInstantiationInspector;

public class XtextGrammarQuickfixProvider
extends DefaultQuickfixProvider {
    private static final String GRAMMAR_LANG_DOC = "https://www.eclipse.org/Xtext/documentation/301_grammarlanguage.html";
    private String NULL_QUICKFIX_IMAGE = null;
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject(optional=true)
    @Nullable
    private IWorkbench workbench;
    @Inject
    private ILineSeparatorInformation separatorInfo;
    @Inject
    private XtextGrammarAccess grammarAccess;

    @Fix(value="org.eclipse.xtext.grammar.UnresolvedRule")
    public void fixUnresolvedRule(Issue issue, IssueResolutionAcceptor acceptor) {
        String ruleName = issue.getData()[0];
        acceptor.accept(issue, "Create rule '" + ruleName + "'", "Create rule '" + ruleName + "'", this.NULL_QUICKFIX_IMAGE, this.createNewRule(ruleName, null));
    }

    @Fix(value="org.eclipse.xtext.grammar.UnresolvedRule")
    public void fixUnresolvedEnumRule(Issue issue, IssueResolutionAcceptor acceptor) {
        String ruleName = issue.getData()[0];
        String ruleType = "enum ";
        acceptor.accept(issue, "Create enum rule '" + ruleName + "'", "Create enum rule '" + ruleName + "'", this.NULL_QUICKFIX_IMAGE, this.createNewRule(ruleName, ruleType));
    }

    @Fixes(value={@Fix(value="org.eclipse.xtext.grammar.UnresolvedRule"), @Fix(value="org.eclipse.xtext.grammar.UnresolvedTerminalRule")})
    public void fixUnresolvedTerminalRule(Issue issue, IssueResolutionAcceptor acceptor) {
        String ruleName = issue.getData()[0];
        String ruleType = "terminal ";
        acceptor.accept(issue, "Create terminal '" + ruleName + "'", "Create terminal '" + ruleName + "'", this.NULL_QUICKFIX_IMAGE, this.createNewRule(ruleName, ruleType));
    }

    @Fixes(value={@Fix(value="org.eclipse.xtext.grammar.UnresolvedRule"), @Fix(value="org.eclipse.xtext.grammar.UnresolvedTerminalRule")})
    public void fixUnresolvedTerminalFragmentRule(Issue issue, IssueResolutionAcceptor acceptor) {
        String ruleName = issue.getData()[0];
        String ruleType = "terminal fragment ";
        acceptor.accept(issue, "Create terminal fragment '" + ruleName + "'", "Create terminal fragment '" + ruleName + "'", this.NULL_QUICKFIX_IMAGE, this.createNewRule(ruleName, ruleType));
    }

    @Fixes(value={@Fix(value="org.eclipse.xtext.grammar.UnresolvedRule"), @Fix(value="org.eclipse.xtext.grammar.UnresolvedTerminalRule")})
    public void createChangeToIssueResolution(Issue issue, IssueResolutionAcceptor acceptor) {
        this.createLinkingIssueResolutions(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.grammar.InvalidMetaModelName")
    public void fixInvalidMetaModelName(final Issue issue, IssueResolutionAcceptor acceptor) {
        final String metaModelName = issue.getData()[0];
        acceptor.accept(issue, "Fix metamodel name '" + metaModelName + "'", "Fix metamodel name '" + metaModelName + "'", this.NULL_QUICKFIX_IMAGE, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), Strings.toFirstLower((String)metaModelName));
            }
        });
    }

    @Fix(value="org.eclipse.xtext.grammar.EmptyEnumLiteral")
    public void fixEmptyEnumLiteral(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, "Fix empty enum literal", "Fix empty enum literal", this.NULL_QUICKFIX_IMAGE, element -> {
            EnumLiteralDeclaration enumLiteralDeclaration = (EnumLiteralDeclaration)element;
            Keyword keyword = XtextFactory.eINSTANCE.createKeyword();
            keyword.setValue(enumLiteralDeclaration.getEnumLiteral().getName().toLowerCase());
            enumLiteralDeclaration.setLiteral(keyword);
        });
    }

    @Fix(value="org.eclipse.xtext.grammar.EmptyKeyword")
    public void removeEmptyKeyword(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove empty keyword", "Remove empty keyword", this.NULL_QUICKFIX_IMAGE, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
            }
        });
    }

    @Fix(value="org.eclipse.xtext.grammar.EmptyKeyword")
    public void replaceEmptyKeywordWithRuleName(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Replace empty keyword with rule name", "Replace empty keyword with rule name", this.NULL_QUICKFIX_IMAGE, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IXtextDocument document = context.getXtextDocument();
                String containingRuleName = (String)document.tryPriorityReadOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

                    public String exec(XtextResource state) throws Exception {
                        return Optional.ofNullable(issue.getUriToProblem().fragment()).map(arg_0 -> ((XtextResource)state).getEObject(arg_0)).map(GrammarUtil::containingRule).map(AbstractRule::getName).map(Strings::toFirstLower).orElse(null);
                    }
                });
                if (containingRuleName != null) {
                    String quote = String.valueOf(document.getChar(issue.getOffset().intValue()));
                    document.replace(issue.getOffset().intValue(), issue.getLength().intValue(), String.valueOf(quote) + containingRuleName + quote);
                }
            }
        });
    }

    @Fix(value="org.eclipse.xtext.grammar.SpacesInKeyword")
    public void fixKeywordNoSpaces(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Fix keyword with spaces", "Fix keyword with spaces", this.NULL_QUICKFIX_IMAGE, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                int offset = issue.getOffset();
                int length = issue.getLength();
                IXtextDocument document = context.getXtextDocument();
                String quote = String.valueOf(document.getChar(offset));
                String identifiers = document.get(offset, length).replaceAll("'|\"", "").trim();
                if (!Strings.isEmpty((String)identifiers)) {
                    document.replace(offset, length, String.valueOf(quote) + Joiner.on((String)(String.valueOf(quote) + " " + quote)).join((Object[])identifiers.split("\\s+")) + quote);
                } else {
                    String containingRuleName = (String)document.tryPriorityReadOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

                        public String exec(XtextResource state) throws Exception {
                            return Optional.ofNullable(issue.getUriToProblem().fragment()).map(arg_0 -> ((XtextResource)state).getEObject(arg_0)).map(GrammarUtil::containingRule).map(AbstractRule::getName).map(Strings::toFirstLower).orElse(null);
                        }
                    });
                    if (containingRuleName != null) {
                        document.replace(offset, length, String.valueOf(quote) + containingRuleName + quote);
                    }
                }
            }
        });
    }

    @Fix(value="org.eclipse.xtext.grammar.InvalidActionUsage")
    public void fixInvalidActionUsage(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Fix invalid action usage", "Fix invalid action usage", this.NULL_QUICKFIX_IMAGE, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
            }
        });
    }

    @Fix(value="org.eclipse.xtext.grammar.InvalidPackageReference.inherited")
    public void fixImportedPackageFromSuperGrammar(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData().length == 1) {
            acceptor.accept(issue, "Change to '" + issue.getData()[0] + "'", "Fix the bogus package import\nimport '" + issue.getData()[0] + "'", this.NULL_QUICKFIX_IMAGE, new IModification(){

                public void apply(IModificationContext context) throws BadLocationException {
                    IXtextDocument document;
                    String delimiter;
                    String replaceString = XtextGrammarQuickfixProvider.this.valueConverterService.toString((Object)issue.getData()[0], "STRING");
                    if (!replaceString.startsWith(delimiter = (document = context.getXtextDocument()).get(issue.getOffset().intValue(), 1))) {
                        replaceString = String.valueOf(delimiter) + replaceString.substring(1, replaceString.length() - 1) + delimiter;
                    }
                    document.replace(issue.getOffset().intValue(), issue.getLength().intValue(), replaceString);
                }
            });
        }
    }

    @Fix(value="org.eclipse.xtext.grammar.InvalidPackageReference.external")
    public void fixExternalImportedPackage(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData().length == 1) {
            acceptor.accept(issue, "Update the imported package '" + issue.getData()[0] + "'", "Fix the bogus package import\nimport '" + issue.getData()[0] + "'", this.NULL_QUICKFIX_IMAGE, new IModification(){

                public void apply(IModificationContext context) throws BadLocationException {
                    String replaceString = XtextGrammarQuickfixProvider.this.valueConverterService.toString((Object)issue.getData()[0], "STRING");
                    IXtextDocument document = context.getXtextDocument();
                    List importedPackages = (List)document.priorityReadOnly((IUnitOfWork)new IUnitOfWork<List<String>, XtextResource>(){

                        public List<String> exec(XtextResource state) throws Exception {
                            HashMap uriMap;
                            ResourceSet resourceSet;
                            IResourceDescriptions descriptions = XtextGrammarQuickfixProvider.this.resourceDescriptionsProvider.getResourceDescriptions((Resource)state);
                            EPackage ePackage = this.loadPackageFromIndex(descriptions, resourceSet = state.getResourceSet(), uriMap = Maps.newHashMap(), issue.getData()[0]);
                            if (ePackage != null) {
                                final HashMap packagePerNsURI = Maps.newHashMap();
                                packagePerNsURI.put(ePackage.getNsURI(), ePackage);
                                final Set<URI> updatedReferences = this.fixReferencesInPackages(ePackage, packagePerNsURI, uriMap, descriptions, resourceSet);
                                if (updatedReferences.isEmpty()) {
                                    return null;
                                }
                                Iterator iterator = packagePerNsURI.values().iterator();
                                while (iterator.hasNext()) {
                                    EPackage pack = (EPackage)iterator.next();
                                    Resource resource = pack.eResource();
                                    if (resource.getURI().isPlatformResource()) continue;
                                    iterator.remove();
                                }
                                final ArrayList result = Lists.newArrayList();
                                new WorkspaceModifyOperation(){

                                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                        try {
                                            for (EPackage pack : packagePerNsURI.values()) {
                                                Resource resource = pack.eResource();
                                                resource.save(Collections.singletonMap("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware(){

                                                    public URI deresolve(URI uri) {
                                                        if (!uri.isArchive() || !updatedReferences.contains(uri)) {
                                                            return super.deresolve(uri);
                                                        }
                                                        URI withoutFragment = uri.trimFragment();
                                                        if (uriMap.containsKey(withoutFragment)) {
                                                            withoutFragment = (URI)uriMap.get(withoutFragment);
                                                        }
                                                        return super.deresolve(withoutFragment.appendFragment(uri.fragment()));
                                                    }
                                                }));
                                                result.add(resource.getURI().toString());
                                            }
                                        }
                                        catch (IOException ioe) {
                                            throw new InvocationTargetException(ioe);
                                        }
                                    }
                                }.run((IProgressMonitor)new NullProgressMonitor());
                                int i = resourceSet.getResources().size() - 1;
                                while (i >= 0) {
                                    Resource resource = (Resource)resourceSet.getResources().get(i);
                                    if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof GenModel) {
                                        resourceSet.getResources().remove(i);
                                    }
                                    --i;
                                }
                                return result;
                            }
                            return null;
                        }

                        private Set<URI> fixReferencesInPackages(EPackage ePackage, Map<String, EPackage> packagePerNsURI, Map<URI, URI> uriMap, IResourceDescriptions descriptions, ResourceSet resourceSet) {
                            HashSet result = Sets.newHashSet();
                            Map allReferences = EcoreUtil.CrossReferencer.find(Collections.singletonList(ePackage));
                            for (final EStructuralFeature.Setting setting : Iterables.concat(allReferences.values())) {
                                List<Object> casted;
                                if (!setting.getEStructuralFeature().isChangeable()) continue;
                                final Object referenced = setting.get(true);
                                List<Object> references = null;
                                references = referenced instanceof EObject ? new AbstractList<Object>(){

                                    @Override
                                    public Object set(int index, Object element) {
                                        setting.set(element);
                                        return referenced;
                                    }

                                    @Override
                                    public Object get(int index) {
                                        return referenced;
                                    }

                                    @Override
                                    public int size() {
                                        return 1;
                                    }
                                } : (casted = (List<Object>)referenced);
                                int i = 0;
                                while (i < references.size()) {
                                    EObject referencedEObject;
                                    EPackage transitive;
                                    if (references.get(i) instanceof EObject && this.isRegisteredPackage(transitive = (EPackage)EcoreUtil2.getContainerOfType((EObject)(referencedEObject = (EObject)references.get(i)), EPackage.class)) && !(referencedEObject instanceof EDataType) && referencedEObject != EcorePackage.Literals.EOBJECT) {
                                        EPackage fromWorkspace = packagePerNsURI.get(transitive.getNsURI());
                                        if (fromWorkspace == null && !packagePerNsURI.containsKey(transitive.getNsURI())) {
                                            fromWorkspace = this.loadPackageFromIndex(descriptions, resourceSet, uriMap, transitive.getNsURI());
                                            packagePerNsURI.put(transitive.getNsURI(), fromWorkspace);
                                        }
                                        if (fromWorkspace != null) {
                                            String fragment = transitive.eResource().getURIFragment(referencedEObject);
                                            EObject replacement = fromWorkspace.eResource().getEObject(fragment);
                                            if (replacement != null) {
                                                result.add(EcoreUtil.getURI((EObject)replacement));
                                                references.set(i, replacement);
                                            }
                                        }
                                    }
                                    ++i;
                                }
                            }
                            return result;
                        }

                        private boolean isRegisteredPackage(EPackage ePackage) {
                            return ePackage != null && (ePackage.eResource() == null || ePackage.getNsURI().equals(ePackage.eResource().getURI().toString()));
                        }

                        private EPackage loadPackageFromIndex(IResourceDescriptions descriptions, ResourceSet resourceSet, Map<URI, URI> uriMap, String nsURI) {
                            Iterable fixUs = descriptions.getExportedObjects(EcorePackage.Literals.EPACKAGE, QualifiedName.create((String)nsURI), false);
                            for (IEObjectDescription description : fixUs) {
                                EObject result;
                                if (!description.getEObjectURI().isPlatformResource() || !((result = resourceSet.getEObject(description.getEObjectURI(), true)) instanceof EPackage)) continue;
                                return (EPackage)result;
                            }
                            URI genModelURI = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false).get(nsURI);
                            if (genModelURI != null) {
                                Resource genmodelResource = resourceSet.getResource(genModelURI, true);
                                GenModel genModel = (GenModel)genmodelResource.getContents().get(0);
                                for (GenPackage genPackage : genModel.getGenPackages()) {
                                    Object object = genPackage.eGet((EStructuralFeature)GenModelPackage.Literals.GEN_PACKAGE__ECORE_PACKAGE, false);
                                    if (!(object instanceof EObject)) continue;
                                    EObject proxy = (EObject)object;
                                    URI proxyURI = EcoreUtil.getURI((EObject)proxy);
                                    URI resolvedProxyURI = proxyURI.resolve(genModelURI);
                                    if (!nsURI.equals(genPackage.getEcorePackage().getNsURI())) continue;
                                    EPackage result = genPackage.getEcorePackage();
                                    uriMap.put(result.eResource().getURI(), resolvedProxyURI.trimFragment());
                                    return result;
                                }
                            }
                            return null;
                        }
                    });
                    String delimiter = document.get(issue.getOffset().intValue(), 1);
                    if (!replaceString.startsWith(delimiter)) {
                        replaceString = String.valueOf(delimiter) + replaceString.substring(1, replaceString.length() - 1) + delimiter;
                    }
                    document.replace(issue.getOffset().intValue(), issue.getLength().intValue(), replaceString);
                    if (importedPackages != null && !importedPackages.isEmpty()) {
                        final Shell shell = XtextGrammarQuickfixProvider.this.workbench.getActiveWorkbenchWindow().getShell();
                        shell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                String title = "Please update the Ecore2XtextDslProjectContributor that generates the language.";
                                String message = "Please make sure that the Ecore2XtextDslProjectContributor that generates the language is up-to date.\nEspecially important is the registration of the referenced packages.\nPlease refer to the reference documentation for details.";
                                MessageDialog dialog = new MessageDialog(shell, title, null, message, 2, new String[]{"Open Documentation", "Close"}, 1);
                                if (dialog.open() == 0) {
                                    try {
                                        XtextGrammarQuickfixProvider.this.workbench.getBrowserSupport().getExternalBrowser().openURL(new URL(XtextGrammarQuickfixProvider.GRAMMAR_LANG_DOC));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    @Fix(value="org.eclipse.xtext.grammar.InvalidTerminalRuleName")
    public void fixTerminalRuleName(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData().length == 1) {
            final String upperCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, issue.getData()[0]).toString();
            acceptor.accept(issue, "Change name to " + upperCase, "Change name to " + upperCase, "upcase.png", new IModification(){

                public void apply(IModificationContext context) throws Exception {
                    final IXtextDocument xtextDocument = context.getXtextDocument();
                    xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), upperCase);
                    xtextDocument.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                        public void process(XtextResource state) throws Exception {
                            final EObject terminalRule = state.getEObject(issue.getUriToProblem().fragment());
                            Iterable candidates = Iterables.filter((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Iterator)state.getAllContents()), RuleCall.class), (Predicate)new Predicate<RuleCall>(){

                                public boolean apply(RuleCall ruleCall) {
                                    return ruleCall.getRule() == terminalRule;
                                }
                            });
                            for (RuleCall ruleCall : candidates) {
                                List nodes = NodeModelUtils.findNodesForFeature((EObject)ruleCall, (EStructuralFeature)XtextPackage.eINSTANCE.getRuleCall_Rule());
                                for (INode node : nodes) {
                                    ITextRegion textRegion = node.getTextRegion();
                                    xtextDocument.replace(textRegion.getOffset(), textRegion.getLength(), upperCase);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    @Fix(value="org.eclipse.xtext.grammar.ExplicitOverrideMissing")
    public void addOverrideTag(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add missing @Override annotation", "Inserts the missing @Override annotation.", null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                final URI uri = issue.getUriToProblem();
                IXtextDocument document = context.getXtextDocument(uri);
                if (document == null) {
                    return;
                }
                Integer offset = (Integer)document.tryReadOnly((IUnitOfWork)new IUnitOfWork<Integer, XtextResource>(){

                    public Integer exec(XtextResource state) throws Exception {
                        EObject eObject = state.getEObject(uri.fragment());
                        if (eObject == null) {
                            return null;
                        }
                        return NodeModelUtils.findActualNodeFor((EObject)eObject).getOffset();
                    }
                });
                if (offset != null) {
                    document.replace(offset.intValue(), 0, "@Override " + XtextGrammarQuickfixProvider.this.separatorInfo.getLineSeparator());
                }
            }
        });
    }

    @Fix(value="RuleWithoutInstantiationInspector.noInstantiation")
    public void addAction(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add actions to ensure object creation", "Inserts the missing actions to ensure object creation.", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ParserRule rule = (ParserRule)element;
                MultiTextEdit textEdit = new MultiTextEdit();
                this.applyToNode(rule.getAlternatives(), "{" + this.calculateActionName(rule) + "} ", textEdit);
                textEdit.apply((IDocument)context.getXtextDocument());
            }

            private String calculateActionName(ParserRule rule) {
                String actionName = rule.getName();
                TypeRef type = rule.getType();
                EClassifier classifier = type.getClassifier();
                if (classifier != null) {
                    AbstractMetamodelDeclaration metamodel = type.getMetamodel();
                    String alias = metamodel.getAlias();
                    actionName = String.valueOf(alias == null ? "" : String.valueOf(alias) + "::") + classifier.getName();
                }
                return actionName;
            }

            private void applyToNode(AbstractElement node, String actionText, MultiTextEdit textEdit) throws BadLocationException {
                Boolean isInstantiated = (Boolean)new RuleWithoutInstantiationInspector(null).doSwitch((EObject)node);
                if (isInstantiated == null || isInstantiated.booleanValue()) {
                    return;
                }
                if (node instanceof Alternatives) {
                    Alternatives alternatives = (Alternatives)node;
                    for (AbstractElement alternativeChild : alternatives.getElements()) {
                        this.applyToNode(alternativeChild, actionText, textEdit);
                    }
                } else {
                    int offset = NodeModelUtils.findActualNodeFor((EObject)node).getOffset();
                    textEdit.addChild((TextEdit)new InsertEdit(offset, actionText));
                }
            }
        });
    }

    @Fixes(value={@Fix(value="org.eclipse.xtext.grammar.InvalidHiddenTokenFragment"), @Fix(value="org.eclipse.xtext.grammar.InvalidTerminalFragmentRuleReference")})
    public void fixConvertTerminalFragmentToTerminalRule(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Convert terminal fragment to terminal rule", "Convert terminal fragment to terminal rule", this.NULL_QUICKFIX_IMAGE, context -> {
            final IXtextDocument xtextDocument = context.getXtextDocument();
            xtextDocument.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    if (state == null) {
                        return;
                    }
                    EObject eObject = state.getEObject(issue.getUriToProblem().fragment());
                    AbstractRule rule = null;
                    if (eObject instanceof Grammar) {
                        rule = (AbstractRule)((Grammar)eObject).getHiddenTokens().get(Integer.valueOf(issue.getData()[0]).intValue());
                    } else if (eObject instanceof ParserRule) {
                        rule = (AbstractRule)((ParserRule)eObject).getHiddenTokens().get(Integer.valueOf(issue.getData()[0]).intValue());
                    } else if (eObject instanceof RuleCall) {
                        RuleCall ruleCall = (RuleCall)state.getEObject(issue.getUriToProblem().fragment());
                        rule = ruleCall.getRule();
                    }
                    if (rule != null) {
                        ICompositeNode ruleNode = NodeModelUtils.findActualNodeFor(rule);
                        for (INode node : ruleNode.getAsTreeIterable()) {
                            if (node.getGrammarElement() == null || node.getGrammarElement() != XtextGrammarQuickfixProvider.this.grammarAccess.getTerminalRuleAccess().getFragmentFragmentKeyword_2_0_0_0()) continue;
                            ITextRegion fragmentRegion = node.getTextRegion();
                            ICompositeNode compositeNode = (ICompositeNode)node.getNextSibling();
                            if (compositeNode.getFirstChild().getGrammarElement() == XtextGrammarQuickfixProvider.this.grammarAccess.getWSRule()) {
                                xtextDocument.replace(fragmentRegion.getOffset(), fragmentRegion.getLength() + 1, "");
                                break;
                            }
                            xtextDocument.replace(fragmentRegion.getOffset(), fragmentRegion.getLength(), "");
                            break;
                        }
                    }
                }
            });
        });
    }

    @Fixes(value={@Fix(value="org.eclipse.xtext.grammar.InvalidHiddenTokenFragment"), @Fix(value="org.eclipse.xtext.grammar.InvalidHiddenToken")})
    public void fixInvalidHiddenToken(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove hidden token definition", "Remove hidden token definition", this.NULL_QUICKFIX_IMAGE, (element, context) -> {
            if (element instanceof Grammar) {
                Grammar grammar = (Grammar)element;
                if (issue.getData().length > 0) {
                    grammar.getHiddenTokens().remove(Integer.valueOf(issue.getData()[0]).intValue());
                }
            } else {
                ParserRule parserRule = (ParserRule)element;
                if (issue.getData().length > 0) {
                    parserRule.getHiddenTokens().remove(Integer.valueOf(issue.getData()[0]).intValue());
                }
            }
        });
    }

    private ISemanticModification createNewRule(String ruleName, String ruleType) {
        return (element, context) -> {
            AbstractRule abstractRule = (AbstractRule)EcoreUtil2.getContainerOfType((EObject)element, AbstractRule.class);
            ICompositeNode node = NodeModelUtils.getNode((EObject)abstractRule);
            String nl = context.getXtextDocument().getLineDelimiter(0);
            StringBuilder builder = new StringBuilder(String.valueOf(nl) + nl);
            if (ruleType != null) {
                builder.append(ruleType);
            }
            String newRule = builder.append(ruleName).append(":" + nl + "\t" + nl + ";").toString();
            context.getXtextDocument().replace(node.getEndOffset(), 0, newRule);
        };
    }
}

