/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.embedder.node;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.dump.UnsupportedCompressionAlgorithmException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class CompressUtils {
    public static final String ZIP_EXTENSION = ".zip";
    public static final String TAR_GZ_EXTENSION = ".tar.gz";
    public static final String TAR_XZ_EXTENSION = ".tar.xz";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unarchive(URL find, File baseDir) throws IOException {
        String archive;
        String string = archive = find != null ? find.getFile() : "";
        if (archive.endsWith(TAR_GZ_EXTENSION) || archive.endsWith(TAR_XZ_EXTENSION)) {
            Throwable throwable = null;
            Object var4_7 = null;
            try {
                InputStream fi = find.openStream();
                try {
                    block37: {
                        BufferedInputStream bi = new BufferedInputStream(fi);
                        try {
                            block36: {
                                XZCompressorInputStream gzi = archive.endsWith(TAR_XZ_EXTENSION) ? new XZCompressorInputStream((InputStream)bi) : new GzipCompressorInputStream((InputStream)bi);
                                try {
                                    try (TarArchiveInputStream in = new TarArchiveInputStream((InputStream)gzi);){
                                        CompressUtils.extractArchive((ArchiveInputStream)in, baseDir);
                                    }
                                    if (gzi == null) break block36;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (gzi == null) throw throwable;
                                    gzi.close();
                                    throw throwable;
                                }
                                gzi.close();
                            }
                            if (bi == null) break block37;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (bi == null) throw throwable;
                            ((InputStream)bi).close();
                            throw throwable;
                        }
                        ((InputStream)bi).close();
                    }
                    if (fi == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fi == null) throw throwable;
                    fi.close();
                    throw throwable;
                }
                fi.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        if (!archive.endsWith(ZIP_EXTENSION)) throw new UnsupportedCompressionAlgorithmException("Unsupported archive file extension: " + archive);
        Throwable throwable = null;
        Object var4_12 = null;
        try {
            InputStream fi = find.openStream();
            try {
                try (ZipArchiveInputStream in = new ZipArchiveInputStream(fi);){
                    CompressUtils.extractArchive((ArchiveInputStream)in, baseDir);
                }
                if (fi == null) return;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                if (fi == null) throw throwable;
                fi.close();
                throw throwable;
            }
            fi.close();
            return;
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
                throw throwable;
            }
            if (throwable == throwable7) throw throwable;
            throwable.addSuppressed(throwable7);
            throw throwable;
        }
    }

    public static void extractArchive(ArchiveInputStream in, File destination) throws IOException {
        ArchiveEntry entry = null;
        while ((entry = in.getNextEntry()) != null) {
            if (!in.canReadEntryData(entry)) continue;
            File f = new File(destination, entry.getName());
            if (entry.isDirectory()) {
                if (f.isDirectory() || f.mkdirs()) continue;
                throw new IOException("failed to create directory " + f);
            }
            File parent = f.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("failed to create directory " + parent);
            }
            Throwable throwable = null;
            Object var6_7 = null;
            try (OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)o);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!(entry instanceof TarArchiveEntry)) continue;
            f.setExecutable((((TarArchiveEntry)entry).getMode() & 0x100) != 0);
        }
    }
}

