/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.team.core.diff.DiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSSubscriberMergeContext;
import org.eclipse.team.internal.core.subscribers.ContentComparisonDiffFilter;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;
import org.eclipse.team.internal.ui.synchronize.RegexDiffFilter;

public class CompareSubscriberContext
extends CVSSubscriberMergeContext
implements IEclipsePreferences.IPreferenceChangeListener {
    public static SynchronizationContext createContext(ISynchronizationScopeManager manager, CVSCompareSubscriber subscriber) {
        CompareSubscriberContext mergeContext = new CompareSubscriberContext((Subscriber)subscriber, manager);
        mergeContext.initialize();
        return mergeContext;
    }

    protected CompareSubscriberContext(Subscriber subscriber, ISynchronizationScopeManager manager) {
        super(subscriber, manager);
        ((IEclipsePreferences)CVSUIPlugin.getPlugin().getInstancePreferences().node("")).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        ((IEclipsePreferences)CVSUIPlugin.getPlugin().getInstancePreferences().node("")).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void markAsMerged(IDiff node, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
    }

    protected DiffFilter getDiffFilter() {
        final DiffFilter contentFilter = this.createContentFilter();
        final DiffFilter regexFilter = this.createRegexFilter();
        if (contentFilter != null && regexFilter != null) {
            return new DiffFilter(){

                public boolean select(IDiff diff, IProgressMonitor monitor) {
                    return !contentFilter.select(diff, monitor) && !regexFilter.select(diff, monitor);
                }
            };
        }
        if (contentFilter != null) {
            return new DiffFilter(){

                public boolean select(IDiff diff, IProgressMonitor monitor) {
                    return !contentFilter.select(diff, monitor);
                }
            };
        }
        if (regexFilter != null) {
            return new DiffFilter(){

                public boolean select(IDiff diff, IProgressMonitor monitor) {
                    return !regexFilter.select(diff, monitor);
                }
            };
        }
        return null;
    }

    private boolean isConsiderContents() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_consider_contents");
    }

    private DiffFilter createContentFilter() {
        if (this.isConsiderContents()) {
            return new ContentComparisonDiffFilter(false);
        }
        return null;
    }

    private DiffFilter createRegexFilter() {
        String pattern;
        if (this.isConsiderContents() && (pattern = CVSUIPlugin.getPlugin().getPreferenceStore().getString("pref_syncview_regex_filter_pattern")) != null && !pattern.isEmpty()) {
            return new RegexDiffFilter(pattern);
        }
        return null;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        SubscriberDiffTreeEventHandler handler;
        if ((event.getKey().equals("pref_consider_contents") || event.getKey().equals("pref_syncview_regex_filter_pattern")) && (handler = this.getHandler()) != null) {
            handler.setFilter(this.getDiffFilter());
            handler.reset();
        }
    }
}

