/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.debug.core;

import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.debug.model.StackFrame;
import org.eclipse.rcptt.ecl.debug.model.Variable;
import org.eclipse.rcptt.ecl.internal.debug.core.EclDebugElement;
import org.eclipse.rcptt.ecl.internal.debug.core.EclDebugThread;
import org.eclipse.rcptt.ecl.internal.debug.core.EclVariable;

public class EclStackFrame
extends EclDebugElement
implements IStackFrame {
    private final EclDebugThread thread;
    private final StackFrame frame;
    private final IVariable[] variables;

    public EclStackFrame(EclDebugThread thread, StackFrame frame) {
        this.thread = thread;
        this.frame = frame;
        EList vars = frame.getVariables();
        this.variables = new IVariable[vars.size()];
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i] = new EclVariable(thread, (Variable)vars.get(i));
            ++i;
        }
    }

    public StackFrame getFrame() {
        return this.frame;
    }

    public IDebugTarget getDebugTarget() {
        return this.thread.getDebugTarget();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public int getLineNumber() throws DebugException {
        return this.frame.getLine();
    }

    public int getCharStart() throws DebugException {
        return this.frame.getColumn();
    }

    public int getCharEnd() throws DebugException {
        return this.frame.getLength();
    }

    public String getName() throws DebugException {
        return String.valueOf(this.frame.getCommand()) + " (" + new Path(this.frame.getFile()).removeFileExtension().lastSegment() + ": " + this.frame.getLine() + ")";
    }

    public String getFile() {
        return this.frame.getFile();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.frame == null ? 0 : this.frame.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EclStackFrame other = (EclStackFrame)((Object)obj);
        return !(this.frame == null ? other.frame != null : !this.frame.equals(other.frame));
    }
}

