/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.api.restrictions.PermissionsExaminationService;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.access.SumOfCertificates;
import org.eclipse.passage.lic.internal.base.diagnostic.code.NoServicesOfType;
import org.eclipse.passage.lic.internal.base.i18n.AccessCycleMessages;

public final class Restrictions
implements Supplier<ServiceInvocationResult<ExaminationCertificate>> {
    private final Registry<StringServiceId, PermissionsExaminationService> registry;
    private final Collection<Requirement> requirements;
    private final Collection<Permission> permissions;
    private final LicensedProduct product;

    public Restrictions(Registry<StringServiceId, PermissionsExaminationService> registry, Collection<Requirement> requirements, Collection<Permission> permissions, LicensedProduct product) {
        this.registry = registry;
        this.requirements = requirements;
        this.permissions = permissions;
        this.product = product;
    }

    @Override
    public ServiceInvocationResult<ExaminationCertificate> get() {
        if (this.registry.services().isEmpty()) {
            return new BaseServiceInvocationResult<Trouble>(new Trouble((TroubleCode)new NoServicesOfType(AccessCycleMessages.getString("Restrictions.type")), AccessCycleMessages.getString("Restrictions.no_services")));
        }
        return new BaseServiceInvocationResult<ExaminationCertificate>(this.registry.services().stream().map(service -> service.examine(this.requirements, this.permissions, this.product)).reduce(new SumOfCertificates()));
    }
}

