/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.InternationalizationPackage;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLLabelObservableValue
extends AbstractObservableValue
implements IObserving,
ReferenceCountedObservable {
    private final ReferenceCountedObservable.Support refCount = new ReferenceCountedObservable.Support((IObservable)this);
    protected NamedElement namedElement;
    protected EditingDomain domain;
    protected Adapter listener;
    protected InternationalizationEntry entry;

    public UMLLabelObservableValue(NamedElement namedElement, EditingDomain domain) {
        this(Realm.getDefault(), namedElement, domain);
    }

    public UMLLabelObservableValue(Realm realm, NamedElement namedElement, EditingDomain domain) {
        super(realm);
        this.namedElement = namedElement;
        this.domain = domain;
        this.entry = LabelInternationalizationUtils.getInternationalizationEntry((EObject)namedElement, (Object)namedElement);
    }

    public synchronized void dispose() {
        if (this.listener != null) {
            if (this.entry.eAdapters().contains((Object)this.listener)) {
                this.entry.eAdapters().remove((Object)this.listener);
            }
            this.listener = null;
        }
        this.entry = null;
        this.namedElement = null;
        super.dispose();
    }

    public Object getObserved() {
        return this.namedElement;
    }

    protected void firstListenerAdded() {
        if (this.entry != null) {
            if (this.listener == null) {
                this.listener = new AdapterImpl(){

                    public void notifyChanged(Notification notification) {
                        if (InternationalizationPackage.eINSTANCE.getInternationalizationEntry_Value() == notification.getFeature() && !notification.isTouch()) {
                            final ValueDiff diff = Diffs.createValueDiff((Object)notification.getOldValue(), (Object)notification.getNewValue());
                            UMLLabelObservableValue.this.getRealm().exec(new Runnable(){

                                @Override
                                public void run() {
                                    UMLLabelObservableValue.this.fireValueChange(diff);
                                }
                            });
                        }
                    }
                };
            }
            this.entry.eAdapters().add((Object)this.listener);
        }
    }

    protected Object doGetValue() {
        return UMLLabelInternationalization.getInstance().getLabelWithoutUML(this.namedElement);
    }

    protected void doSetValue(Object value) {
        try {
            if (this.entry != null && this.listener != null && this.entry.eAdapters().contains((Object)this.listener)) {
                this.entry.eAdapters().remove((Object)this.listener);
            }
            Command emfCommand = UMLLabelInternationalization.getInstance().getSetLabelCommand(this.domain, this.namedElement, (String)value, null);
            this.domain.getCommandStack().execute(emfCommand);
            this.entry = LabelInternationalizationUtils.getInternationalizationEntry((EObject)this.namedElement, (Object)this.namedElement);
            this.firstListenerAdded();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public Object getValueType() {
        return UMLPackage.eINSTANCE.getNamedElement__GetLabel();
    }

    public void retain() {
        this.refCount.retain();
    }

    public void release() {
        this.refCount.release();
    }

    public void autorelease() {
        this.refCount.autorelease();
    }
}

