/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotHistoryService {
    private static final String FILE_NAME = String.valueOf(MemoryAnalyserPlugin.getDefault().getStateLocation().toOSString()) + File.separator + "snapshotHistory.ser";
    private static final int NUMBER = 100;
    private static SnapshotHistoryService INSTANCE = new SnapshotHistoryService();
    private LinkedList<Entry> list;
    private List<IChangeListener> listeners = new ArrayList<IChangeListener>();

    public static SnapshotHistoryService getInstance() {
        return INSTANCE;
    }

    private SnapshotHistoryService() {
        this.initializeDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addVisitedPath(String editorId, String path, Serializable info) {
        Entry e = new Entry(editorId, path);
        e.fileLength = new File(e.filePath).length();
        e.info = info;
        ArrayList<Entry> copy = null;
        LinkedList<Entry> linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.contains(e)) {
                this.list.remove(e);
            }
            this.list.addFirst(e);
            if (this.list.size() > 100) {
                this.list.removeLast();
            }
            copy = new ArrayList<Entry>(this.list);
        }
        SnapshotHistoryService.saveDocument(copy);
        this.informListeners(copy);
    }

    public void addVisitedPath(String editorId, String path) {
        this.addVisitedPath(editorId, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(IPath path) {
        String filename = path.toOSString();
        ArrayList<Entry> copy = null;
        LinkedList<Entry> linkedList = this.list;
        synchronized (linkedList) {
            Iterator iter = this.list.iterator();
            while (iter.hasNext()) {
                Entry entry = (Entry)iter.next();
                if (!entry.getFilePath().equals(filename)) continue;
                iter.remove();
                copy = new ArrayList<Entry>(this.list);
                break;
            }
        }
        if (copy != null) {
            SnapshotHistoryService.saveDocument(copy);
            this.informListeners(copy);
        }
    }

    private void informListeners(List<Entry> copy) {
        for (IChangeListener listener : new ArrayList<IChangeListener>(this.listeners)) {
            listener.onFileHistoryChange(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getVisitedEntries() {
        LinkedList<Entry> linkedList = this.list;
        synchronized (linkedList) {
            return new ArrayList<Entry>(this.list);
        }
    }

    public void addChangeListener(IChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void initializeDocument() {
        File file = new File(FILE_NAME);
        if (file.exists()) {
            try {
                final StringBuilder buf = new StringBuilder();
                this.list = new LinkedList();
                ObjectInputStream oin = new ObjectInputStream(new FileInputStream(file)){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        String match = "java.lang.*;java.util.*;org.eclipse.mat.snapshot.SnapshotInfo;org.eclipse.mat.ui.SnapshotHistoryService$Entry;!*";
                        String nm = desc.getName();
                        if (!nm.startsWith("[")) {
                            String[] stringArray = match.split(";");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String pt = stringArray[n2];
                                boolean not = pt.startsWith("!");
                                if (not) {
                                    pt = pt.substring(1);
                                }
                                boolean m = pt.endsWith(".**") ? nm.startsWith(pt.substring(0, pt.length() - 2)) : (pt.endsWith(".*") ? nm.startsWith(pt.substring(0, pt.length() - 1)) && !nm.substring(pt.length() - 1).contains(".") : (pt.endsWith("*") ? nm.startsWith(pt.substring(0, pt.length() - 1)) : nm.equals(pt)));
                                if (not && m) {
                                    throw new InvalidClassException(nm, match);
                                }
                                if (m) break;
                                ++n2;
                            }
                        }
                        return super.resolveClass(desc);
                    }
                };
                try {
                    int size = oin.readInt();
                    int ii = 0;
                    while (ii < size) {
                        this.list.add((Entry)oin.readObject());
                        ++ii;
                    }
                }
                finally {
                    oin.close();
                }
                Iterator iter = this.list.iterator();
                while (iter.hasNext()) {
                    Entry e = (Entry)iter.next();
                    if (new File(e.filePath).exists()) continue;
                    iter.remove();
                    buf.append(e.filePath).append('\n');
                }
                if (buf.length() > 0) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.SnapshotHistoryService_SnapshotsDoNotExist, (String)(String.valueOf(Messages.SnapshotHistoryService_NonExistingSnapshotsWillBeDeleted) + buf.toString()));
                        }
                    });
                }
            }
            catch (IOException ignore) {
                MemoryAnalyserPlugin.log(ignore);
                new File(FILE_NAME).delete();
            }
            catch (Exception ignore) {
                MemoryAnalyserPlugin.log(ignore);
            }
        }
        if (this.list == null) {
            this.list = new LinkedList();
        }
    }

    private static void saveDocument(List<Entry> copy) {
        block7: {
            try {
                if (!copy.isEmpty()) {
                    ObjectOutputStream oout = new ObjectOutputStream(new FileOutputStream(FILE_NAME));
                    try {
                        oout.writeInt(copy.size());
                        for (Entry entry : copy) {
                            oout.writeObject(entry);
                        }
                        oout.flush();
                        break block7;
                    }
                    finally {
                        oout.close();
                    }
                }
                File file = new File(FILE_NAME);
                file.delete();
            }
            catch (IOException ignore) {
                MemoryAnalyserPlugin.log(ignore);
            }
        }
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String editorId;
        private String filePath;
        private Long fileLength;
        private Serializable info;

        private Entry(String editorId, String filePath) {
            this.editorId = editorId;
            this.filePath = filePath;
        }

        public Long getFileLength() {
            return this.fileLength;
        }

        public String getEditorId() {
            return this.editorId;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public Serializable getInfo() {
            return this.info;
        }

        public boolean equals(Object obj) {
            return obj instanceof Entry && ((Entry)obj).filePath.equals(this.filePath);
        }

        public int hashCode() {
            return this.filePath.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IChangeListener {
        public void onFileHistoryChange(List<Entry> var1);
    }
}

