/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.results;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;

public class ListResult
implements IResultTable,
IIconProvider {
    private List<?> subjects;
    private List<Column> columns;
    private List<ValueProvider> providers;

    public <L> ListResult(Class<? extends L> type, List<L> subjects, String ... properties) {
        this.subjects = subjects;
        this.columns = new ArrayList<Column>();
        this.providers = new ArrayList<ValueProvider>();
        this.setup(type, properties);
    }

    private void setup(Class<?> type, String ... properties) {
        try {
            HashMap<String, PropertyDescriptor> name2prop = new HashMap<String, PropertyDescriptor>();
            BeanInfo info = Introspector.getBeanInfo(type);
            Object[] objectArray = info.getPropertyDescriptors();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor d = objectArray[n2];
                Method readMethod = d.getReadMethod();
                if (readMethod != null) {
                    name2prop.put(d.getName(), d);
                }
                ++n2;
            }
            if (properties == null || properties.length == 0) {
                properties = name2prop.keySet().toArray(new String[name2prop.size()]);
            }
            objectArray = properties;
            n = properties.length;
            n2 = 0;
            while (n2 < n) {
                Object property = objectArray[n2];
                PropertyDescriptor d = (PropertyDescriptor)name2prop.get(property);
                if (d != null) {
                    String columnName = d.getDisplayName();
                    if (columnName.equals(d.getName())) {
                        columnName = this.fixName(d.getName());
                    }
                    this.columns.add(new Column(columnName, d.getPropertyType()));
                    this.providers.add(new MethodValueProvider(d.getReadMethod()));
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private String fixName(String name) {
        StringBuilder buf = new StringBuilder(name.length() + 10);
        int ii = 0;
        while (ii < name.length()) {
            char ch = name.charAt(ii);
            if (ii == 0) {
                buf.append(Character.toUpperCase(ch));
            } else if (Character.isUpperCase(ch)) {
                buf.append(' ').append(ch);
            } else {
                buf.append(ch);
            }
            ++ii;
        }
        return buf.toString();
    }

    public void addColumn(Column column, ValueProvider valueProvider) {
        this.columns.add(column);
        this.providers.add(valueProvider);
    }

    @Override
    public ResultMetaData getResultMetaData() {
        return null;
    }

    @Override
    public final Column[] getColumns() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    @Override
    public final int getRowCount() {
        return this.subjects.size();
    }

    @Override
    public final Object getRow(int rowId) {
        return this.subjects.get(rowId);
    }

    @Override
    public final Object getColumnValue(Object row, int columnIndex) {
        return this.providers.get(columnIndex).getValueFor(row);
    }

    @Override
    public URL getIcon(Object row) {
        return null;
    }

    @Override
    public IContextObject getContext(Object row) {
        return null;
    }

    private static class MethodValueProvider
    implements ValueProvider {
        private Method readMethod;

        public MethodValueProvider(Method readMethod) {
            this.readMethod = readMethod;
        }

        @Override
        public Object getValueFor(Object row) {
            try {
                return this.readMethod.invoke(row, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface ValueProvider {
        public Object getValueFor(Object var1);
    }
}

