/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="extract_list_values")
@Icon(value="/META-INF/icons/list.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
@Subjects(value={"java.util.AbstractList", "java.util.AbstractQueue", "java.util.IdentityHashMap$Values", "java.util.LinkedHashMap$LinkedValues", "java.util.HashMap$Values", "java.util.WeakHashMap$Values", "java.util.TreeMap$Values", "java.util.ArrayDeque", "java.util.AbstractMap$2", "java.util.AbstractQueue", "java.util.Hashtable$ValueCollection", "java.util.Collections$SynchronizedList", "java.util.Collections$UnmodifiableList", "java.util.Collections$CheckedList", "java.util.Collections$CheckedQueue", "java.util.ImmutableCollections$AbstractImmutableList", "java.util.ImmutableCollect0ions$List0", "java.util.concurrent.CopyOnWriteArrayList", "java.util.concurrent.ConcurrentLinkedDeque", "java.util.EnumMap$Values", "java.lang.ProcessEnvironment$CheckedValues", "java.lang.ProcessEnvironment$StringValues"})
public class ExtractListValuesQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IObject list;

    public IResult execute(IProgressListener listener) throws Exception {
        AbstractExtractedCollection<?, ?> extractor = CollectionExtractionUtils.extractCollection(this.list);
        if (extractor != null && extractor.hasExtractableContents()) {
            return new ObjectListResult.Outbound(this.snapshot, extractor.extractEntryIds());
        }
        throw new IllegalArgumentException(MessageUtil.format((String)Messages.ExtractListValuesQuery_NotAWellKnownList, (Object[])new Object[]{this.list.getDisplayName()}));
    }
}

