/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.Random;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class WorkspaceSymbolQuickAccessElement
extends QuickAccessElement {
    private static final SymbolsLabelProvider LABEL_PROVIDER = new SymbolsLabelProvider(false, false);
    private static final Random randomNumbers = new Random();
    private final SymbolInformation symbol;
    private final int idExtension;

    public WorkspaceSymbolQuickAccessElement(SymbolInformation symbol) {
        this.symbol = symbol;
        this.idExtension = randomNumbers.nextInt();
    }

    public String getLabel() {
        return LABEL_PROVIDER.getText(this.symbol);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)LABEL_PROVIDER.getImage(this.symbol));
    }

    public String getId() {
        Range range = this.symbol.getLocation().getRange();
        return String.valueOf(this.symbol.getName()) + '@' + this.symbol.getLocation().getUri() + '[' + range.getStart().getLine() + ',' + range.getStart().getCharacter() + ':' + range.getEnd().getLine() + ',' + range.getEnd().getCharacter() + ']' + ',' + this.idExtension;
    }

    public void execute() {
        LSPEclipseUtils.openInEditor(this.symbol.getLocation(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
    }
}

