/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.BaseVMCommandHandler;
import org.eclipse.linuxtools.internal.vagrant.ui.views.DVMessages;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.linuxtools.vagrant.core.VagrantException;
import org.eclipse.linuxtools.vagrant.core.VagrantService;

public class StopVMCommandHandler
extends BaseVMCommandHandler {
    private static final String CONTAINERS_STOP_MSG = "ContainersStop.msg";
    private static final String CONTAINER_STOP_MSG = "ContainerStop.msg";
    private static final String CONTAINER_STOP_ERROR_MSG = "ContainerStopError.msg";

    @Override
    void executeInJob(IVagrantVM vm, IProgressMonitor monitor) {
        IVagrantConnection connection = VagrantService.getInstance();
        try {
            try {
                connection.haltVM(vm);
            }
            catch (InterruptedException | VagrantException e) {
                String errorMessage = DVMessages.getFormattedString(CONTAINER_STOP_ERROR_MSG, vm.id());
                this.openError(errorMessage, (Exception)e);
                connection.getVMs(true);
            }
        }
        finally {
            connection.getVMs(true);
        }
    }

    @Override
    String getJobName(List<IVagrantVM> selectedVMs) {
        return DVMessages.getString(CONTAINERS_STOP_MSG);
    }

    @Override
    String getTaskName(IVagrantVM vm) {
        return DVMessages.getFormattedString(CONTAINER_STOP_MSG, vm.id());
    }
}

