/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.sections;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.pagedesigner.commands.single.AddSubNodeCommand;
import org.eclipse.jst.pagedesigner.commands.single.RemoveSubNodeCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.sections.SectionResources;
import org.eclipse.jst.pagedesigner.properties.BaseCustomSection;
import org.eclipse.jst.pagedesigner.properties.DesignerPropertyTool;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSFHtmlActionListenerSection
extends BaseCustomSection {
    private static final String[] LISTENTYPES = new String[]{"Action"};
    private IDOMElement _element;
    private Table _listenersTable;
    private TableViewer _listenersViewer;
    private CCombo _listenTypeCombo;
    private Button _listenAddButton;
    private Button _listenRemoveButton;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite top = factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        top.setLayout((Layout)layout);
        this.createListenerPart(factory, top);
    }

    private void createListenerPart(TabbedPropertySheetWidgetFactory factory, Composite other) {
        this._listenersTable = factory.createTable(other, 65538);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 4;
        data.heightHint = 50;
        data.widthHint = 100;
        this._listenersTable.setHeaderVisible(true);
        this._listenersTable.setLayoutData((Object)data);
        this._listenersTable.setLinesVisible(true);
        TableColumn listenColumn = new TableColumn(this._listenersTable, 0);
        listenColumn.setText(SectionResources.getString("JSFHtmlCommandButtonSection.Listeners"));
        listenColumn.setWidth(500);
        this._listenersViewer = new TableViewer(this._listenersTable);
        this._listenersViewer.setContentProvider((IContentProvider)new ListenerContentLabelProvider());
        this._listenersViewer.setLabelProvider((IBaseLabelProvider)new ListenerContentLabelProvider());
        this._listenersViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    IDOMElement node = (IDOMElement)selection.getFirstElement();
                    JSFHtmlActionListenerSection.this.gotoNode((Node)node);
                }
            }
        });
        this._listenersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSFHtmlActionListenerSection.this.updateListenerButtonStatus();
            }
        });
        this._listenTypeCombo = factory.createCCombo(other, 8);
        this._listenTypeCombo.setItems(LISTENTYPES);
        this._listenTypeCombo.select(0);
        data = new GridData(256);
        this._listenTypeCombo.setLayoutData((Object)data);
        this._listenAddButton = factory.createButton(other, SectionResources.getString("JSFHtmlCommandButtonSection.Add"), 0);
        data = new GridData(256);
        this._listenAddButton.setLayoutData((Object)data);
        this._listenAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap attributes = new HashMap();
                String listener = JSFHtmlActionListenerSection.this._listenTypeCombo.getText();
                listener = String.valueOf(listener.substring(0, 1).toLowerCase()) + listener.substring(1) + "Listener";
                AddSubNodeCommand c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlCommandButtonSection.CommandLabel.AddSubTag"), JSFHtmlActionListenerSection.this._element, listener, "http://java.sun.com/jsf/core", attributes);
                c.execute();
                JSFHtmlActionListenerSection.this._listenersViewer.refresh();
                JSFHtmlActionListenerSection.this.updateListenerButtonStatus();
            }
        });
        this._listenRemoveButton = factory.createButton(other, SectionResources.getString("JSFHtmlCommandButtonSection.Remove"), 0);
        data = new GridData(256);
        this._listenRemoveButton.setLayoutData((Object)data);
        this._listenRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JSFHtmlActionListenerSection.this._listenersViewer.getSelection();
                if (selection != null) {
                    for (IDOMElement node : selection) {
                        RemoveSubNodeCommand c = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlCommandButtonSection.CommandLabel.RemoveSubTag"), JSFHtmlActionListenerSection.this._element, node);
                        c.execute();
                    }
                    JSFHtmlActionListenerSection.this._listenersViewer.refresh();
                    JSFHtmlActionListenerSection.this.updateListenerButtonStatus();
                }
            }
        });
    }

    private void updateListenerButtonStatus() {
        this._listenRemoveButton.setEnabled(true);
        ISelection selection = this._listenersViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            this._listenRemoveButton.setEnabled(false);
        }
        if (this._listenersTable.getItemCount() == 0) {
            this._listenRemoveButton.setEnabled(false);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this._element = (IDOMElement)DesignerPropertyTool.getElement((IWorkbenchPart)part, (ISelection)selection);
        if (this._listenersViewer != null) {
            this._listenersViewer.setInput((Object)this._element);
        }
    }

    protected void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this._listenersViewer != null && !this._listenersViewer.getControl().isDisposed()) {
            this._listenersViewer.refresh();
        }
    }

    private class ListenerContentLabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private ListenerContentLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDOMElement root = JSFHtmlActionListenerSection.this._element;
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList children = root.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                IDOMElement element;
                String nodeName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (nodeName = (element = (IDOMElement)child).getNodeName()).indexOf("Listener") != -1) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return new Object[0];
            }
            return result.toArray(new IDOMElement[result.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof Node) {
                Node node = (Node)element;
                String nodeName = this.getTableNodeName(node, "type");
                switch (columnIndex) {
                    case 0: {
                        result = nodeName;
                        break;
                    }
                }
            }
            return result != null ? result : "";
        }

        private String getTableNodeName(Node node, String ... attrNames) {
            String[] stringArray = attrNames;
            int n = attrNames.length;
            int n2 = 0;
            while (n2 < n) {
                String attrName = stringArray[n2];
                Node attr = node.getAttributes().getNamedItem(attrName);
                if (attr != null && attr.getNodeValue() != null && !attr.getNodeValue().trim().equals("")) {
                    return attr.getNodeValue().trim();
                }
                ++n2;
            }
            return node.getNodeName();
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

