/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.provider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.editor.EEPlugin;
import org.eclipse.emf.editor.extxpt.ExtXptFacade;
import org.eclipse.emf.editor.provider.ClasspathUriResolver;
import org.eclipse.emf.editor.provider.RegistryItemLabelProvider;
import org.eclipse.emf.editor.ui.ImageRegistry;

public class ExtendedLabelProvider
implements IItemLabelProvider {
    private static final String ICONS_FOLDER = "icons";
    private static final String ICON_EXTENSION_NAME = "icon";
    private static final String LABEL_EXTENSION_NAME = "label";
    private final ExtXptFacade facade;
    private IItemLabelProvider registryItemLabelProvider;

    public ExtendedLabelProvider(ExtXptFacade facade) {
        this.facade = facade;
        this.registryItemLabelProvider = new RegistryItemLabelProvider();
    }

    public Object getImage(Object element) {
        Object retVal = null;
        try {
            EObject eObject;
            String iconName;
            if (element instanceof EObject && (iconName = this.evaluate(eObject = (EObject)element, ICON_EXTENSION_NAME)) != null) {
                retVal = this.locateImage(iconName, eObject.eResource(), eObject);
                Resource eResource = eObject.eClass().eResource();
                if (retVal == null) {
                    retVal = this.locateImage(iconName, eResource, eObject);
                }
            }
        }
        catch (Throwable ex) {
            EEPlugin.logError("ERROR fetching Icon", ex);
        }
        if (retVal == null) {
            retVal = this.registryItemLabelProvider.getImage(element);
        }
        return retVal;
    }

    private Object locateImage(String iconName, Resource eResource, EObject eObject) throws MalformedURLException, IOException {
        URI retVal = null;
        if (eResource != null) {
            URI metaModelURI = eResource.getURI();
            URI iconURI = this.createIconURI(eObject, iconName, metaModelURI);
            if (metaModelURI.isPlatform()) {
                IFile f;
                String platformString = metaModelURI.toPlatformString(true);
                IFile metaModelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
                if (metaModelFile != null && (f = metaModelFile.getProject().getFile(iconURI.path())) != null && f.exists()) {
                    retVal = ImageRegistry.getDefault().getImage(f);
                }
            } else if (metaModelURI.isArchive()) {
                if (this.checkAccessable(iconURI)) {
                    retVal = iconURI;
                }
            } else {
                URI classpathURI = URI.createURI((String)("classpath:" + iconURI.path()));
                URI iconNormalizedURI = new ClasspathUriResolver().resolve((IResource)this.facade.getProject(), classpathURI);
                if (!ClasspathUriResolver.isClasspathUri(iconNormalizedURI) && this.checkAccessable(iconNormalizedURI)) {
                    retVal = iconNormalizedURI;
                }
            }
        }
        return retVal;
    }

    private boolean checkAccessable(URI iconURI) throws IOException {
        URL url = new URL(iconURI.toString());
        try {
            InputStream in = url.openStream();
            in.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    private URI createIconURI(EObject eObject, String iconName, URI metaModelURI) {
        String packageName = this.packageName(eObject);
        return metaModelURI.trimSegments(metaModelURI.segmentCount()).appendSegment(ICONS_FOLDER).appendSegment(packageName).appendSegment(iconName);
    }

    public String getText(Object element) {
        String text = this.evaluate(element, LABEL_EXTENSION_NAME);
        return text;
    }

    private String evaluate(Object element, String name) {
        String retVal = null;
        if (element instanceof EObject && this.facade != null) {
            EObject eO = (EObject)element;
            retVal = (String)this.facade.style(name, eO);
        }
        return retVal;
    }

    private String packageName(EObject object) {
        return object.eClass().getEPackage().getName();
    }
}

