/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.widgets;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitHistory;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.ui.history.NetRenderer;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.ui.StructuredContentProvider;
import org.eclipse.net4j.util.ui.TableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CommitHistoryComposite
extends Composite {
    private CDOCommitHistory history;
    private IListener historyListener = new ContainerEventAdapter<CDOCommitInfo>(){

        protected void onAdded(IContainer<CDOCommitInfo> history, CDOCommitInfo commitInfo) {
            CommitHistoryComposite.this.netRenderer.addCommit(commitInfo);
        }
    };
    private CDOCommitInfoHandler revealElementHandler = new CDOCommitInfoHandler(){

        public void handleCommitInfo(final CDOCommitInfo commitInfo) {
            CommitHistoryComposite.this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CommitHistoryComposite.this.tableViewer.reveal((Object)commitInfo);
                }
            });
        }
    };
    private int viewerStyle;
    private TableViewer tableViewer;
    private LabelProvider labelProvider;
    private NetRenderer netRenderer;
    private Input input;

    public CommitHistoryComposite(Composite parent, int viewerStyle) {
        super(parent, 0);
        this.viewerStyle = viewerStyle;
        this.setLayout((Layout)new FillLayout(256));
        this.tableViewer = this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CommitHistoryComposite.this.tableViewer.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof CDOCommitInfo) {
                    CommitHistoryComposite.this.commitInfoChanged((CDOCommitInfo)selectedElement);
                }
            }
        });
        this.tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                CommitHistoryComposite.this.doubleClicked();
            }
        });
        this.labelProvider = this.createLabelProvider();
        this.labelProvider.support(this.tableViewer);
        this.netRenderer = new NetRenderer(this.tableViewer);
    }

    public final int getViewerStyle() {
        return this.viewerStyle;
    }

    public final TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public final LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public final Input getInput() {
        return this.input;
    }

    public final void setInput(Input input) {
        if (!ObjectUtil.equals((Object)((Object)this.input), (Object)((Object)input))) {
            this.input = input;
            CDOCommitHistory oldHistory = this.history;
            if (input == null) {
                this.history = CDOCommitHistory.EMPTY;
            } else {
                CDOSession session = input.getSession();
                CDOBranch branch = input.getBranch();
                CDOObject object = input.getObject();
                this.labelProvider.setLocalUserID(session.getUserID());
                this.labelProvider.setInputBranch(branch);
                this.history = this.createHistory(session, branch, object);
                this.history.setAppendingTriggerLoadElement(true);
            }
            this.history.addListener(this.historyListener);
            this.refreshLayout();
            if (oldHistory != null && oldHistory != this.history) {
                oldHistory.removeListener(this.historyListener);
                LifecycleUtil.deactivate((Object)oldHistory);
            }
        }
    }

    public void refreshLayout() {
        this.refreshLayout(false);
    }

    public void refreshLayout(boolean refreshCommits) {
        Table table = this.tableViewer.getTable();
        int topIndex = table.getTopIndex();
        this.netRenderer.setInput(this.input);
        if (refreshCommits) {
            CDOCommitInfo[] elements = (CDOCommitInfo[])this.history.getElements();
            int i = 0;
            while (i < elements.length) {
                CDOCommitInfo commitInfo = elements[i];
                this.netRenderer.addCommit(commitInfo);
                ++i;
            }
        }
        this.tableViewer.setInput((Object)this.history);
        table.setTopIndex(topIndex);
    }

    public final CDOCommitHistory getHistory() {
        return this.history;
    }

    public boolean setFocus() {
        return this.tableViewer.getTable().setFocus();
    }

    public void dispose() {
        this.input = null;
        this.history = null;
        super.dispose();
    }

    protected TableViewer createTableViewer() {
        return new TableViewer((Composite)this, this.getViewerStyle() | 0x10000 | 2);
    }

    protected ContentProvider createContentProvider() {
        return new ContentProvider();
    }

    protected LabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    protected CDOCommitHistory createHistory(CDOSession session, CDOBranch branch, CDOObject object) {
        if (object == null) {
            CDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
            return commitInfoManager.getHistory((Object)branch);
        }
        return object.cdoHistory();
    }

    protected void commitInfoChanged(CDOCommitInfo newCommitInfo) {
    }

    protected void doubleClicked(CDOCommitInfo commitInfo) {
    }

    private void doubleClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        CDOCommitInfo commitInfo = (CDOCommitInfo)selection.getFirstElement();
        if (commitInfo != null) {
            if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                this.history.triggerLoad(this.revealElementHandler);
            } else {
                this.doubleClicked(commitInfo);
            }
        }
    }

    public static class ContentProvider
    extends StructuredContentProvider<CDOCommitHistory> {
        public Object[] getElements(Object inputElement) {
            return ((CDOCommitHistory)inputElement).getElements();
        }

        protected void connectInput(CDOCommitHistory history) {
            history.addListener((IListener)this);
        }

        protected void disconnectInput(CDOCommitHistory history) {
            history.removeListener((IListener)this);
        }
    }

    public static class Input
    extends Notifier
    implements ILifecycle {
        private IListener lifecycleListener = new IListener(this){
            final /* synthetic */ Input this$1;
            {
                this.this$1 = input;
            }

            public void notifyEvent(IEvent event) {
                if (event instanceof ILifecycleEvent) {
                    ILifecycleEvent.Kind kind = ((ILifecycleEvent)event).getKind();
                    if (kind == ILifecycleEvent.Kind.DEACTIVATED) {
                        this.this$1.deactivate();
                    }
                    this.this$1.fireEvent((IEvent)new LifecycleEvent((ILifecycle)this.this$1, kind));
                }
            }
        };
        private final CDOSession session;
        private final CDOBranch branch;
        private final CDOObject object;
        private final boolean offline;

        public Input(Object delegate) throws IllegalInputException {
            CDOView view;
            EObject eObject;
            CDOObject cdoObject;
            CDOSession sessionAdapter = (CDOSession)AdapterUtil.adapt((Object)delegate, CDOSession.class);
            if (sessionAdapter != null) {
                this.session = sessionAdapter;
                this.offline = this.determineOffline();
                this.branch = null;
                this.object = null;
                return;
            }
            CDOBranch branchAdapter = (CDOBranch)AdapterUtil.adapt((Object)delegate, CDOBranch.class);
            if (branchAdapter != null) {
                this.branch = branchAdapter;
                this.session = (CDOSession)((CDOSessionProtocol)((InternalCDOBranchManager)this.branch.getBranchManager()).getBranchLoader()).getSession();
                this.offline = this.determineOffline();
                this.object = null;
                return;
            }
            CDOView viewAdapter = (CDOView)AdapterUtil.adapt((Object)delegate, CDOView.class);
            if (viewAdapter != null) {
                CDOView view2 = viewAdapter;
                this.session = view2.getSession();
                this.offline = this.determineOffline();
                this.branch = this.offline ? null : view2.getBranch();
                this.object = null;
                return;
            }
            if (delegate instanceof EObject && (cdoObject = CDOUtil.getCDOObject((EObject)(eObject = (EObject)delegate))) != null && (view = cdoObject.cdoView()) != null && cdoObject.cdoState() != CDOState.NEW) {
                this.session = view.getSession();
                this.offline = this.determineOffline();
                this.branch = this.offline ? null : view.getBranch();
                this.object = this.offline ? null : cdoObject;
                return;
            }
            throw new IllegalInputException("Illegal input: " + delegate);
        }

        public Input(CDOSession session, CDOBranch branch, CDOObject object) {
            this.session = session;
            this.offline = this.determineOffline();
            this.branch = this.offline ? null : branch;
            this.object = this.offline ? null : object;
        }

        public final CDOSession getSession() {
            return this.session;
        }

        public final CDOBranch getBranch() {
            return this.branch;
        }

        public final CDOObject getObject() {
            return this.object;
        }

        public final boolean isOffline() {
            return this.offline;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
            result = 31 * result + (this.branch == null ? 0 : this.branch.hashCode());
            result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Input)) {
                return false;
            }
            Input other = (Input)((Object)obj);
            if (this.session == null ? other.session != null : !this.session.equals(other.session)) {
                return false;
            }
            if (this.branch == null ? other.branch != null : !this.branch.equals(other.branch)) {
                return false;
            }
            return this.object == other.object;
        }

        public String toString() {
            if (this.offline) {
                return "Offline: " + this.session;
            }
            String string = "Repository: " + this.session.getRepositoryInfo().getName() + ", Branch: " + (this.branch != null ? this.branch.getPathName() : "MAIN");
            if (this.object != null) {
                string = String.valueOf(string) + ", Object: " + this.object;
            }
            return string;
        }

        public void activate() throws LifecycleException {
            EventUtil.addListener((Object)this.getLifecycle(), (IListener)this.lifecycleListener);
        }

        public Exception deactivate() {
            EventUtil.removeListener((Object)this.getLifecycle(), (IListener)this.lifecycleListener);
            return null;
        }

        public LifecycleState getLifecycleState() {
            Object object = this.getLifecycle();
            return LifecycleUtil.getLifecycleState((Object)object);
        }

        public boolean isActive() {
            Object object = this.getLifecycle();
            return LifecycleUtil.isActive((Object)object);
        }

        protected final Object getLifecycle() {
            if (this.offline) {
                return null;
            }
            if (this.object != null) {
                return this.object.cdoView();
            }
            return this.session;
        }

        private boolean determineOffline() {
            IRegistry properties = this.session.properties();
            return properties.containsKey((Object)"org.eclipse.emf.cdo.workspace.CDOWorkspace");
        }

        public static class IllegalInputException
        extends Exception {
            private static final long serialVersionUID = 1L;

            public IllegalInputException(String message) {
                super(message);
            }
        }
    }

    public static class LabelProvider
    extends TableLabelProvider<CDOCommitInfo> {
        private static final ImageDescriptor COMMIT = SharedIcons.getDescriptor((String)"obj16/commit.gif");
        private static final ImageDescriptor PERSON = SharedIcons.getDescriptor((String)"obj16/person.gif");
        private static final ImageDescriptor PERSON_ME = SharedIcons.getDescriptor((String)"obj16/person-me.gif");
        private static final ImageDescriptor BRANCH = SharedIcons.getDescriptor((String)"obj16/branch.gif");
        private static final ImageDescriptor BRANCH_GRAY = SharedIcons.getDescriptor((String)"obj16/branch-gray.gif");
        private String localUserID;
        private CDOBranch inputBranch;
        private boolean formatTimeStamps = true;
        private boolean shortenBranchPaths = true;

        public LabelProvider() {
            this.addColumn((TableLabelProvider.Column)new TableLabelProvider.Column<CDOCommitInfo>("Time", 160){

                public String getText(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return "";
                    }
                    return this.getTimeStampString(commitInfo.getTimeStamp());
                }

                public Image getImage(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return null;
                    }
                    return (Image)this.getResource((DeviceResourceDescriptor)COMMIT);
                }
            });
            this.addColumn((TableLabelProvider.Column)new TableLabelProvider.Column<CDOCommitInfo>("Comment", 250){

                public String getText(CDOCommitInfo commitInfo) {
                    return commitInfo.getComment();
                }
            });
            this.addColumn((TableLabelProvider.Column)new TableLabelProvider.Column<CDOCommitInfo>("User", 120){

                public String getText(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return "";
                    }
                    return commitInfo.getUserID();
                }

                public Image getImage(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return null;
                    }
                    String userID = commitInfo.getUserID();
                    if (userID != null) {
                        if (userID.equals(localUserID)) {
                            return (Image)this.getResource((DeviceResourceDescriptor)PERSON_ME);
                        }
                        return (Image)this.getResource((DeviceResourceDescriptor)PERSON);
                    }
                    return null;
                }
            });
            this.addColumn((TableLabelProvider.Column)new TableLabelProvider.Column<CDOCommitInfo>("Branch", 160){

                public String getText(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return "";
                    }
                    CDOBranch commitBranch = commitInfo.getBranch();
                    long timeStamp = commitInfo.getTimeStamp();
                    StringBuilder builder = null;
                    CDOBranch[] cDOBranchArray = commitBranch.getBranches();
                    int n = cDOBranchArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CDOBranch childBranch = cDOBranchArray[n2];
                        if (childBranch.getBase().getTimeStamp() == timeStamp) {
                            if (builder == null) {
                                builder = new StringBuilder(this.getBranchString(commitBranch));
                            }
                            builder.append(", ");
                            builder.append(this.getBranchString(childBranch));
                        }
                        ++n2;
                    }
                    if (builder != null) {
                        return builder.toString();
                    }
                    return this.getBranchString(commitBranch);
                }

                public Image getImage(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return null;
                    }
                    if (inputBranch == null || inputBranch == commitInfo.getBranch()) {
                        return (Image)this.getResource((DeviceResourceDescriptor)BRANCH);
                    }
                    return (Image)this.getResource((DeviceResourceDescriptor)BRANCH_GRAY);
                }
            });
            this.addColumn((TableLabelProvider.Column)new TableLabelProvider.Column<CDOCommitInfo>("Merge", 160){

                public String getText(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return null;
                    }
                    CDOBranchPoint mergeSource = commitInfo.getMergeSource();
                    if (mergeSource != null) {
                        return String.valueOf(this.getBranchString(mergeSource.getBranch())) + ", " + this.getTimeStampString(mergeSource.getTimeStamp());
                    }
                    return null;
                }
            });
        }

        public String getLocalUserID() {
            return this.localUserID;
        }

        public void setLocalUserID(String localUserID) {
            this.localUserID = localUserID;
        }

        public CDOBranch getInputBranch() {
            return this.inputBranch;
        }

        public void setInputBranch(CDOBranch inputBranch) {
            this.inputBranch = inputBranch;
        }

        public boolean isFormatTimeStamps() {
            return this.formatTimeStamps;
        }

        public void setFormatTimeStamps(boolean formatTimeStamps) {
            this.formatTimeStamps = formatTimeStamps;
        }

        public boolean isShortenBranchPaths() {
            return this.shortenBranchPaths;
        }

        public void setShortenBranchPaths(boolean shortenBranchPaths) {
            this.shortenBranchPaths = shortenBranchPaths;
        }

        public String getBranchString(CDOBranch branch) {
            if (this.shortenBranchPaths) {
                return branch.getName();
            }
            return branch.getPathName();
        }

        public String getTimeStampString(long timeStamp) {
            if (this.formatTimeStamps) {
                return CDOCommonUtil.formatTimeStamp((long)timeStamp);
            }
            return "" + timeStamp;
        }
    }
}

