/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.dialogs.SelectBranchDialog;
import org.eclipse.emf.cdo.internal.ui.dialogs.SelectBranchPointDialog;
import org.eclipse.emf.cdo.ui.widgets.ComposeBranchPointComposite;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractBranchPointDialog
extends TitleAreaDialog {
    private final boolean allowTimeStamp;
    private final CDOBranchPoint branchPoint;
    private ComposeBranchPointComposite branchPointComposite;
    private String timeStampError;

    public AbstractBranchPointDialog(Shell parentShell, boolean allowTimeStamp, CDOBranchPoint branchPoint) {
        super(parentShell);
        this.allowTimeStamp = allowTimeStamp;
        this.branchPoint = branchPoint;
        this.setShellStyle(65648);
    }

    public final boolean isAllowTimeStamp() {
        return this.allowTimeStamp;
    }

    public final CDOBranchPoint getBranchPoint() {
        if (this.branchPointComposite != null) {
            return this.branchPointComposite.getBranchPoint();
        }
        return this.branchPoint;
    }

    protected Point getInitialSize() {
        return new Point(450, 450);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout containerGridLayout = new GridLayout(2, false);
        containerGridLayout.marginWidth = 10;
        containerGridLayout.marginHeight = 10;
        containerGridLayout.verticalSpacing = 10;
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)containerGridLayout);
        this.createUI(container);
        this.validate();
        return area;
    }

    protected void createUI(Composite container) {
        this.branchPointComposite = new ComposeBranchPointComposite(container, this.allowTimeStamp, this.branchPoint){

            @Override
            protected void timeStampError(String message) {
                AbstractBranchPointDialog.this.timeStampError = message;
                AbstractBranchPointDialog.this.validate();
            }

            @Override
            protected void branchPointChanged(CDOBranchPoint branchPoint) {
                if (AbstractBranchPointDialog.this.validate()) {
                    AbstractBranchPointDialog.this.branchPointChanged(branchPoint);
                }
            }

            @Override
            protected void doubleClicked() {
                AbstractBranchPointDialog.this.doubleClicked();
            }
        };
        this.branchPointComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        CDOBranch branch = this.branchPoint.getBranch();
        TreeViewer branchViewer = this.branchPointComposite.getBranchViewer();
        branchViewer.setSelection((ISelection)new StructuredSelection((Object)branch));
        branchViewer.setExpandedState((Object)branch, true);
    }

    protected final boolean validate() {
        String error = this.timeStampError;
        if (error == null) {
            try {
                this.doValidate();
            }
            catch (Exception ex) {
                error = ex.getMessage();
            }
        }
        this.setErrorMessage(error);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(error == null);
        }
        return error == null;
    }

    protected void doValidate() throws Exception {
    }

    protected void branchPointChanged(CDOBranchPoint branchPoint) {
    }

    protected void doubleClicked() {
        this.close();
    }

    public static CDOBranchPoint select(Shell shell, boolean allowTimeStamp, CDOBranchPoint branchPoint) {
        AbstractBranchPointDialog dialog = allowTimeStamp ? new SelectBranchPointDialog(shell, branchPoint) : new SelectBranchDialog(shell, branchPoint);
        if (dialog.open() == 0) {
            return dialog.getBranchPoint();
        }
        return null;
    }
}

