/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ChangeSubscriptionRequest
extends CDOClientRequest<Boolean> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, ChangeSubscriptionRequest.class);
    private int viewID;
    private List<CDOID> ids;
    private boolean subscribeMode;
    private boolean clear;

    public ChangeSubscriptionRequest(CDOClientProtocol protocol, int viewID, List<CDOID> ids, boolean subscribeMode, boolean clear) {
        super(protocol, (short)22);
        this.viewID = viewID;
        this.ids = ids;
        this.subscribeMode = subscribeMode;
        this.clear = clear;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.trace("View " + this.viewID + " subscribing to " + this.ids.size());
        }
        out.writeXInt(this.viewID);
        out.writeBoolean(this.clear);
        out.writeXInt(this.subscribeMode ? this.ids.size() : -this.ids.size());
        for (CDOID id : this.ids) {
            out.writeCDOID(id);
        }
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        return in.readBoolean();
    }
}

